/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;

public class RemoteTabsStaticFragment
extends HomeFragment
implements View.OnClickListener {
    private static final String LOGTAG = "GeckoRemoteTabsStatic";
    protected static final String RESOURCE_ID = "resource_id";
    protected static final int DEFAULT_RESOURCE_ID = R.layout.remote_tabs_setup;
    private static final String CONFIRM_ACCOUNT_SUPPORT_URL = "https://support.mozilla.org/kb/im-having-problems-confirming-my-firefox-account";
    protected int mLayoutId;

    public static RemoteTabsStaticFragment newInstance(int n) {
        RemoteTabsStaticFragment remoteTabsStaticFragment = new RemoteTabsStaticFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(RESOURCE_ID, n);
        remoteTabsStaticFragment.setArguments(bundle);
        return remoteTabsStaticFragment;
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        this.mLayoutId = bundle2 != null ? bundle2.getInt(RESOURCE_ID, DEFAULT_RESOURCE_ID) : DEFAULT_RESOURCE_ID;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(this.mLayoutId, viewGroup, false);
    }

    protected boolean maybeSetOnClickListener(View view, int n) {
        View view2 = view.findViewById(n);
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)this);
            return true;
        }
        return false;
    }

    public void onViewCreated(View view, Bundle bundle) {
        for (int n : new int[]{R.id.remote_tabs_setup_get_started, R.id.remote_tabs_needs_verification_resend_email, R.id.remote_tabs_needs_verification_help, R.id.remote_tabs_needs_password_sign_in, R.id.remote_tabs_needs_finish_migrating_sign_in}) {
            this.maybeSetOnClickListener(view, n);
        }
    }

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.remote_tabs_setup_get_started) {
            Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
            this.startActivity(intent);
        } else if (n == R.id.remote_tabs_needs_verification_resend_email) {
            Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_CONFIRM_ACCOUNT");
            intent.setFlags(0x10000000);
            this.startActivity(intent);
        } else if (n == R.id.remote_tabs_needs_verification_help) {
            EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet = EnumSet.noneOf(HomePager.OnUrlOpenListener.Flags.class);
            this.mUrlOpenListener.onUrlOpen(CONFIRM_ACCOUNT_SUPPORT_URL, enumSet);
        } else if (n == R.id.remote_tabs_needs_password_sign_in) {
            Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_UPDATE_CREDENTIALS");
            intent.setFlags(0x10000000);
            this.startActivity(intent);
        } else if (n == R.id.remote_tabs_needs_finish_migrating_sign_in) {
            Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_FINISH_MIGRATING");
            intent.setFlags(0x10000000);
            this.startActivity(intent);
        }
    }

    @Override
    protected void load() {
    }
}

