/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.home.SearchEngineAdapter;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.widget.RecyclerViewClickSupport;

public class SearchEngineBar
extends RecyclerView
implements RecyclerViewClickSupport.OnItemClickListener {
    private static final String LOGTAG = SearchEngineBar.class.getSimpleName();
    private static final float ICON_CONTAINER_MIN_WIDTH_DP = 72.0f;
    private static final float LABEL_CONTAINER_WIDTH_DP = 48.0f;
    private static final float DIVIDER_HEIGHT_DP = 1.0f;
    private final SearchEngineAdapter mAdapter;
    private final LinearLayoutManager mLayoutManager;
    private final Paint mDividerPaint = new Paint();
    private final float mMinIconContainerWidth;
    private final float mDividerHeight;
    private final int mLabelContainerWidth;
    private int mIconContainerWidth;
    private OnSearchBarClickListener mOnSearchBarClickListener;

    public SearchEngineBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mDividerPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.toolbar_divider_grey));
        this.mDividerPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mMinIconContainerWidth = TypedValue.applyDimension((int)1, (float)72.0f, (DisplayMetrics)displayMetrics);
        this.mDividerHeight = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)displayMetrics);
        this.mLabelContainerWidth = Math.round(TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)displayMetrics));
        this.mIconContainerWidth = Math.round(this.mMinIconContainerWidth);
        this.mAdapter = new SearchEngineAdapter(context);
        this.mAdapter.setIconContainerWidth(this.mIconContainerWidth);
        this.mLayoutManager = new LinearLayoutManager(context);
        this.mLayoutManager.setOrientation(0);
        this.setAdapter(this.mAdapter);
        this.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        RecyclerViewClickSupport.addTo(this).setOnItemClickListener(this);
    }

    public void setSearchEngines(List<SearchEngine> list) {
        this.mAdapter.setSearchEngines(list);
    }

    public void setOnSearchBarClickListener(OnSearchBarClickListener onSearchBarClickListener) {
        this.mOnSearchBarClickListener = onSearchBarClickListener;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.mAdapter.getItemCount() - 1;
        if (n3 > 0) {
            int n4;
            double d = (float)n3 * this.mMinIconContainerWidth <= (float)(n4 = this.getMeasuredWidth() - this.mLabelContainerWidth) ? (double)n3 : Math.floor((float)n4 / this.mMinIconContainerWidth) - 0.5;
            int n5 = (int)((double)n4 / d);
            if (n5 != this.mIconContainerWidth) {
                this.mIconContainerWidth = n5;
            }
            this.mAdapter.setIconContainerWidth(this.mIconContainerWidth);
        }
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), this.mDividerHeight, this.mDividerPaint);
    }

    @Override
    public void onItemClicked(RecyclerView recyclerView, int n, View view) {
        if (this.mOnSearchBarClickListener == null) {
            throw new IllegalStateException(OnSearchBarClickListener.class.getSimpleName() + " is not initializer.");
        }
        if (n == 0) {
            Intent intent = new Intent(this.getContext(), GeckoPreferences.class);
            GeckoPreferences.setResourceToOpen(intent, "preferences_search");
            this.getContext().startActivity(intent);
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "searchenginebar-settings");
            return;
        }
        SearchEngine searchEngine = this.mAdapter.getItem(n);
        this.mOnSearchBarClickListener.onSearchBarClickListener(searchEngine);
    }

    @RobocopTarget
    public SearchEngineAdapter getAdapter() {
        return this.mAdapter;
    }

    public static interface OnSearchBarClickListener {
        public void onSearchBarClickListener(SearchEngine var1);
    }
}

