/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.javaaddons;

import android.content.Context;
import android.util.Log;
import android.util.Pair;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.javaaddons.JavaAddonInterfaceV1;

public class JavaAddonManagerV1
implements NativeEventListener {
    private static final String LOGTAG = "GeckoJavaAddonMgrV1";
    public static final String MESSAGE_LOAD = "JavaAddonManagerV1:Load";
    public static final String MESSAGE_UNLOAD = "JavaAddonManagerV1:Unload";
    private static JavaAddonManagerV1 sInstance;
    private Context mApplicationContext;
    private final EventDispatcher mDispatcher;
    private final Map<String, EventDispatcherImpl> mGUIDToDispatcherMap = new HashMap<String, EventDispatcherImpl>();

    public static synchronized JavaAddonManagerV1 getInstance() {
        if (sInstance == null) {
            sInstance = new JavaAddonManagerV1();
        }
        return sInstance;
    }

    private JavaAddonManagerV1() {
        this.mDispatcher = EventDispatcher.getInstance();
    }

    public synchronized void init(Context context) {
        if (this.mApplicationContext != null) {
            return;
        }
        this.mApplicationContext = context;
        this.mDispatcher.registerGeckoThreadListener(this, MESSAGE_LOAD, MESSAGE_UNLOAD);
    }

    protected String getExtension(String string2) {
        if (string2 == null) {
            return "";
        }
        int n = string2.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string2.substring(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized EventDispatcherImpl registerNewInstance(String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        Log.d((String)LOGTAG, (String)("Attempting to instantiate " + string2 + "from filename " + string3));
        String string4 = this.getExtension(string3);
        File file = GeckoJarReader.extractStream((Context)this.mApplicationContext, (String)string3, (File)this.mApplicationContext.getCacheDir(), (String)("." + string4));
        try {
            if (file == null) {
                throw new IOException("Could not find file " + string3);
            }
            File file2 = this.mApplicationContext.getDir("dex", 0);
            DexClassLoader dexClassLoader = new DexClassLoader(file.getAbsolutePath(), file2.getAbsolutePath(), null, this.mApplicationContext.getClassLoader());
            Class clazz = dexClassLoader.loadClass(string2);
            Constructor constructor = clazz.getDeclaredConstructor(Context.class, JavaAddonInterfaceV1.EventDispatcher.class);
            String string5 = Utils.generateGuid();
            EventDispatcherImpl eventDispatcherImpl = new EventDispatcherImpl(string5, string3);
            Object t = constructor.newInstance(this.mApplicationContext, eventDispatcherImpl);
            this.mGUIDToDispatcherMap.put(string5, eventDispatcherImpl);
            EventDispatcherImpl eventDispatcherImpl2 = eventDispatcherImpl;
            return eventDispatcherImpl2;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public synchronized void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        block13: {
            try {
                switch (string2) {
                    case "JavaAddonManagerV1:Load": {
                        if (eventCallback == null) {
                            throw new IllegalArgumentException("callback must not be null");
                        }
                        String string3 = nativeJSObject.getString("classname");
                        String string4 = nativeJSObject.getString("filename");
                        EventDispatcherImpl eventDispatcherImpl = this.registerNewInstance(string3, string4);
                        eventCallback.sendSuccess((Object)eventDispatcherImpl.guid);
                        break;
                    }
                    case "JavaAddonManagerV1:Unload": {
                        if (eventCallback == null) {
                            throw new IllegalArgumentException("callback must not be null");
                        }
                        String string5 = nativeJSObject.getString("guid");
                        EventDispatcherImpl eventDispatcherImpl = this.mGUIDToDispatcherMap.remove(string5);
                        if (eventDispatcherImpl == null) {
                            Log.w((String)LOGTAG, (String)"Attempting to unload addon with unknown associated dispatcher; ignoring.");
                            eventCallback.sendSuccess((Object)false);
                        }
                        eventDispatcherImpl.unregisterAllEventListeners();
                        eventCallback.sendSuccess((Object)true);
                    }
                }
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)("Exception handling message [" + string2 + "]"), (Throwable)exception);
                if (eventCallback == null) break block13;
                eventCallback.sendError((Object)("Exception handling message [" + string2 + "]: " + exception.toString()));
            }
        }
    }

    private class EventDispatcherImpl
    implements JavaAddonInterfaceV1.EventDispatcher {
        private final String guid;
        private final String dexFileName;
        private final Map<JavaAddonInterfaceV1.EventListener, Pair<NativeEventListener, String[]>> mListenerToWrapperMap = new IdentityHashMap<JavaAddonInterfaceV1.EventListener, Pair<NativeEventListener, String[]>>();

        public EventDispatcherImpl(String string2, String string3) {
            this.guid = string2;
            this.dexFileName = string3;
        }

        public synchronized void registerEventListener(JavaAddonInterfaceV1.EventListener eventListener, String ... stringArray) {
            if (this.mListenerToWrapperMap.containsKey(eventListener)) {
                Log.e((String)JavaAddonManagerV1.LOGTAG, (String)"Attempting to register listener which is already registered; ignoring.");
                return;
            }
            ListenerWrapper listenerWrapper = new ListenerWrapper(eventListener);
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = this.guid + ":" + stringArray[i];
            }
            JavaAddonManagerV1.this.mDispatcher.registerGeckoThreadListener(listenerWrapper, stringArray2);
            this.mListenerToWrapperMap.put(eventListener, (Pair<NativeEventListener, String[]>)new Pair((Object)listenerWrapper, (Object)stringArray2));
        }

        public synchronized void unregisterEventListener(JavaAddonInterfaceV1.EventListener eventListener) {
            Pair<NativeEventListener, String[]> pair = this.mListenerToWrapperMap.remove(eventListener);
            if (pair == null) {
                Log.e((String)JavaAddonManagerV1.LOGTAG, (String)"Attempting to unregister listener which is not registered; ignoring.");
                return;
            }
            JavaAddonManagerV1.this.mDispatcher.unregisterGeckoThreadListener((NativeEventListener)pair.first, (String[])pair.second);
        }

        protected synchronized void unregisterAllEventListeners() {
            for (Pair<NativeEventListener, String[]> pair : this.mListenerToWrapperMap.values()) {
                JavaAddonManagerV1.this.mDispatcher.unregisterGeckoThreadListener((NativeEventListener)pair.first, (String[])pair.second);
            }
            this.mListenerToWrapperMap.clear();
        }

        public void sendRequestToGecko(final String string2, JSONObject jSONObject, final JavaAddonInterfaceV1.RequestCallback requestCallback) {
            String string3 = this.guid + ":" + string2;
            GeckoAppShell.sendRequestToGecko(new GeckoRequest(string3, jSONObject){

                public void onResponse(NativeJSObject nativeJSObject) {
                    if (requestCallback == null) {
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject(nativeJSObject.toString());
                        requestCallback.onResponse(GeckoAppShell.getContext(), jSONObject);
                    }
                    catch (JSONException jSONException) {
                        Log.e((String)JavaAddonManagerV1.LOGTAG, (String)("Exception handling response to request [" + string2 + "]:"), (Throwable)jSONException);
                    }
                }
            });
        }

        protected class ListenerWrapper
        implements NativeEventListener {
            private final JavaAddonInterfaceV1.EventListener listener;

            public ListenerWrapper(JavaAddonInterfaceV1.EventListener eventListener) {
                this.listener = eventListener;
            }

            public void handleMessage(String string2, NativeJSObject nativeJSObject, final EventCallback eventCallback) {
                block4: {
                    if (!string2.startsWith(EventDispatcherImpl.this.guid + ":")) {
                        return;
                    }
                    String string3 = string2.substring(EventDispatcherImpl.this.guid.length() + 1);
                    try {
                        JavaAddonInterfaceV1.EventCallback eventCallback2 = null;
                        if (eventCallback != null) {
                            eventCallback2 = new JavaAddonInterfaceV1.EventCallback(){

                                public void sendSuccess(Object object) {
                                    eventCallback.sendSuccess(object);
                                }

                                public void sendError(Object object) {
                                    eventCallback.sendError(object);
                                }
                            };
                        }
                        JSONObject jSONObject = new JSONObject(nativeJSObject.toString());
                        this.listener.handleMessage(JavaAddonManagerV1.this.mApplicationContext, string3, jSONObject, eventCallback2);
                    }
                    catch (Exception exception) {
                        Log.e((String)JavaAddonManagerV1.LOGTAG, (String)("Exception handling message [" + string2 + "]"), (Throwable)exception);
                        if (eventCallback == null) break block4;
                        eventCallback.sendError((Object)("Got exception handling message [" + string2 + "]: " + exception.toString()));
                    }
                }
            }
        }
    }
}

