/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.permissions.PermissionsHelper;
import org.mozilla.gecko.util.ThreadUtils;

public class PermissionBlock {
    private final PermissionsHelper helper;
    private Context context;
    private String[] permissions;
    private boolean onUIThread;
    private Runnable onPermissionsGranted;
    private Runnable onPermissionsDenied;
    private boolean doNotPrompt;

    PermissionBlock(Context context, PermissionsHelper permissionsHelper) {
        this.context = context;
        this.helper = permissionsHelper;
    }

    public PermissionBlock withPermissions(String ... stringArray) {
        this.permissions = stringArray;
        return this;
    }

    public PermissionBlock onUIThread() {
        this.onUIThread = true;
        return this;
    }

    public PermissionBlock doNotPrompt() {
        this.doNotPrompt = true;
        return this;
    }

    public PermissionBlock doNotPromptIf(boolean bl) {
        if (bl) {
            this.doNotPrompt();
        }
        return this;
    }

    public void run() {
        this.run(null);
    }

    public void run(Runnable runnable) {
        if (!this.doNotPrompt && !(this.context instanceof Activity)) {
            throw new IllegalStateException("You need to either specify doNotPrompt() or pass in an Activity context");
        }
        this.onPermissionsGranted = runnable;
        if (this.hasPermissions(this.context)) {
            this.onPermissionsGranted();
        } else if (this.doNotPrompt) {
            this.onPermissionsDenied();
        } else {
            Permissions.prompt((Activity)this.context, this);
        }
        this.context = null;
    }

    public PermissionBlock andFallback(@NonNull Runnable runnable) {
        this.onPermissionsDenied = runnable;
        return this;
    }

    void onPermissionsGranted() {
        this.executeRunnable(this.onPermissionsGranted);
    }

    void onPermissionsDenied() {
        this.executeRunnable(this.onPermissionsDenied);
    }

    private void executeRunnable(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.onUIThread) {
            ThreadUtils.postToUiThread((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    String[] getPermissions() {
        return this.permissions;
    }

    boolean hasPermissions(Context context) {
        return this.helper.hasPermissions(context, this.permissions);
    }
}

