/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.ProgressDialog;
import android.content.Context;
import android.preference.Preference;
import android.util.AttributeSet;
import android.util.Log;
import java.util.Set;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.preferences.AndroidImport;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.preferences.MultiPrefMultiChoicePreference;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.util.ThreadUtils;

class AndroidImportPreference
extends MultiPrefMultiChoicePreference {
    private static final String LOGTAG = "AndroidImport";
    public static final String PREF_KEY = "android.not_a_preference.import_android";
    private static final String PREF_KEY_PREFIX = "import_android.data.";
    private final Context mContext;

    public AndroidImportPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Set<String> set = this.getValues();
        for (String string2 : set) {
            String string3 = string2.substring(PREF_KEY_PREFIX.length());
            if ("bookmarks".equals(string3)) {
                bl2 = true;
                continue;
            }
            if (!"history".equals(string3)) continue;
            bl3 = true;
        }
        this.runImport(bl2, bl3);
    }

    protected void runImport(final boolean bl, final boolean bl2) {
        Log.i((String)LOGTAG, (String)"Importing Android history/bookmarks");
        if (!bl && !bl2) {
            return;
        }
        String string2 = bl && bl2 ? this.mContext.getString(R.string.bookmarkhistory_import_both) : (bl ? this.mContext.getString(R.string.bookmarkhistory_import_bookmarks) : this.mContext.getString(R.string.bookmarkhistory_import_history));
        final ProgressDialog progressDialog = ProgressDialog.show((Context)this.mContext, (CharSequence)string2, (CharSequence)this.mContext.getString(R.string.bookmarkhistory_import_wait), (boolean)true);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        progressDialog.dismiss();
                    }
                });
            }
        };
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                new AndroidImport(AndroidImportPreference.this.mContext, runnable, bl, bl2).run();
            }
        });
    }

    public static class Handler
    implements GeckoPreferences.PrefHandler {
        @Override
        public boolean setupPref(Context context, Preference preference) {
            return AppConstants.Versions.preMarshmallow && Restrictions.isAllowed(context, Restrictable.IMPORT_SETTINGS);
        }

        @Override
        public void onChange(Context context, Preference preference, Object object) {
        }
    }
}

