/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.distribution.Distribution;

public class DistroSharedPrefsImport {
    public static final String LOGTAG = DistroSharedPrefsImport.class.getSimpleName();

    public static void importPreferences(Context context, Distribution distribution) {
        if (distribution == null) {
            return;
        }
        JSONObject jSONObject = distribution.getAndroidPreferences();
        if (jSONObject.length() == 0) {
            return;
        }
        Iterator iterator = jSONObject.keys();
        SharedPreferences.Editor editor = GeckoSharedPrefs.forProfile(context).edit();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            try {
                object = jSONObject.get(string2);
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Unable to completely process Android Preferences JSON.", (Throwable)jSONException);
                continue;
            }
            if (object instanceof String) {
                editor.putString("android.not_a_preference." + string2, (String)object);
                continue;
            }
            if (object instanceof Boolean) {
                editor.putBoolean("android.not_a_preference." + string2, ((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Integer) {
                editor.putInt("android.not_a_preference." + string2, ((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                editor.putLong("android.not_a_preference." + string2, ((Long)object).longValue());
                continue;
            }
            Log.d((String)LOGTAG, (String)"Unknown preference value type whilst importing android preferences from distro file.");
        }
        editor.apply();
    }
}

