/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.util.Log;
import android.view.View;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SnackbarHelper;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.SearchPreferenceCategory;
import org.mozilla.gecko.widget.FaviconView;

public class SearchEnginePreference
extends CustomListPreference {
    protected String LOGTAG = "SearchEnginePreference";
    protected static final int INDEX_REMOVE_BUTTON = 1;
    private BitmapDrawable mPromptIcon;
    private Bitmap mIconBitmap;
    private final Object bitmapLock = new Object();
    private FaviconView mFaviconView;
    private String mIdentifier;

    public SearchEnginePreference(Context context, SearchPreferenceCategory searchPreferenceCategory) {
        super(context, searchPreferenceCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onBindView(View view) {
        super.onBindView(view);
        Object object = this.bitmapLock;
        synchronized (object) {
            this.mFaviconView = (FaviconView)view.findViewById(R.id.search_engine_icon);
            if (this.mIconBitmap != null) {
                this.mFaviconView.updateAndScaleImage(this.mIconBitmap, this.getTitle().toString());
            }
        }
    }

    @Override
    protected int getPreferenceLayoutResource() {
        return R.layout.preference_search_engine;
    }

    @Override
    protected String[] createDialogItems() {
        return new String[]{this.LABEL_SET_AS_DEFAULT, this.LABEL_REMOVE};
    }

    @Override
    public void showDialog() {
        if (this.mParentCategory.getPreferenceCount() == 1) {
            Activity activity = (Activity)this.getContext();
            SnackbarHelper.showSnackbar(activity, activity.getString(R.string.pref_search_last_toast), 0);
            return;
        }
        super.showDialog();
    }

    @Override
    protected void configureDialogBuilder(AlertDialog.Builder builder) {
        if (this.mPromptIcon == null && this.mIconBitmap != null) {
            this.mPromptIcon = new BitmapDrawable(this.getContext().getResources(), this.mFaviconView.getBitmap());
        }
        builder.setIcon((Drawable)this.mPromptIcon);
    }

    @Override
    protected void onDialogIndexClicked(int n) {
        switch (n) {
            case 0: {
                this.mParentCategory.setDefault(this);
                break;
            }
            case 1: {
                this.mParentCategory.uninstall(this);
                break;
            }
            default: {
                Log.w((String)this.LOGTAG, (String)"Selected index out of range.");
            }
        }
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void setSearchEngineFromJSON(JSONObject jSONObject) throws JSONException {
        this.mIdentifier = jSONObject.getString("identifier");
        if (this.mIdentifier.equals("null")) {
            this.mIdentifier = "other";
        }
        String string2 = jSONObject.getString("name");
        SpannableString spannableString = new SpannableString((CharSequence)string2);
        this.setTitle((CharSequence)spannableString);
        String string3 = jSONObject.getString("iconURI");
        try {
            int n = this.mFaviconView != null ? this.mFaviconView.getWidth() : (Favicons.largestFaviconSize == 0 ? 128 : Favicons.largestFaviconSize);
            Favicons.getSizedFavicon(this.getContext(), this.mIdentifier, string3, n, 0, new OnFaviconLoadedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
                    Object object = SearchEnginePreference.this.bitmapLock;
                    synchronized (object) {
                        SearchEnginePreference.this.mIconBitmap = bitmap;
                        if (SearchEnginePreference.this.mFaviconView != null) {
                            SearchEnginePreference.this.mFaviconView.updateAndScaleImage(SearchEnginePreference.this.mIconBitmap, SearchEnginePreference.this.getTitle().toString());
                        }
                    }
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)this.LOGTAG, (String)"IllegalArgumentException creating Bitmap. Most likely a zero-length bitmap.", (Throwable)illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)this.LOGTAG, (String)"NullPointerException creating Bitmap. Most likely a zero-length bitmap.", (Throwable)nullPointerException);
        }
    }
}

