/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.prompts.PromptListAdapter;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.util.ThreadUtils;

public class Prompt
implements DialogInterface.OnClickListener,
DialogInterface.OnCancelListener,
AdapterView.OnItemClickListener,
PromptInput.OnChangeListener,
Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoPromptService";
    private String[] mButtons;
    private PromptInput[] mInputs;
    private AlertDialog mDialog;
    private final LayoutInflater mInflater;
    private final Context mContext;
    private PromptCallback mCallback;
    private String mGuid;
    private PromptListAdapter mAdapter;
    private static boolean mInitialized;
    private static int mInputPaddingSize;
    private int mTabId = -1;

    public Prompt(Context context, PromptCallback promptCallback) {
        this(context);
        this.mCallback = promptCallback;
    }

    private Prompt(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        if (!mInitialized) {
            Resources resources = this.mContext.getResources();
            mInputPaddingSize = (int)resources.getDimension(R.dimen.prompt_service_inputs_padding);
            mInitialized = true;
        }
    }

    private View applyInputStyle(View view, PromptInput promptInput) {
        if (promptInput.canApplyInputStyle()) {
            view.setPadding(mInputPaddingSize, 0, mInputPaddingSize, 0);
        }
        return view;
    }

    public void show(JSONObject jSONObject) {
        String string2 = jSONObject.optString("title");
        String string3 = jSONObject.optString("text");
        this.mGuid = jSONObject.optString("guid");
        this.mButtons = Prompt.getStringArray(jSONObject, "buttons");
        JSONArray jSONArray = Prompt.getSafeArray(jSONObject, "inputs");
        this.mInputs = new PromptInput[jSONArray.length()];
        for (int i = 0; i < this.mInputs.length; ++i) {
            try {
                this.mInputs[i] = PromptInput.getInput(jSONArray.getJSONObject(i));
                this.mInputs[i].setListener(this);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PromptListItem[] promptListItemArray = PromptListItem.getArray(jSONObject.optJSONArray("listitems"));
        String string4 = jSONObject.optString("choiceMode");
        int n = 0;
        if ("single".equals(string4)) {
            n = 1;
        } else if ("multiple".equals(string4)) {
            n = 2;
        }
        if (jSONObject.has("tabId")) {
            this.mTabId = jSONObject.optInt("tabId", -1);
        }
        this.show(string2, string3, promptListItemArray, n);
    }

    public void show(String string2, String string3, PromptListItem[] promptListItemArray, int n) {
        ThreadUtils.assertOnUiThread();
        try {
            this.create(string2, string3, promptListItemArray, n);
        }
        catch (IllegalStateException illegalStateException) {
            Log.i((String)LOGTAG, (String)"Error building dialog", (Throwable)illegalStateException);
            return;
        }
        if (this.mTabId != -1) {
            Tabs.registerOnTabsChangedListener(this);
            Tab tab = Tabs.getInstance().getTab(this.mTabId);
            if (Tabs.getInstance().getSelectedTab() == tab) {
                this.mDialog.show();
            }
        } else {
            this.mDialog.show();
        }
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tab != Tabs.getInstance().getTab(this.mTabId)) {
            return;
        }
        switch (tabEvents) {
            case SELECTED: {
                Log.i((String)LOGTAG, (String)"Selected");
                this.mDialog.show();
                break;
            }
            case UNSELECTED: {
                Log.i((String)LOGTAG, (String)"Unselected");
                this.mDialog.hide();
                break;
            }
            case LOCATION_CHANGE: {
                Log.i((String)LOGTAG, (String)"Location change");
                this.mDialog.cancel();
            }
        }
    }

    private void create(String string2, String string3, PromptListItem[] promptListItemArray, int n) throws IllegalStateException {
        int n2;
        LayerView layerView = GeckoAppShell.getLayerView();
        if (layerView != null) {
            layerView.abortPanning();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setTitle((CharSequence)string2.substring(0, Math.min(string2.length(), 256)));
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            builder.setMessage((CharSequence)string3);
        }
        if (promptListItemArray != null && promptListItemArray.length > 0) {
            this.addListItems(builder, promptListItemArray, n);
        } else if (!this.addInputs(builder)) {
            throw new IllegalStateException("Could not add inputs to dialog");
        }
        int n3 = n2 = this.mButtons == null ? 0 : this.mButtons.length;
        if (n2 > 0) {
            builder.setPositiveButton((CharSequence)this.mButtons[0], (DialogInterface.OnClickListener)this);
            if (n2 > 1) {
                builder.setNeutralButton((CharSequence)this.mButtons[1], (DialogInterface.OnClickListener)this);
                if (n2 > 2) {
                    builder.setNegativeButton((CharSequence)this.mButtons[2], (DialogInterface.OnClickListener)this);
                }
            }
        }
        this.mDialog = builder.create();
        this.mDialog.setOnCancelListener((DialogInterface.OnCancelListener)this);
    }

    public void setButtons(String[] stringArray) {
        this.mButtons = stringArray;
    }

    public void setInputs(PromptInput[] promptInputArray) {
        this.mInputs = promptInputArray;
    }

    private void addListResult(JSONObject jSONObject, int n) {
        if (this.mAdapter == null) {
            return;
        }
        try {
            JSONArray jSONArray = new JSONArray();
            ArrayList<Integer> arrayList = this.mAdapter.getSelected();
            for (Integer n2 : arrayList) {
                jSONArray.put((Object)n2);
            }
            if (!jSONObject.has("button") || jSONObject.optInt("button") == -1) {
                if (!arrayList.contains(n)) {
                    jSONArray.put(n);
                }
                jSONObject.put("button", n);
            }
            jSONObject.put("list", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void addInputValues(JSONObject jSONObject) {
        try {
            if (this.mInputs != null) {
                for (int i = 0; i < this.mInputs.length; ++i) {
                    if (this.mInputs[i] == null) continue;
                    jSONObject.put(this.mInputs[i].getId(), this.mInputs[i].getValue());
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void addButtonResult(JSONObject jSONObject, int n) {
        int n2 = -1;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case -3: {
                n2 = 1;
                break;
            }
            case -2: {
                n2 = 2;
            }
        }
        try {
            jSONObject.put("button", n2);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void onClick(DialogInterface dialogInterface, int n) {
        ThreadUtils.assertOnUiThread();
        this.closeDialog(n);
    }

    private void addListItems(AlertDialog.Builder builder, PromptListItem[] promptListItemArray, int n) {
        switch (n) {
            case 2: 
            case 3: {
                this.addMultiSelectList(builder, promptListItemArray);
                break;
            }
            case 1: {
                this.addSingleSelectList(builder, promptListItemArray);
                break;
            }
            default: {
                this.addMenuList(builder, promptListItemArray);
            }
        }
    }

    private void addMultiSelectList(AlertDialog.Builder builder, PromptListItem[] promptListItemArray) {
        ListView listView = (ListView)this.mInflater.inflate(R.layout.select_dialog_list, null);
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        listView.setChoiceMode(2);
        this.mAdapter = new PromptListAdapter(this.mContext, R.layout.select_dialog_multichoice, promptListItemArray);
        listView.setAdapter((ListAdapter)this.mAdapter);
        builder.setView((View)listView);
    }

    private void addSingleSelectList(AlertDialog.Builder builder, PromptListItem[] promptListItemArray) {
        this.mAdapter = new PromptListAdapter(this.mContext, R.layout.select_dialog_singlechoice, promptListItemArray);
        builder.setSingleChoiceItems((ListAdapter)this.mAdapter, this.mAdapter.getSelectedIndex(), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                ArrayList<Integer> arrayList = Prompt.this.mAdapter.getSelected();
                for (Integer n2 : arrayList) {
                    Prompt.this.mAdapter.toggleSelected(n2);
                }
                Prompt.this.mAdapter.toggleSelected(n);
                Prompt.this.closeIfNoButtons(n);
            }
        });
    }

    private void addMenuList(AlertDialog.Builder builder, PromptListItem[] promptListItemArray) {
        this.mAdapter = new PromptListAdapter(this.mContext, 17367043, promptListItemArray);
        builder.setAdapter((ListAdapter)this.mAdapter, (DialogInterface.OnClickListener)this);
    }

    private View wrapInput(PromptInput promptInput) {
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setOrientation(1);
        this.applyInputStyle((View)linearLayout, promptInput);
        linearLayout.addView(promptInput.getView(this.mContext));
        return linearLayout;
    }

    private boolean addInputs(AlertDialog.Builder builder) {
        int n;
        int n2 = n = this.mInputs == null ? 0 : this.mInputs.length;
        if (n == 0) {
            return true;
        }
        try {
            LinearLayout linearLayout;
            View view = null;
            boolean bl = false;
            if (n == 1) {
                view = this.wrapInput(this.mInputs[0]);
                bl |= this.mInputs[0].getScrollable();
            } else if (n > 1) {
                linearLayout = new LinearLayout(this.mContext);
                linearLayout.setOrientation(1);
                for (int i = 0; i < n; ++i) {
                    View view2 = this.wrapInput(this.mInputs[i]);
                    linearLayout.addView(view2);
                    bl |= this.mInputs[i].getScrollable();
                }
                view = linearLayout;
            }
            if (bl) {
                builder.setInverseBackgroundForced(true);
                builder.setView(view);
            } else {
                linearLayout = new ScrollView(this.mContext);
                linearLayout.addView(view);
                builder.setView((View)linearLayout);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error showing prompt inputs", (Throwable)exception);
            this.cancelDialog();
            return false;
        }
        return true;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        ThreadUtils.assertOnUiThread();
        this.mAdapter.toggleSelected(n);
        this.closeIfNoButtons(n);
    }

    private boolean closeIfNoButtons(int n) {
        ThreadUtils.assertOnUiThread();
        if (this.mButtons == null || this.mButtons.length == 0) {
            this.closeDialog(n);
            return true;
        }
        return false;
    }

    public void onCancel(DialogInterface dialogInterface) {
        ThreadUtils.assertOnUiThread();
        this.cancelDialog();
    }

    private void cancelDialog() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("button", -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addInputValues(jSONObject);
        this.notifyClosing(jSONObject);
    }

    private void closeDialog(int n) {
        JSONObject jSONObject = new JSONObject();
        this.mDialog.dismiss();
        this.addButtonResult(jSONObject, n);
        this.addListResult(jSONObject, n);
        this.addInputValues(jSONObject);
        this.notifyClosing(jSONObject);
    }

    private void notifyClosing(JSONObject jSONObject) {
        try {
            jSONObject.put("guid", (Object)this.mGuid);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (this.mTabId != -1) {
            Tabs.unregisterOnTabsChangedListener(this);
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createNoOpEvent());
        if (this.mCallback != null) {
            this.mCallback.onPromptFinished(jSONObject.toString());
        }
    }

    @Override
    public void onChange(PromptInput promptInput) {
        this.closeIfNoButtons(-1);
    }

    private static JSONArray getSafeArray(JSONObject jSONObject, String string2) {
        try {
            return jSONObject.getJSONArray(string2);
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public static String[] getStringArray(JSONObject jSONObject, String string2) {
        JSONArray jSONArray = Prompt.getSafeArray(jSONObject, string2);
        int n = jSONArray.length();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            try {
                stringArray[i] = jSONArray.getString(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    private static boolean[] getBooleanArray(JSONObject jSONObject, String string2) {
        JSONArray jSONArray = new JSONArray();
        try {
            jSONArray = jSONObject.getJSONArray(string2);
        }
        catch (Exception exception) {
            return null;
        }
        int n = jSONArray.length();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            try {
                blArray[i] = jSONArray.getBoolean(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return blArray;
    }

    public static interface PromptCallback {
        public void onPromptFinished(String var1);
    }
}

