/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.restrictions;

import android.annotation.TargetApi;
import android.content.Context;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.RestrictionCache;
import org.mozilla.gecko.restrictions.RestrictionConfiguration;

@TargetApi(value=18)
public class RestrictedProfileConfiguration
implements RestrictionConfiguration {
    private static Map<Restrictable, Boolean> configuration = new LinkedHashMap<Restrictable, Boolean>();
    private static List<Restrictable> hiddenRestrictions;
    private Context context;

    static boolean shouldHide(Restrictable restrictable) {
        return hiddenRestrictions.contains((Object)restrictable);
    }

    static Map<Restrictable, Boolean> getConfiguration() {
        return configuration;
    }

    public RestrictedProfileConfiguration(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public synchronized boolean isAllowed(Restrictable restrictable) {
        if (restrictable == Restrictable.INSTALL_APPS || restrictable == Restrictable.MODIFY_ACCOUNTS) {
            return RestrictionCache.getUserRestriction(this.context, restrictable.name);
        }
        if (!RestrictionCache.hasApplicationRestriction(this.context, restrictable.name) && !configuration.containsKey((Object)restrictable)) {
            return true;
        }
        return RestrictionCache.getApplicationRestriction(this.context, restrictable.name, configuration.get((Object)restrictable));
    }

    @Override
    public boolean canLoadUrl(String string2) {
        if (!this.isAllowed(Restrictable.INSTALL_EXTENSION) && AboutPages.isAboutAddons(string2)) {
            return false;
        }
        if (!this.isAllowed(Restrictable.PRIVATE_BROWSING) && AboutPages.isAboutPrivateBrowsing(string2)) {
            return false;
        }
        return !AboutPages.isAboutConfig(string2);
    }

    @Override
    public boolean isRestricted() {
        return true;
    }

    @Override
    public synchronized void update() {
        RestrictionCache.invalidate();
    }

    public static List<Restrictable> getVisibleRestrictions() {
        ArrayList<Restrictable> arrayList = new ArrayList<Restrictable>();
        for (Restrictable restrictable : configuration.keySet()) {
            if (hiddenRestrictions.contains((Object)restrictable)) continue;
            arrayList.add(restrictable);
        }
        return arrayList;
    }

    static {
        configuration.put(Restrictable.INSTALL_EXTENSION, false);
        configuration.put(Restrictable.PRIVATE_BROWSING, false);
        configuration.put(Restrictable.CLEAR_HISTORY, false);
        configuration.put(Restrictable.MASTER_PASSWORD, false);
        configuration.put(Restrictable.GUEST_BROWSING, false);
        configuration.put(Restrictable.ADVANCED_SETTINGS, false);
        configuration.put(Restrictable.CAMERA_MICROPHONE, false);
        configuration.put(Restrictable.DATA_CHOICES, false);
        configuration.put(Restrictable.BLOCK_LIST, false);
        configuration.put(Restrictable.TELEMETRY, false);
        configuration.put(Restrictable.HEALTH_REPORT, true);
        configuration.put(Restrictable.DEFAULT_THEME, true);
        hiddenRestrictions = new ArrayList<Restrictable>();
        hiddenRestrictions.add(Restrictable.MASTER_PASSWORD);
        hiddenRestrictions.add(Restrictable.GUEST_BROWSING);
        hiddenRestrictions.add(Restrictable.DATA_CHOICES);
        hiddenRestrictions.add(Restrictable.DEFAULT_THEME);
    }
}

