/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.sqlite.MatrixBlobCursor;
import org.mozilla.gecko.sqlite.SQLiteBridgeException;

public class SQLiteBridge {
    private static final String LOGTAG = "SQLiteBridge";
    private final String mDb;
    protected volatile long mDbPointer;
    private long[] mQueryResults;
    private boolean mTransactionSuccess;
    private boolean mInTransaction;
    private static final int RESULT_INSERT_ROW_ID = 0;
    private static final int RESULT_ROWS_CHANGED = 1;
    private static final int DEFAULT_PAGE_SIZE_BYTES = 32768;
    private static final int MAX_WAL_SIZE_BYTES = 524288;

    private static native MatrixBlobCursor sqliteCall(String var0, String var1, String[] var2, long[] var3) throws SQLiteBridgeException;

    private static native MatrixBlobCursor sqliteCallWithDb(long var0, String var2, String[] var3, long[] var4) throws SQLiteBridgeException;

    private static native long openDatabase(String var0) throws SQLiteBridgeException;

    private static native void closeDatabase(long var0);

    @RobocopTarget
    public SQLiteBridge(String string2) throws SQLiteBridgeException {
        this.mDb = string2;
    }

    public void execSQL(String string2) throws SQLiteBridgeException {
        Cursor cursor = this.internalQuery(string2, null);
        cursor.close();
    }

    public void execSQL(String string2, String[] stringArray) throws SQLiteBridgeException {
        Cursor cursor = this.internalQuery(string2, stringArray);
        cursor.close();
    }

    public int delete(String string2, String string3, String[] stringArray) throws SQLiteBridgeException {
        StringBuilder stringBuilder = new StringBuilder("DELETE from ");
        stringBuilder.append(string2);
        if (string3 != null) {
            stringBuilder.append(" WHERE " + string3);
        }
        this.execSQL(stringBuilder.toString(), stringArray);
        return (int)this.mQueryResults[1];
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) throws SQLiteBridgeException {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (stringArray != null) {
            stringBuilder.append(TextUtils.join((CharSequence)", ", (Object[])stringArray));
        } else {
            stringBuilder.append(" * ");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(string2);
        if (string3 != null) {
            stringBuilder.append(" WHERE " + string3);
        }
        if (string4 != null) {
            stringBuilder.append(" GROUP BY " + string4);
        }
        if (string5 != null) {
            stringBuilder.append(" HAVING " + string5);
        }
        if (string6 != null) {
            stringBuilder.append(" ORDER BY " + string6);
        }
        if (string7 != null) {
            stringBuilder.append(" " + string7);
        }
        return this.rawQuery(stringBuilder.toString(), stringArray2);
    }

    @RobocopTarget
    public Cursor rawQuery(String string2, String[] stringArray) throws SQLiteBridgeException {
        return this.internalQuery(string2, stringArray);
    }

    public long insert(String string2, String string3, ContentValues contentValues) throws SQLiteBridgeException {
        String[] stringArray2;
        if (contentValues == null) {
            return 0L;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList();
        for (String[] stringArray2 : contentValues.valueSet()) {
            arrayList3.add(stringArray2.getKey());
            Object v = stringArray2.getValue();
            if (v == null) {
                arrayList.add("NULL");
                continue;
            }
            arrayList.add("?");
            arrayList2.add(v.toString());
        }
        StringBuilder stringBuilder = new StringBuilder("INSERT into ");
        stringBuilder.append(string2);
        stringBuilder.append(" (");
        stringBuilder.append(TextUtils.join((CharSequence)", ", arrayList3));
        stringBuilder.append(")");
        stringBuilder.append(" VALUES (");
        stringBuilder.append(TextUtils.join((CharSequence)", ", arrayList));
        stringBuilder.append(") ");
        stringArray2 = new String[arrayList2.size()];
        arrayList2.toArray(stringArray2);
        this.execSQL(stringBuilder.toString(), stringArray2);
        return this.mQueryResults[0];
    }

    public int update(String string2, ContentValues contentValues, String string3, String[] stringArray) throws SQLiteBridgeException {
        if (contentValues == null) {
            return 0;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        stringBuilder.append(string2);
        stringBuilder.append(" SET ");
        boolean bl = true;
        for (Map.Entry entry : contentValues.valueSet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)entry.getKey());
            Object v = entry.getValue();
            if (v == null) {
                stringBuilder.append(" = NULL");
                continue;
            }
            stringBuilder.append(" = ?");
            arrayList.add(v.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(string3);
            arrayList.addAll(Arrays.asList(stringArray));
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        this.execSQL(stringBuilder.toString(), stringArray2);
        return (int)this.mQueryResults[1];
    }

    public int getVersion() throws SQLiteBridgeException {
        Cursor cursor = this.internalQuery("PRAGMA user_version", null);
        int n = -1;
        if (cursor != null) {
            cursor.moveToFirst();
            String string2 = cursor.getString(0);
            n = Integer.parseInt(string2);
            cursor.close();
        }
        return n;
    }

    private Cursor internalQuery(String string2, String[] stringArray) throws SQLiteBridgeException {
        this.mQueryResults = new long[2];
        if (this.isOpen()) {
            return SQLiteBridge.sqliteCallWithDb(this.mDbPointer, string2, stringArray, this.mQueryResults);
        }
        return SQLiteBridge.sqliteCall(this.mDb, string2, stringArray, this.mQueryResults);
    }

    public static SQLiteBridge openDatabase(String string2, SQLiteDatabase.CursorFactory cursorFactory, int n) throws SQLiteException {
        if (cursorFactory != null) {
            throw new RuntimeException("factory not supported.");
        }
        if (n != 0) {
            throw new RuntimeException("flags not supported.");
        }
        SQLiteBridge sQLiteBridge = null;
        try {
            sQLiteBridge = new SQLiteBridge(string2);
            sQLiteBridge.mDbPointer = SQLiteBridge.openDatabase(string2);
        }
        catch (SQLiteBridgeException sQLiteBridgeException) {
            throw new SQLiteException(sQLiteBridgeException.getMessage());
        }
        SQLiteBridge.prepareWAL(sQLiteBridge);
        return sQLiteBridge;
    }

    public void close() {
        if (this.isOpen()) {
            SQLiteBridge.closeDatabase(this.mDbPointer);
        }
        this.mDbPointer = 0L;
    }

    public boolean isOpen() {
        return this.mDbPointer != 0L;
    }

    public void beginTransaction() throws SQLiteBridgeException {
        if (this.inTransaction()) {
            throw new SQLiteBridgeException("Nested transactions are not supported");
        }
        this.execSQL("BEGIN EXCLUSIVE");
        this.mTransactionSuccess = false;
        this.mInTransaction = true;
    }

    public void beginTransactionNonExclusive() throws SQLiteBridgeException {
        if (this.inTransaction()) {
            throw new SQLiteBridgeException("Nested transactions are not supported");
        }
        this.execSQL("BEGIN IMMEDIATE");
        this.mTransactionSuccess = false;
        this.mInTransaction = true;
    }

    public void endTransaction() {
        if (!this.inTransaction()) {
            return;
        }
        try {
            if (this.mTransactionSuccess) {
                this.execSQL("COMMIT TRANSACTION");
            } else {
                this.execSQL("ROLLBACK TRANSACTION");
            }
        }
        catch (SQLiteBridgeException sQLiteBridgeException) {
            Log.e((String)LOGTAG, (String)"Error ending transaction", (Throwable)sQLiteBridgeException);
        }
        this.mInTransaction = false;
        this.mTransactionSuccess = false;
    }

    public void setTransactionSuccessful() throws SQLiteBridgeException {
        if (!this.inTransaction()) {
            throw new SQLiteBridgeException("setTransactionSuccessful called outside a transaction");
        }
        this.mTransactionSuccess = true;
    }

    public boolean inTransaction() {
        return this.mInTransaction;
    }

    public void finalize() {
        if (this.isOpen()) {
            Log.e((String)LOGTAG, (String)"Bridge finalized without closing the database");
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareWAL(SQLiteBridge sQLiteBridge) {
        try (Cursor cursor = sQLiteBridge.internalQuery("PRAGMA journal_mode=WAL", null);){
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                Log.d((String)LOGTAG, (String)("Journal mode: " + string2));
                if ("wal".equals(string2)) {
                    int n = sQLiteBridge.getPageSizeBytes();
                    int n2 = 524288 / n;
                    sQLiteBridge.execSQL("PRAGMA wal_autocheckpoint=" + n2);
                } else {
                    if (!"truncate".equals(string2)) {
                        Log.w((String)LOGTAG, (String)"Unable to activate WAL journal mode. Using truncate instead.");
                        sQLiteBridge.execSQL("PRAGMA journal_mode=TRUNCATE");
                    }
                    Log.w((String)LOGTAG, (String)"Not using WAL mode: using synchronous=FULL instead.");
                    sQLiteBridge.execSQL("PRAGMA synchronous=FULL");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPageSizeBytes() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Database not open.");
        }
        try (Cursor cursor = this.internalQuery("PRAGMA page_size", null);){
            if (!cursor.moveToFirst()) {
                Log.w((String)LOGTAG, (String)"Unable to retrieve page size.");
                int n = 32768;
                return n;
            }
            int n = cursor.getInt(0);
            return n;
        }
    }
}

