/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import java.util.Arrays;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.tabs.TabHistoryController;
import org.mozilla.gecko.toolbar.BackButton;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ForwardButton;
import org.mozilla.gecko.widget.themed.ThemedTextView;

abstract class BrowserToolbarTabletBase
extends BrowserToolbar {
    protected final LinearLayout actionItemBar = (LinearLayout)this.findViewById(R.id.menu_items);
    protected final BackButton backButton = (BackButton)this.findViewById(R.id.back);
    protected final ForwardButton forwardButton;
    protected final View menuButtonMarginView;
    private final PorterDuffColorFilter privateBrowsingTabletMenuItemColorFilter;

    protected abstract void animateForwardButton(ForwardButtonAnimation var1);

    public BrowserToolbarTabletBase(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.backButton.setEnabled(false);
        this.forwardButton = (ForwardButton)this.findViewById(R.id.forward);
        this.forwardButton.setEnabled(false);
        this.initButtonListeners();
        this.focusOrder.addAll(Arrays.asList(this.tabsButton, this.backButton, this.forwardButton, this));
        this.focusOrder.addAll(this.urlDisplayLayout.getFocusOrder());
        this.focusOrder.addAll(Arrays.asList(this.actionItemBar, this.menuButton));
        this.urlDisplayLayout.updateSiteIdentityAnchor((View)this.backButton);
        this.privateBrowsingTabletMenuItemColorFilter = new PorterDuffColorFilter(ContextCompat.getColor((Context)context, (int)R.color.tabs_tray_icon_grey), PorterDuff.Mode.SRC_IN);
        this.menuButtonMarginView = this.findViewById(R.id.menu_margin);
        if (this.menuButtonMarginView != null) {
            this.menuButtonMarginView.setVisibility(0);
        }
    }

    private void initButtonListeners() {
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doBack();
            }
        });
        this.backButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return BrowserToolbarTabletBase.this.tabHistoryController.showTabHistory(Tabs.getInstance().getSelectedTab(), TabHistoryController.HistoryAction.BACK);
            }
        });
        this.forwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doForward();
            }
        });
        this.forwardButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return BrowserToolbarTabletBase.this.tabHistoryController.showTabHistory(Tabs.getInstance().getSelectedTab(), TabHistoryController.HistoryAction.FORWARD);
            }
        });
    }

    @Override
    protected boolean isTabsButtonOffscreen() {
        return false;
    }

    @Override
    public boolean addActionItem(View view) {
        this.actionItemBar.addView(view, -2, -1);
        return true;
    }

    @Override
    public void removeActionItem(View view) {
        this.actionItemBar.removeView(view);
    }

    @Override
    protected void updateNavigationButtons(Tab tab) {
        this.backButton.setEnabled(this.canDoBack(tab));
        this.animateForwardButton(this.canDoForward(tab) ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
    }

    @Override
    public void setNextFocusDownId(int n) {
        super.setNextFocusDownId(n);
        this.backButton.setNextFocusDownId(n);
        this.forwardButton.setNextFocusDownId(n);
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        PorterDuffColorFilter porterDuffColorFilter = bl ? this.privateBrowsingTabletMenuItemColorFilter : null;
        this.setTabsCounterPrivateMode(bl, porterDuffColorFilter);
        this.backButton.setPrivateMode(bl);
        this.forwardButton.setPrivateMode(bl);
        this.menuIcon.setPrivateMode(bl);
        for (int i = 0; i < this.actionItemBar.getChildCount(); ++i) {
            MenuItemActionBar menuItemActionBar = (MenuItemActionBar)this.actionItemBar.getChildAt(i);
            menuItemActionBar.setPrivateMode(bl);
        }
    }

    private void setTabsCounterPrivateMode(boolean bl, PorterDuffColorFilter porterDuffColorFilter) {
        for (int i = 0; i < 2; ++i) {
            ThemedTextView themedTextView = (ThemedTextView)this.tabsCounter.getChildAt(i);
            themedTextView.setPrivateMode(bl);
            themedTextView.getBackground().mutate().setColorFilter((ColorFilter)porterDuffColorFilter);
        }
        this.tabsCounter.getBackground().mutate().setColorFilter((ColorFilter)porterDuffColorFilter);
    }

    @Override
    public View getDoorHangerAnchor() {
        return this.backButton;
    }

    protected boolean canDoBack(Tab tab) {
        return tab.canDoBack() && !this.isEditing();
    }

    protected boolean canDoForward(Tab tab) {
        return tab.canDoForward() && !this.isEditing();
    }

    protected static enum ForwardButtonAnimation {
        SHOW,
        HIDE;

    }
}

