/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.keepsafe.switchboard.SwitchBoard;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.mozglue.ContextUtils;

public class Experiments {
    private static final String LOGTAG = "GeckoExperiments";
    public static final String BOOKMARKS_HISTORY_MENU = "bookmark-history-menu";
    public static final String SEARCH_TERM = "search-term";
    public static final String WHATSNEW_NOTIFICATION = "whatsnew-notification";
    public static final String CONTENT_NOTIFICATIONS_12HRS = "content-notifications-12hrs";
    public static final String CONTENT_NOTIFICATIONS_8AM = "content-notifications-8am";
    public static final String CONTENT_NOTIFICATIONS_5PM = "content-notifications-5pm";
    public static final String ONBOARDING2_A = "onboarding2-a";
    public static final String ONBOARDING2_B = "onboarding2-b";
    public static final String ONBOARDING2_C = "onboarding2-c";
    public static final String DOWNLOAD_CONTENT_CATALOG_SYNC = "download-content-catalog-sync";
    public static final String PREF_ONBOARDING_VERSION = "onboarding_version";
    private static volatile Boolean disabled = null;

    public static boolean isDisabled(ContextUtils.SafeIntent safeIntent) {
        if (disabled != null) {
            return disabled;
        }
        String string2 = safeIntent.getStringExtra("env0");
        int n = 1;
        while (string2 != null) {
            if (string2.startsWith("MOZ_DISABLE_SWITCHBOARD=") && !string2.endsWith("=")) {
                Log.d((String)LOGTAG, (String)"Switchboard disabled by MOZ_DISABLE_SWITCHBOARD environment variable");
                disabled = true;
                return disabled;
            }
            string2 = safeIntent.getStringExtra("env" + n);
            ++n;
        }
        disabled = false;
        return disabled;
    }

    public static boolean isInExperimentLocal(Context context, String string2) {
        if (SwitchBoard.isInBucket((Context)context, (int)0, (int)33)) {
            return ONBOARDING2_A.equals(string2);
        }
        if (SwitchBoard.isInBucket((Context)context, (int)33, (int)66)) {
            return ONBOARDING2_B.equals(string2);
        }
        if (SwitchBoard.isInBucket((Context)context, (int)66, (int)100)) {
            return ONBOARDING2_C.equals(string2);
        }
        return false;
    }

    public static List<String> getActiveExperiments(Context context) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(SwitchBoard.getActiveExperiments((Context)context));
        String string2 = GeckoSharedPrefs.forProfile(context).getString(PREF_ONBOARDING_VERSION, null);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            linkedList.add(string2);
        }
        return linkedList;
    }
}

