/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.util.AttributeSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.FadedTextView;

public class FadedMultiColorTextView
extends FadedTextView {
    private final ColorStateList fadeBackgroundColorList;
    private final Paint fadePaint = new Paint();
    private FadedTextGradient backgroundGradient;

    public FadedMultiColorTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FadedMultiColorTextView);
        this.fadeBackgroundColorList = typedArray.getColorStateList(R.styleable.FadedMultiColorTextView_fadeBackgroundColor);
        typedArray.recycle();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean bl = this.needsEllipsis();
        if (bl) {
            int n = this.getWidth() - this.getCompoundPaddingRight();
            float f = n - this.fadeWidth;
            this.updateGradientShader(bl, n);
            float f2 = this.getHeight() / 2;
            float f3 = f2 - this.getTextSize() + 2.0f;
            float f4 = f2 + this.getTextSize() - 2.0f;
            canvas.drawRect(f, f3, (float)n, f4, this.fadePaint);
        }
    }

    private void updateGradientShader(boolean bl, int n) {
        boolean bl2;
        int n2 = this.fadeBackgroundColorList.getColorForState(this.getDrawableState(), -65536);
        boolean bl3 = bl2 = this.backgroundGradient == null || this.backgroundGradient.getBackgroundColor() != n2 || this.backgroundGradient.getEndRight() != n;
        if (bl && bl2) {
            this.backgroundGradient = new FadedTextGradient(n, this.fadeWidth, n2);
            this.fadePaint.setShader((Shader)this.backgroundGradient);
        }
    }

    private static class FadedTextGradient
    extends LinearGradient {
        private final int endRight;
        private final int backgroundColor;

        public FadedTextGradient(int n, int n2, int n3) {
            super((float)(n - n2), 0.0f, (float)n, 0.0f, FadedTextGradient.getColorWithZeroedAlpha(n3), n3, Shader.TileMode.CLAMP);
            this.endRight = n;
            this.backgroundColor = n3;
        }

        private static int getColorWithZeroedAlpha(int n) {
            return Color.argb((int)0, (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
        }

        public int getEndRight() {
            return this.endRight;
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }
    }
}

