/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.content.SyncResult;
import java.util.concurrent.BlockingQueue;
import org.mozilla.gecko.fxa.login.State;

public class FxAccountSyncDelegate {
    protected final BlockingQueue<Result> latch;
    protected final SyncResult syncResult;

    public FxAccountSyncDelegate(BlockingQueue<Result> blockingQueue, SyncResult syncResult) {
        if (blockingQueue == null) {
            throw new IllegalArgumentException("latch must not be null");
        }
        if (syncResult == null) {
            throw new IllegalArgumentException("syncResult must not be null");
        }
        this.latch = blockingQueue;
        this.syncResult = syncResult;
    }

    protected void setSyncResultSuccess() {
        ++this.syncResult.stats.numUpdates;
    }

    protected void setSyncResultSoftError() {
        ++this.syncResult.stats.numUpdates;
        ++this.syncResult.stats.numIoExceptions;
    }

    protected void setSyncResultHardError() {
        ++this.syncResult.stats.numAuthExceptions;
    }

    public void handleSuccess() {
        this.setSyncResultSuccess();
        this.latch.offer(Result.Success);
    }

    public void handleError(Exception exception) {
        this.setSyncResultSoftError();
        this.latch.offer(Result.Error);
    }

    public void handleCannotSync(State state) {
        this.setSyncResultSoftError();
        this.latch.offer(Result.Error);
    }

    public void postponeSync(long l) {
        if (l > 0L) {
            // empty if block
        }
        this.setSyncResultSoftError();
        this.latch.offer(Result.Postponed);
    }

    public void rejectSync() {
        this.latch.offer(Result.Rejected);
    }

    public static enum Result {
        Success,
        Error,
        Postponed,
        Rejected;

    }
}

