/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.push.autopush;

import android.text.TextUtils;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.push.RegisterUserAgentResponse;
import org.mozilla.gecko.push.SubscribeChannelResponse;
import org.mozilla.gecko.push.autopush.AutopushClientException;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.BearerAuthHeaderProvider;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class AutopushClient {
    protected static final String LOG_TAG = AutopushClient.class.getSimpleName();
    protected static final String ACCEPT_HEADER = "application/json;charset=utf-8";
    protected static final String TYPE = "gcm";
    protected static final String JSON_KEY_UAID = "uaid";
    protected static final String JSON_KEY_SECRET = "secret";
    protected static final String JSON_KEY_CHANNEL_ID = "channelID";
    protected static final String JSON_KEY_ENDPOINT = "endpoint";
    protected static final String[] REGISTER_USER_AGENT_RESPONSE_REQUIRED_STRING_FIELDS = new String[]{"uaid", "secret", "channelID", "endpoint"};
    protected static final String[] REGISTER_CHANNEL_RESPONSE_REQUIRED_STRING_FIELDS = new String[]{"channelID", "endpoint"};
    public static final String JSON_KEY_CODE = "code";
    public static final String JSON_KEY_ERRNO = "errno";
    public static final String JSON_KEY_ERROR = "error";
    public static final String JSON_KEY_MESSAGE = "message";
    public final String serverURI;
    protected final Executor executor;

    public AutopushClient(String string, Executor executor) {
        if (string == null) {
            throw new IllegalArgumentException("Must provide a server URI.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must provide a non-null executor.");
        }
        String string2 = this.serverURI = string.endsWith("/") ? string : string + "/";
        if (!this.serverURI.endsWith("/")) {
            throw new IllegalArgumentException("Constructed serverURI must end with a trailing slash: " + this.serverURI);
        }
        this.executor = executor;
    }

    public String getSenderIDFromServerURI() throws AutopushClientException {
        String[] stringArray = this.serverURI.split("/", -1);
        if (stringArray.length < 3) {
            throw new AutopushClientException("Could not get sender ID from autopush server URI: " + this.serverURI);
        }
        if (!TextUtils.isEmpty((CharSequence)stringArray[stringArray.length - 1])) {
            throw new AutopushClientException("Could not get sender ID from autopush server URI: " + this.serverURI);
        }
        if (!TextUtils.equals((CharSequence)TYPE, (CharSequence)stringArray[stringArray.length - 3])) {
            throw new AutopushClientException("Could not get sender ID from autopush server URI: " + this.serverURI);
        }
        String string = stringArray[stringArray.length - 2];
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new AutopushClientException("Could not get sender ID from autopush server URI: " + this.serverURI);
        }
        return string;
    }

    public static int validateResponse(HttpResponse httpResponse) throws AutopushClientException {
        String string;
        String string2;
        int n;
        int n2;
        ExtendedJSONObject extendedJSONObject;
        int n3 = httpResponse.getStatusLine().getStatusCode();
        if (200 <= n3 && n3 <= 299) {
            return n3;
        }
        try {
            extendedJSONObject = new SyncStorageResponse(httpResponse).jsonObjectBody();
            n2 = extendedJSONObject.getLong(JSON_KEY_CODE).intValue();
            n = extendedJSONObject.getLong(JSON_KEY_ERRNO).intValue();
            string2 = extendedJSONObject.getString(JSON_KEY_ERROR);
            string = extendedJSONObject.getString(JSON_KEY_MESSAGE);
        }
        catch (Exception exception) {
            throw new AutopushClientException.AutopushClientMalformedResponseException(httpResponse);
        }
        throw new AutopushClientException.AutopushClientRemoteException(httpResponse, n2, n, string2, string, extendedJSONObject);
    }

    protected <T> void invokeHandleError(final RequestDelegate<T> requestDelegate, final Exception exception) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                requestDelegate.handleError(exception);
            }
        });
    }

    protected <T> void post(BaseResource baseResource, ExtendedJSONObject extendedJSONObject, RequestDelegate<T> requestDelegate) {
        try {
            if (extendedJSONObject == null) {
                baseResource.post((HttpEntity)null);
            } else {
                baseResource.post(extendedJSONObject);
            }
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
    }

    public void registerUserAgent(String string, RequestDelegate<RegisterUserAgentResponse> requestDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "registration"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<RegisterUserAgentResponse>((Resource)baseResource, null, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(REGISTER_USER_AGENT_RESPONSE_REQUIRED_STRING_FIELDS, String.class);
                    String string = extendedJSONObject.getString(AutopushClient.JSON_KEY_UAID);
                    String string2 = extendedJSONObject.getString(AutopushClient.JSON_KEY_SECRET);
                    this.delegate.handleSuccess(new RegisterUserAgentResponse(string, string2));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("type", TYPE);
        extendedJSONObject.put("token", string);
        baseResource.post(extendedJSONObject);
    }

    public void reregisterUserAgent(String string, String string2, String string3, RequestDelegate<Void> requestDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "registration/" + string));
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<Void>((Resource)baseResource, string2, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    this.delegate.handleSuccess(null);
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("type", TYPE);
        extendedJSONObject.put("token", string3);
        baseResource.put(extendedJSONObject);
    }

    public void subscribeChannel(String string, String string2, RequestDelegate<SubscribeChannelResponse> requestDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "registration/" + string + "/subscription"));
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<SubscribeChannelResponse>((Resource)baseResource, string2, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(REGISTER_CHANNEL_RESPONSE_REQUIRED_STRING_FIELDS, String.class);
                    String string = extendedJSONObject.getString(AutopushClient.JSON_KEY_CHANNEL_ID);
                    String string2 = extendedJSONObject.getString(AutopushClient.JSON_KEY_ENDPOINT);
                    this.delegate.handleSuccess(new SubscribeChannelResponse(string, string2));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        baseResource.post(extendedJSONObject);
    }

    public void unsubscribeChannel(String string, String string2, String string3, RequestDelegate<Void> requestDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "registration/" + string + "/subscription/" + string3));
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<Void>((Resource)baseResource, string2, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                this.delegate.handleSuccess(null);
            }
        };
        baseResource.delete();
    }

    public void unregisterUserAgent(String string, String string2, RequestDelegate<Void> requestDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "registration/" + string));
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<Void>((Resource)baseResource, string2, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                this.delegate.handleSuccess(null);
            }
        };
        baseResource.delete();
    }

    protected abstract class ResourceDelegate<T>
    extends BaseResourceDelegate {
        protected final String secret;
        protected final RequestDelegate<T> delegate;

        protected abstract void handleSuccess(int var1, HttpResponse var2, ExtendedJSONObject var3);

        public ResourceDelegate(Resource resource, String string, RequestDelegate<T> requestDelegate) {
            super(resource);
            this.delegate = requestDelegate;
            this.secret = string;
        }

        @Override
        public AuthHeaderProvider getAuthHeaderProvider() {
            if (this.secret != null) {
                return new BearerAuthHeaderProvider(this.secret);
            }
            return null;
        }

        @Override
        public String getUserAgent() {
            return "Firefox-Android-FxAccounts/48.0a1 (Firefox)";
        }

        @Override
        public void handleHttpResponse(HttpResponse httpResponse) {
            try {
                int n = AutopushClient.validateResponse(httpResponse);
                this.invokeHandleSuccess(n, httpResponse);
            }
            catch (AutopushClientException autopushClientException) {
                this.invokeHandleFailure(autopushClientException);
            }
        }

        protected void invokeHandleFailure(final AutopushClientException autopushClientException) {
            AutopushClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ResourceDelegate.this.delegate.handleFailure(autopushClientException);
                }
            });
        }

        protected void invokeHandleSuccess(final int n, final HttpResponse httpResponse) {
            AutopushClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExtendedJSONObject extendedJSONObject = new SyncResponse(httpResponse).jsonObjectBody();
                        ResourceDelegate.this.handleSuccess(n, httpResponse, extendedJSONObject);
                    }
                    catch (Exception exception) {
                        ResourceDelegate.this.delegate.handleError(exception);
                    }
                }
            });
        }

        @Override
        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            AutopushClient.this.invokeHandleError(this.delegate, (Exception)clientProtocolException);
        }

        @Override
        public void handleHttpIOException(IOException iOException) {
            AutopushClient.this.invokeHandleError(this.delegate, iOException);
        }

        @Override
        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            AutopushClient.this.invokeHandleError(this.delegate, generalSecurityException);
        }

        @Override
        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            super.addHeaders(httpRequestBase, defaultHttpClient);
            Locale locale = Locale.getDefault();
            httpRequestBase.addHeader("Accept-Language", Locales.getLanguageTag((Locale)locale));
            httpRequestBase.addHeader("Accept", AutopushClient.ACCEPT_HEADER);
        }
    }

    public static interface RequestDelegate<T> {
        public void handleError(Exception var1);

        public void handleFailure(AutopushClientException var1);

        public void handleSuccess(T var1);
    }
}

