/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import java.net.URI;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;

public class Sync11Configuration
extends SyncConfiguration {
    private static final String LOG_TAG = "Sync11Configuration";
    private static final String API_VERSION = "1.1";

    public Sync11Configuration(String string, AuthHeaderProvider authHeaderProvider, SharedPreferences sharedPreferences) {
        super(string, authHeaderProvider, sharedPreferences);
    }

    public Sync11Configuration(String string, AuthHeaderProvider authHeaderProvider, SharedPreferences sharedPreferences, KeyBundle keyBundle) {
        super(string, authHeaderProvider, sharedPreferences, keyBundle);
    }

    @Override
    public String getAPIVersion() {
        return API_VERSION;
    }

    @Override
    public String storageURL() {
        return this.clusterURL + API_VERSION + "/" + this.username + "/storage";
    }

    @Override
    protected String infoBaseURL() {
        return this.clusterURL + API_VERSION + "/" + this.username + "/info/";
    }

    protected void setAndPersistClusterURL(URI uRI, SharedPreferences sharedPreferences) {
        boolean bl = sharedPreferences != null && this.clusterURL == null;
        Logger.trace(LOG_TAG, "Setting cluster URL to " + uRI.toASCIIString() + (bl ? ". Persisting." : ". Not persisting."));
        this.clusterURL = uRI;
        if (bl) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("clusterURL", this.clusterURL.toASCIIString());
            editor.commit();
        }
    }

    protected void setClusterURL(URI uRI, SharedPreferences sharedPreferences) {
        if (uRI == null) {
            Logger.warn(LOG_TAG, "Refusing to set cluster URL to null.");
            return;
        }
        URI uRI2 = uRI.normalize();
        if (uRI2.toASCIIString().endsWith("/")) {
            this.setAndPersistClusterURL(uRI, sharedPreferences);
            return;
        }
        this.setAndPersistClusterURL(uRI2.resolve("/"), sharedPreferences);
        Logger.trace(LOG_TAG, "Set cluster URL to " + this.clusterURL.toASCIIString() + ", given input " + uRI.toASCIIString());
    }

    @Override
    public void setClusterURL(URI uRI) {
        this.setClusterURL(uRI, this.getPrefs());
    }
}

