/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.SyncStorageRequest;

public class SyncStorageRecordRequest
extends SyncStorageRequest {
    public SyncStorageRecordRequest(URI uRI) {
        super(uRI);
    }

    public SyncStorageRecordRequest(String string) throws URISyntaxException {
        this(new URI(string));
    }

    @Override
    protected BaseResourceDelegate makeResourceDelegate(SyncStorageRequest syncStorageRequest) {
        return new SyncStorageRecordResourceDelegate(syncStorageRequest);
    }

    public void post(JSONObject jSONObject) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)jSONObject);
        try {
            this.resource.post(jSONArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.delegate.handleRequestError(unsupportedEncodingException);
        }
    }

    public void post(JSONArray jSONArray) {
        try {
            this.resource.post(jSONArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.delegate.handleRequestError(unsupportedEncodingException);
        }
    }

    public void put(JSONObject jSONObject) {
        try {
            this.resource.put(jSONObject);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.delegate.handleRequestError(unsupportedEncodingException);
        }
    }

    public void post(CryptoRecord cryptoRecord) {
        this.post(cryptoRecord.toJSONObject());
    }

    public void put(CryptoRecord cryptoRecord) {
        this.put(cryptoRecord.toJSONObject());
    }

    public class SyncStorageRecordResourceDelegate
    extends SyncStorageRequest.SyncStorageResourceDelegate {
        SyncStorageRecordResourceDelegate(SyncStorageRequest syncStorageRequest) {
            super(SyncStorageRecordRequest.this, syncStorageRequest);
        }
    }
}

