/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.domain;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import org.json.simple.JSONArray;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class BookmarkRecord
extends Record {
    public static final String PLACES_URI_PREFIX = "places:";
    private static final String LOG_TAG = "BookmarkRecord";
    public static final String COLLECTION_NAME = "bookmarks";
    public static final long BOOKMARKS_TTL = -1L;
    public String title;
    public String bookmarkURI;
    public String description;
    public String keyword;
    public String parentID;
    public String parentName;
    public long androidParentID;
    public String type;
    public long androidPosition;
    public JSONArray children;
    public JSONArray tags;

    public BookmarkRecord(String string2, String string3, long l, boolean bl) {
        super(string2, string3, l, bl);
        this.ttl = -1L;
    }

    public BookmarkRecord(String string2, String string3, long l) {
        this(string2, string3, l, false);
    }

    public BookmarkRecord(String string2, String string3) {
        this(string2, string3, 0L, false);
    }

    public BookmarkRecord(String string2) {
        this(string2, COLLECTION_NAME, 0L, false);
    }

    public BookmarkRecord() {
        this(Utils.generateGuid(), COLLECTION_NAME, 0L, false);
    }

    public String toString() {
        return "#<Bookmark " + this.guid + " (" + this.androidID + "), parent " + this.parentID + "/" + this.androidParentID + "/" + this.parentName + ">";
    }

    protected JSONArray copyChildren() {
        if (this.children == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll((Collection)this.children);
        return jSONArray;
    }

    protected JSONArray copyTags() {
        if (this.tags == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll((Collection)this.tags);
        return jSONArray;
    }

    @Override
    public Record copyWithIDs(String string2, long l) {
        BookmarkRecord bookmarkRecord = new BookmarkRecord(string2, this.collection, this.lastModified, this.deleted);
        bookmarkRecord.androidID = l;
        bookmarkRecord.sortIndex = this.sortIndex;
        bookmarkRecord.ttl = this.ttl;
        bookmarkRecord.title = this.title;
        bookmarkRecord.bookmarkURI = this.bookmarkURI;
        bookmarkRecord.description = this.description;
        bookmarkRecord.keyword = this.keyword;
        bookmarkRecord.parentID = this.parentID;
        bookmarkRecord.parentName = this.parentName;
        bookmarkRecord.androidParentID = this.androidParentID;
        bookmarkRecord.type = this.type;
        bookmarkRecord.androidPosition = this.androidPosition;
        bookmarkRecord.children = this.copyChildren();
        bookmarkRecord.tags = this.copyTags();
        return bookmarkRecord;
    }

    public boolean isBookmark() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("bookmark");
    }

    public boolean isFolder() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("folder");
    }

    public boolean isLivemark() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("livemark");
    }

    public boolean isSeparator() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("separator");
    }

    public boolean isMicrosummary() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("microsummary");
    }

    public boolean isQuery() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("query");
    }

    private boolean isBookmarkIsh() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("bookmark") || this.type.equals("microsummary") || this.type.equals("query");
    }

    @Override
    protected void initFromPayload(ExtendedJSONObject extendedJSONObject) {
        this.type = extendedJSONObject.getString("type");
        this.title = extendedJSONObject.getString("title");
        this.description = extendedJSONObject.getString("description");
        this.parentID = extendedJSONObject.getString("parentid");
        this.parentName = extendedJSONObject.getString("parentName");
        if (this.isFolder()) {
            try {
                this.children = extendedJSONObject.getArray("children");
            }
            catch (NonArrayJSONException nonArrayJSONException) {
                Logger.error(LOG_TAG, "Got non-array children in bookmark record " + this.guid, nonArrayJSONException);
                this.children = new JSONArray();
            }
            return;
        }
        String string2 = extendedJSONObject.getString("bmkUri");
        if (this.isBookmarkIsh()) {
            this.keyword = extendedJSONObject.getString("keyword");
            try {
                this.tags = extendedJSONObject.getArray("tags");
            }
            catch (NonArrayJSONException nonArrayJSONException) {
                Logger.warn(LOG_TAG, "Got non-array tags in bookmark record " + this.guid, nonArrayJSONException);
                this.tags = new JSONArray();
            }
        }
        if (this.isBookmark()) {
            this.bookmarkURI = string2;
            return;
        }
        if (this.isLivemark()) {
            String string3 = extendedJSONObject.getString("siteUri");
            String string4 = extendedJSONObject.getString("feedUri");
            this.bookmarkURI = BookmarkRecord.encodeUnsupportedTypeURI(string2, "siteUri", string3, "feedUri", string4);
            return;
        }
        if (this.isQuery()) {
            String string5 = extendedJSONObject.getString("queryId");
            String string6 = extendedJSONObject.getString("folderName");
            this.bookmarkURI = BookmarkRecord.encodeUnsupportedTypeURI(string2, "queryId", string5, "folderName", string6);
            return;
        }
        if (this.isMicrosummary()) {
            String string7 = extendedJSONObject.getString("generatorUri");
            String string8 = extendedJSONObject.getString("staticTitle");
            this.bookmarkURI = BookmarkRecord.encodeUnsupportedTypeURI(string2, "generatorUri", string7, "staticTitle", string8);
            return;
        }
        if (this.isSeparator()) {
            Object object = extendedJSONObject.get("pos");
            if (object instanceof Long) {
                this.androidPosition = (Long)object;
            } else if (object instanceof String) {
                try {
                    this.androidPosition = Long.parseLong((String)object, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            } else {
                Logger.warn(LOG_TAG, "Unsupported position value " + object);
                return;
            }
            String string9 = String.valueOf(this.androidPosition);
            this.bookmarkURI = BookmarkRecord.encodeUnsupportedTypeURI(null, "pos", string9, null, null);
            return;
        }
    }

    @Override
    protected void populatePayload(ExtendedJSONObject extendedJSONObject) {
        this.putPayload(extendedJSONObject, "type", this.type);
        this.putPayload(extendedJSONObject, "title", this.title);
        this.putPayload(extendedJSONObject, "description", this.description);
        this.putPayload(extendedJSONObject, "parentid", this.parentID);
        this.putPayload(extendedJSONObject, "parentName", this.parentName);
        this.putPayload(extendedJSONObject, "keyword", this.keyword);
        if (this.isFolder()) {
            extendedJSONObject.put("children", this.children);
            return;
        }
        if (this.isBookmarkIsh()) {
            if (this.isBookmark()) {
                extendedJSONObject.put("bmkUri", this.bookmarkURI);
            }
            if (this.isQuery()) {
                Map<String, String> map = Utils.extractURIComponents(PLACES_URI_PREFIX, this.bookmarkURI);
                this.putPayload(extendedJSONObject, "queryId", map.get("queryId"), true);
                this.putPayload(extendedJSONObject, "folderName", map.get("folderName"), true);
                this.putPayload(extendedJSONObject, "bmkUri", map.get("uri"));
                return;
            }
            if (this.tags != null) {
                extendedJSONObject.put("tags", this.tags);
            }
            this.putPayload(extendedJSONObject, "keyword", this.keyword);
            return;
        }
        if (this.isLivemark()) {
            Map<String, String> map = Utils.extractURIComponents(PLACES_URI_PREFIX, this.bookmarkURI);
            this.putPayload(extendedJSONObject, "siteUri", map.get("siteUri"));
            this.putPayload(extendedJSONObject, "feedUri", map.get("feedUri"));
            return;
        }
        if (this.isMicrosummary()) {
            Map<String, String> map = Utils.extractURIComponents(PLACES_URI_PREFIX, this.bookmarkURI);
            this.putPayload(extendedJSONObject, "generatorUri", map.get("generatorUri"));
            this.putPayload(extendedJSONObject, "staticTitle", map.get("staticTitle"));
            return;
        }
        if (this.isSeparator()) {
            Map<String, String> map = Utils.extractURIComponents(PLACES_URI_PREFIX, this.bookmarkURI);
            String string2 = map.get("pos");
            if (string2 == null) {
                return;
            }
            try {
                extendedJSONObject.put("pos", Long.parseLong(string2, 10));
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            return;
        }
    }

    private void trace(String string2) {
        Logger.trace(LOG_TAG, string2);
    }

    @Override
    public boolean equalPayloads(Object object) {
        this.trace("Calling BookmarkRecord.equalPayloads.");
        if (!(object instanceof BookmarkRecord)) {
            return false;
        }
        BookmarkRecord bookmarkRecord = (BookmarkRecord)object;
        if (!super.equalPayloads(bookmarkRecord)) {
            return false;
        }
        if (!RepoUtils.stringsEqual(this.type, bookmarkRecord.type)) {
            return false;
        }
        if (this.isFolder() && this.children != bookmarkRecord.children) {
            this.trace("BookmarkRecord.equals: this folder: " + this.title + ", " + this.guid);
            this.trace("BookmarkRecord.equals: other: " + bookmarkRecord.title + ", " + bookmarkRecord.guid);
            if (this.children == null && bookmarkRecord.children != null) {
                this.trace("Records differ: one children array is null.");
                return false;
            }
            if (this.children != null && bookmarkRecord.children == null) {
                this.trace("Records differ: one children array is null.");
                return false;
            }
            if (this.children.size() != bookmarkRecord.children.size()) {
                this.trace("Records differ: children arrays differ in size (" + this.children.size() + " vs. " + bookmarkRecord.children.size() + ").");
                return false;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                String string2 = (String)this.children.get(i);
                if (bookmarkRecord.children.contains((Object)string2)) continue;
                this.trace("Records differ: child " + string2 + " not found.");
                return false;
            }
        }
        this.trace("Checking strings.");
        return RepoUtils.stringsEqual(this.title, bookmarkRecord.title) && RepoUtils.stringsEqual(this.bookmarkURI, bookmarkRecord.bookmarkURI) && RepoUtils.stringsEqual(this.parentID, bookmarkRecord.parentID) && RepoUtils.stringsEqual(this.parentName, bookmarkRecord.parentName) && RepoUtils.stringsEqual(this.description, bookmarkRecord.description) && RepoUtils.stringsEqual(this.keyword, bookmarkRecord.keyword) && this.jsonArrayStringsEqual(this.tags, bookmarkRecord.tags);
    }

    @Override
    public boolean congruentWith(Object object) {
        return this.equalPayloads(object) && super.congruentWith(object);
    }

    private boolean jsonArrayStringsEqual(JSONArray jSONArray, JSONArray jSONArray2) {
        if (jSONArray == jSONArray2) {
            return true;
        }
        if (jSONArray == null && jSONArray2 != null) {
            return false;
        }
        if (jSONArray != null && jSONArray2 == null) {
            return false;
        }
        return RepoUtils.stringsEqual(jSONArray.toJSONString(), jSONArray2.toJSONString());
    }

    protected static String encode(String string2) {
        if (string2 == null) {
            return "";
        }
        try {
            return URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    protected static String encodeUnsupportedTypeURI(String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder(PLACES_URI_PREFIX);
        boolean bl = false;
        if (string2 != null) {
            stringBuilder.append("uri=");
            stringBuilder.append(BookmarkRecord.encode(string2));
            bl = true;
        }
        if (string3 != null && string4 != null) {
            if (bl) {
                stringBuilder.append("&");
            }
            stringBuilder.append(string3);
            stringBuilder.append("=");
            stringBuilder.append(BookmarkRecord.encode(string4));
            bl = true;
        }
        if (string5 != null && string6 != null) {
            if (bl) {
                stringBuilder.append("&");
            }
            stringBuilder.append(string5);
            stringBuilder.append("=");
            stringBuilder.append(BookmarkRecord.encode(string6));
            bl = true;
        }
        return stringBuilder.toString();
    }
}

