/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.util.Patterns;
import android.webkit.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;

public class WebURLFinder {
    public final List<String> candidates;

    public WebURLFinder(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        this.candidates = WebURLFinder.candidateWebURLs(string);
    }

    public WebURLFinder(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("strings must not be null");
        }
        this.candidates = WebURLFinder.candidateWebURLs(list);
    }

    public static boolean isWebURL(String string) {
        try {
            new URI(string);
        }
        catch (Exception exception) {
            return false;
        }
        return !URLUtil.isFileUrl((String)string) && !URLUtil.isJavaScriptUrl((String)string);
    }

    public String bestWebURL() {
        String string = this.firstWebURLWithScheme();
        if (string != null) {
            return string;
        }
        return this.firstWebURLWithoutScheme();
    }

    protected static List<String> candidateWebURLs(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (string == null) continue;
            arrayList.addAll(WebURLFinder.candidateWebURLs(string));
        }
        return arrayList;
    }

    protected static List<String> candidateWebURLs(String string) {
        Matcher matcher = Patterns.WEB_URL.matcher(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (matcher.find()) {
            if (!WebURLFinder.isWebURL(matcher.group()) || matcher.start() > 0 && string.charAt(matcher.start() - 1) == '@') continue;
            linkedList.add(matcher.group());
        }
        return linkedList;
    }

    protected String firstWebURLWithScheme() {
        for (String string : this.candidates) {
            try {
                if (new URI(string).getScheme() == null) continue;
                return string;
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return null;
    }

    protected String firstWebURLWithoutScheme() {
        if (!this.candidates.isEmpty()) {
            return this.candidates.get(0);
        }
        return null;
    }
}

