/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class MediaCastingBar
extends RelativeLayout
implements View.OnClickListener,
GeckoEventListener {
    private static final String LOGTAG = "GeckoMediaCastingBar";
    private TextView mCastingTo;
    private ImageButton mMediaPlay;
    private ImageButton mMediaPause;
    private ImageButton mMediaStop;
    private boolean mInflated;

    public MediaCastingBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Casting:Started", "Casting:Paused", "Casting:Playing", "Casting:Stopped");
    }

    public void inflateContent() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        View view = layoutInflater.inflate(R.layout.media_casting, (ViewGroup)this);
        this.mMediaPlay = (ImageButton)view.findViewById(R.id.media_play);
        this.mMediaPlay.setOnClickListener((View.OnClickListener)this);
        this.mMediaPause = (ImageButton)view.findViewById(R.id.media_pause);
        this.mMediaPause.setOnClickListener((View.OnClickListener)this);
        this.mMediaStop = (ImageButton)view.findViewById(R.id.media_stop);
        this.mMediaStop.setOnClickListener((View.OnClickListener)this);
        this.mCastingTo = (TextView)view.findViewById(R.id.media_sending_to);
        view.setOnClickListener((View.OnClickListener)this);
        this.mInflated = true;
    }

    public void show() {
        if (!this.mInflated) {
            this.inflateContent();
        }
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public void onDestroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Casting:Started", "Casting:Paused", "Casting:Playing", "Casting:Stopped");
    }

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.media_play) {
            GeckoAppShell.notifyObservers("Casting:Play", "");
            this.mMediaPlay.setVisibility(8);
            this.mMediaPause.setVisibility(0);
        } else if (n == R.id.media_pause) {
            GeckoAppShell.notifyObservers("Casting:Pause", "");
            this.mMediaPause.setVisibility(8);
            this.mMediaPlay.setVisibility(0);
        } else if (n == R.id.media_stop) {
            GeckoAppShell.notifyObservers("Casting:Stop", "");
        }
    }

    public void handleMessage(final String string2, JSONObject jSONObject) {
        final String string3 = jSONObject.optString("device");
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (string2.equals("Casting:Started")) {
                    MediaCastingBar.this.show();
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        MediaCastingBar.this.mCastingTo.setText((CharSequence)string3);
                    } else {
                        MediaCastingBar.this.mCastingTo.setText((CharSequence)"");
                        Log.d((String)MediaCastingBar.LOGTAG, (String)"Device name is empty.");
                    }
                    MediaCastingBar.this.mMediaPlay.setVisibility(8);
                    MediaCastingBar.this.mMediaPause.setVisibility(0);
                } else if (string2.equals("Casting:Paused")) {
                    MediaCastingBar.this.mMediaPause.setVisibility(8);
                    MediaCastingBar.this.mMediaPlay.setVisibility(0);
                } else if (string2.equals("Casting:Playing")) {
                    MediaCastingBar.this.mMediaPlay.setVisibility(8);
                    MediaCastingBar.this.mMediaPause.setVisibility(0);
                } else if (string2.equals("Casting:Stopped")) {
                    MediaCastingBar.this.hide();
                }
            }
        });
    }
}

