/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.TwoLinePageRow;

public class RemoteTabsExpandableListAdapter
extends BaseExpandableListAdapter {
    private static final Date EARLIEST_VALID_SYNCED_DATE;
    protected final ArrayList<RemoteClient> clients;
    private final boolean showGroupIndicator;
    protected int groupLayoutId;
    protected int childLayoutId;

    public RemoteTabsExpandableListAdapter(int n, int n2, List<RemoteClient> list, boolean bl) {
        this.groupLayoutId = n;
        this.childLayoutId = n2;
        this.clients = new ArrayList();
        if (list != null) {
            this.clients.addAll(list);
        }
        this.showGroupIndicator = bl;
    }

    public void replaceClients(List<RemoteClient> list) {
        this.clients.clear();
        if (list != null) {
            this.clients.addAll(list);
            this.notifyDataSetChanged();
        } else {
            this.notifyDataSetInvalidated();
        }
    }

    public boolean hasStableIds() {
        return false;
    }

    public long getGroupId(int n) {
        return this.clients.get((int)n).guid.hashCode();
    }

    public int getGroupCount() {
        return this.clients.size();
    }

    public Object getGroup(int n) {
        return this.clients.get(n);
    }

    public int getChildrenCount(int n) {
        return this.clients.get((int)n).tabs.size();
    }

    public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
        Object object;
        View view2;
        Context context = viewGroup.getContext();
        if (view != null) {
            view2 = view;
        } else {
            object = LayoutInflater.from((Context)context);
            view2 = object.inflate(this.groupLayoutId, viewGroup, false);
            GroupViewHolder groupViewHolder = new GroupViewHolder(view2);
            view2.setTag((Object)groupViewHolder);
        }
        object = this.clients.get(n);
        this.updateClientsItemView(bl, context, view2, (RemoteClient)object);
        return view2;
    }

    public void updateClientsItemView(boolean bl, Context context, View view, RemoteClient remoteClient) {
        int n;
        int n2;
        int n3;
        GroupViewHolder groupViewHolder = (GroupViewHolder)view.getTag();
        if (bl && !remoteClient.tabs.isEmpty()) {
            n3 = "desktop".equals(remoteClient.deviceType) ? R.drawable.sync_desktop : R.drawable.sync_mobile;
            n2 = R.color.placeholder_active_grey;
            n = this.showGroupIndicator ? R.drawable.arrow_down : R.drawable.home_group_collapsed;
        } else {
            n3 = "desktop".equals(remoteClient.deviceType) ? R.drawable.sync_desktop_inactive : R.drawable.sync_mobile_inactive;
            n2 = R.color.tabs_tray_icon_grey;
            n = this.showGroupIndicator ? R.drawable.home_group_collapsed : 0;
        }
        groupViewHolder.nameView.setText((CharSequence)remoteClient.name);
        groupViewHolder.nameView.setTextColor(ContextCompat.getColor((Context)context, (int)n2));
        long l = System.currentTimeMillis();
        GeckoProfile geckoProfile = GeckoProfile.get(context);
        groupViewHolder.lastModifiedView.setText((CharSequence)RemoteTabsExpandableListAdapter.getLastSyncedString(context, l, remoteClient.lastModified));
        if (groupViewHolder.deviceTypeView != null) {
            groupViewHolder.deviceTypeView.setImageResource(n3);
        }
        if (groupViewHolder.deviceExpandedView != null) {
            groupViewHolder.deviceExpandedView.setImageResource(remoteClient.tabs.isEmpty() ? 0 : n);
        }
    }

    public boolean isChildSelectable(int n, int n2) {
        return true;
    }

    public Object getChild(int n, int n2) {
        return this.clients.get((int)n).tabs.get(n2);
    }

    public long getChildId(int n, int n2) {
        return this.clients.get((int)n).tabs.get(n2).hashCode();
    }

    public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
        Object object;
        View view2;
        Context context = viewGroup.getContext();
        if (view != null) {
            view2 = view;
        } else {
            object = LayoutInflater.from((Context)context);
            view2 = object.inflate(this.childLayoutId, viewGroup, false);
        }
        object = this.clients.get(n);
        RemoteTab remoteTab = object.tabs.get(n2);
        if (view2 instanceof TwoLinePageRow) {
            ((TwoLinePageRow)view2).update(remoteTab.title, remoteTab.url);
        } else {
            TextView textView = (TextView)view2.findViewById(R.id.title);
            textView.setText((CharSequence)(TextUtils.isEmpty((CharSequence)remoteTab.title) ? remoteTab.url : remoteTab.title));
            TextView textView2 = (TextView)view2.findViewById(R.id.url);
            textView2.setText((CharSequence)remoteTab.url);
        }
        return view2;
    }

    public static String getLastSyncedString(Context context, long l, long l2) {
        if (new Date(l2).before(EARLIEST_VALID_SYNCED_DATE)) {
            return context.getString(R.string.remote_tabs_never_synced);
        }
        CharSequence charSequence = DateUtils.getRelativeTimeSpanString((long)l2, (long)l, (long)60000L);
        return context.getResources().getString(R.string.remote_tabs_last_synced, new Object[]{charSequence});
    }

    static {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0, 0);
        EARLIEST_VALID_SYNCED_DATE = calendar.getTime();
    }

    public static class GroupViewHolder {
        final TextView nameView;
        final TextView lastModifiedView;
        final ImageView deviceTypeView;
        final ImageView deviceExpandedView;

        public GroupViewHolder(View view) {
            this.nameView = (TextView)view.findViewById(R.id.client);
            this.lastModifiedView = (TextView)view.findViewById(R.id.last_synced);
            this.deviceTypeView = (ImageView)view.findViewById(R.id.device_type);
            this.deviceExpandedView = (ImageView)view.findViewById(R.id.device_expanded);
        }
    }
}

