/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.mozilla.gecko.gfx.BufferedImage;
import org.mozilla.gecko.gfx.BufferedImageGLInfo;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerRenderer;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.gfx.TextureReaper;
import org.mozilla.gecko.util.FloatUtils;

public class ScrollbarLayer
extends Layer {
    private static final String LOGTAG = "GeckoScrollbarLayer";
    public static final long FADE_DELAY = 500L;
    private static final float FADE_MILLIS = 250.0f;
    private final boolean mVertical;
    private float mOpacity;
    private final Rect mDirtyRect;
    private IntSize mSize;
    private int[] mTextureIDs;
    private final BufferedImage mImage;
    private final RectF mBarRectF;
    private final Rect mBarRect;
    private final float[] mCoords;
    private final RectF mCapRectF;
    private final LayerRenderer mRenderer;
    private int mProgram;
    private int mPositionHandle;
    private int mTextureHandle;
    private int mSampleHandle;
    private int mTMatrixHandle;
    private int mOpacityHandle;
    private static final String FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTexCoord;\nuniform sampler2D sTexture;\nuniform float uOpacity;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTexCoord);\n    gl_FragColor.a *= uOpacity;\n}\n";
    private final int mTexWidth;
    private final int mTexHeight;
    private final int mBarWidth;
    private final int mCapLength;
    private final Rect mStartCapTexCoords;
    private final Rect mBodyTexCoords;
    private final Rect mEndCapTexCoords;

    ScrollbarLayer(LayerRenderer layerRenderer, Bitmap bitmap, IntSize intSize, boolean bl) {
        super(new IntSize(bitmap.getHeight(), bitmap.getWidth()));
        this.mImage = new BufferedImage(bitmap);
        this.mRenderer = layerRenderer;
        this.mVertical = bl;
        this.mBarRectF = new RectF();
        this.mBarRect = new Rect();
        this.mCoords = new float[20];
        this.mCapRectF = new RectF();
        this.mDirtyRect = new Rect();
        this.mSize = new IntSize(0, 0);
        this.mTexHeight = bitmap.getHeight();
        this.mTexWidth = bitmap.getWidth();
        if (this.mVertical) {
            this.mBarWidth = intSize.width;
            this.mCapLength = intSize.height / 2;
            this.mStartCapTexCoords = new Rect(0, this.mTexHeight - this.mCapLength, intSize.width, this.mTexHeight);
            this.mBodyTexCoords = new Rect(0, this.mTexHeight - (this.mCapLength + 1), intSize.width, this.mTexHeight - this.mCapLength);
            this.mEndCapTexCoords = new Rect(0, this.mTexHeight - intSize.height, intSize.width, this.mTexHeight - (this.mCapLength + 1));
        } else {
            this.mBarWidth = intSize.height;
            this.mCapLength = intSize.width / 2;
            this.mStartCapTexCoords = new Rect(0, this.mTexHeight - intSize.height, this.mCapLength, this.mTexHeight);
            this.mBodyTexCoords = new Rect(this.mCapLength, this.mTexHeight - intSize.height, this.mCapLength + 1, this.mTexHeight);
            this.mEndCapTexCoords = new Rect(this.mCapLength + 1, this.mTexHeight - intSize.height, intSize.width, this.mTexHeight);
        }
    }

    private void createProgram() {
        int n = LayerRenderer.loadShader(35633, "uniform mat4 uTMatrix;\nattribute vec4 vPosition;\nattribute vec2 aTexCoord;\nvarying vec2 vTexCoord;\nvoid main() {\n    gl_Position = uTMatrix * vPosition;\n    vTexCoord.x = aTexCoord.x;\n    vTexCoord.y = 1.0 - aTexCoord.y;\n}\n");
        int n2 = LayerRenderer.loadShader(35632, FRAGMENT_SHADER);
        this.mProgram = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.mProgram, (int)n);
        GLES20.glAttachShader((int)this.mProgram, (int)n2);
        GLES20.glLinkProgram((int)this.mProgram);
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"vPosition");
        this.mTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTexCoord");
        this.mSampleHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"sTexture");
        this.mTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTMatrix");
        this.mOpacityHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uOpacity");
    }

    private void activateProgram() {
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glUniformMatrix4fv((int)this.mTMatrixHandle, (int)1, (boolean)false, (float[])LayerRenderer.DEFAULT_TEXTURE_MATRIX, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glEnableVertexAttribArray((int)this.mTextureHandle);
        GLES20.glUniform1i((int)this.mSampleHandle, (int)0);
        GLES20.glUniform1f((int)this.mOpacityHandle, (float)this.mOpacity);
    }

    private void deactivateProgram() {
        GLES20.glDisableVertexAttribArray((int)this.mTextureHandle);
        GLES20.glDisableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glUseProgram((int)0);
    }

    public boolean fade(long l, long l2) {
        if (FloatUtils.fuzzyEquals((float)this.mOpacity, (float)0.0f)) {
            return false;
        }
        this.beginTransaction();
        this.mOpacity = Math.max(1.0f - (float)(l2 - l) / 250.0f, 0.0f);
        this.endTransaction();
        return true;
    }

    public boolean unfade() {
        if (FloatUtils.fuzzyEquals((float)this.mOpacity, (float)1.0f)) {
            return false;
        }
        this.beginTransaction();
        this.mOpacity = 1.0f;
        this.endTransaction();
        return true;
    }

    @Override
    public void draw(Layer.RenderContext renderContext) {
        if (!this.initialized()) {
            return;
        }
        if (this.mProgram == 0) {
            this.createProgram();
        }
        this.mRenderer.deactivateDefaultProgram();
        this.activateProgram();
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        if (this.mVertical) {
            this.getVerticalRect(renderContext, this.mBarRectF);
        } else {
            this.getHorizontalRect(renderContext, this.mBarRectF);
        }
        RectUtils.round(this.mBarRectF, this.mBarRect);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.getTextureID());
        float f = renderContext.viewport.width();
        float f2 = renderContext.viewport.height();
        this.mBarRectF.set((float)this.mBarRect.left, f2 - (float)this.mBarRect.top, (float)this.mBarRect.right, f2 - (float)this.mBarRect.bottom);
        this.fillRectCoordBuffer(this.mCoords, this.mBarRectF, f, f2, this.mBodyTexCoords, this.mTexWidth, this.mTexHeight);
        FloatBuffer floatBuffer = renderContext.coordBuffer;
        int n = this.mPositionHandle;
        int n2 = this.mTextureHandle;
        floatBuffer.position(0);
        floatBuffer.put(this.mCoords);
        GLES20.glBindBuffer((int)34962, (int)0);
        floatBuffer.position(0);
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        floatBuffer.position(3);
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        floatBuffer.position(0);
        if (this.mVertical) {
            this.mCapRectF.set(this.mBarRectF.left, this.mBarRectF.top + (float)this.mCapLength, this.mBarRectF.right, this.mBarRectF.top);
        } else {
            this.mCapRectF.set(this.mBarRectF.left - (float)this.mCapLength, this.mBarRectF.bottom + (float)this.mBarWidth, this.mBarRectF.left, this.mBarRectF.bottom);
        }
        this.fillRectCoordBuffer(this.mCoords, this.mCapRectF, f, f2, this.mStartCapTexCoords, this.mTexWidth, this.mTexHeight);
        floatBuffer.put(this.mCoords);
        floatBuffer.position(0);
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        floatBuffer.position(3);
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        floatBuffer.position(0);
        if (this.mVertical) {
            this.mCapRectF.set(this.mBarRectF.left, this.mBarRectF.bottom, this.mBarRectF.right, this.mBarRectF.bottom - (float)this.mCapLength);
        } else {
            this.mCapRectF.set(this.mBarRectF.right, this.mBarRectF.bottom + (float)this.mBarWidth, this.mBarRectF.right + (float)this.mCapLength, this.mBarRectF.bottom);
        }
        this.fillRectCoordBuffer(this.mCoords, this.mCapRectF, f, f2, this.mEndCapTexCoords, this.mTexWidth, this.mTexHeight);
        floatBuffer.put(this.mCoords);
        floatBuffer.position(0);
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        floatBuffer.position(3);
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        floatBuffer.position(0);
        this.deactivateProgram();
        this.mRenderer.activateDefaultProgram();
    }

    private void getVerticalRect(Layer.RenderContext renderContext, RectF rectF) {
        float f;
        RectF rectF2 = renderContext.viewport;
        RectF rectF3 = renderContext.pageRect;
        float f2 = rectF2.height();
        float f3 = (rectF2.top - rectF3.top) * (f2 / rectF3.height()) + (float)this.mCapLength;
        if (f3 > (f = (rectF2.bottom - rectF3.top) * (f2 / rectF3.height()) - (float)this.mCapLength)) {
            float f4;
            f3 = f = (f4 = (f3 + f) / 2.0f);
        }
        rectF.set(rectF2.width() - (float)this.mBarWidth, f3, rectF2.width(), f);
    }

    private void getHorizontalRect(Layer.RenderContext renderContext, RectF rectF) {
        float f;
        RectF rectF2 = renderContext.viewport;
        RectF rectF3 = renderContext.pageRect;
        float f2 = rectF2.width();
        float f3 = (rectF2.left - rectF3.left) * (rectF2.width() / rectF3.width()) + (float)this.mCapLength;
        if (f3 > (f = (rectF2.right - rectF3.left) * (rectF2.width() / rectF3.width()) - (float)this.mCapLength)) {
            float f4;
            f3 = f = (f4 = (f3 + f) / 2.0f);
        }
        rectF.set(f3, rectF2.height() - (float)this.mBarWidth, f, rectF2.height());
    }

    private void validateTexture() {
        IntSize intSize = this.mImage.getSize().nextPowerOfTwo();
        if (!intSize.equals(this.mSize)) {
            this.mSize = intSize;
            if (this.mTextureIDs != null) {
                TextureReaper.get().add(this.mTextureIDs);
                this.mTextureIDs = null;
                TextureReaper.get().reap();
            }
        }
    }

    @Override
    protected void performUpdates(Layer.RenderContext renderContext) {
        super.performUpdates(renderContext);
        this.validateTexture();
        if (!this.mImage.getSize().isPositive()) {
            return;
        }
        if (this.mTextureIDs == null) {
            this.uploadFullTexture();
        } else {
            this.uploadDirtyRect(this.mDirtyRect);
        }
        this.mDirtyRect.setEmpty();
    }

    private void uploadFullTexture() {
        IntSize intSize = this.mImage.getSize();
        this.uploadDirtyRect(new Rect(0, 0, intSize.width, intSize.height));
    }

    private void uploadDirtyRect(Rect rect) {
        if (rect.isEmpty()) {
            return;
        }
        ByteBuffer byteBuffer = this.mImage.getBuffer();
        if (byteBuffer == null) {
            return;
        }
        if (this.mTextureIDs == null) {
            this.mTextureIDs = new int[1];
            GLES20.glGenTextures((int)this.mTextureIDs.length, (int[])this.mTextureIDs, (int)0);
        }
        int n = this.mImage.getFormat();
        BufferedImageGLInfo bufferedImageGLInfo = new BufferedImageGLInfo(n);
        this.bindAndSetGLParameters();
        IntSize intSize = this.mImage.getSize();
        if (!this.mSize.equals(intSize)) {
            throw new RuntimeException("Buffer/image size mismatch in ScrollbarLayer!");
        }
        GLES20.glTexImage2D((int)3553, (int)0, (int)bufferedImageGLInfo.internalFormat, (int)this.mSize.width, (int)this.mSize.height, (int)0, (int)bufferedImageGLInfo.format, (int)bufferedImageGLInfo.type, (Buffer)byteBuffer);
    }

    private void bindAndSetGLParameters() {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mTextureIDs[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        int n = 33071;
        GLES20.glTexParameterf((int)3553, (int)10242, (float)n);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)n);
    }

    public void destroy() {
        try {
            if (this.mImage != null) {
                this.mImage.destroy();
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"error clearing buffers: ", (Throwable)exception);
        }
    }

    protected int getTextureID() {
        return this.mTextureIDs[0];
    }

    protected boolean initialized() {
        return this.mImage != null && this.mTextureIDs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mTextureIDs != null) {
                TextureReaper.get().add(this.mTextureIDs);
            }
        }
        finally {
            super.finalize();
        }
    }
}

