/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.res.Resources;
import java.util.Calendar;
import java.util.Locale;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.CombinedHistoryPanel;

public class HistorySectionsHelper {
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_WEEK = 604800000L;

    public static void updateRecentSectionOffset(Resources resources, SectionDateRange[] sectionDateRangeArray) {
        long l = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 1);
        long l2 = calendar.getTimeInMillis();
        sectionDateRangeArray[CombinedHistoryPanel.SectionHeader.TODAY.ordinal()] = new SectionDateRange(l2, l, resources.getString(R.string.history_today_section));
        sectionDateRangeArray[CombinedHistoryPanel.SectionHeader.YESTERDAY.ordinal()] = new SectionDateRange(l2 - 86400000L, l2, resources.getString(R.string.history_yesterday_section));
        sectionDateRangeArray[CombinedHistoryPanel.SectionHeader.WEEK.ordinal()] = new SectionDateRange(l2 - 604800000L, l, resources.getString(R.string.history_week_section));
        calendar.add(2, 1);
        calendar.set(5, calendar.getMinimum(5));
        for (int i = CombinedHistoryPanel.SectionHeader.THIS_MONTH.ordinal(); i < CombinedHistoryPanel.SectionHeader.OLDER_THAN_SIX_MONTHS.ordinal(); ++i) {
            long l3 = calendar.getTimeInMillis();
            calendar.add(2, -1);
            long l4 = calendar.getTimeInMillis();
            String string2 = calendar.getDisplayName(2, 2, Locale.getDefault());
            sectionDateRangeArray[i] = new SectionDateRange(l4, l3, string2);
        }
        sectionDateRangeArray[CombinedHistoryPanel.SectionHeader.OLDER_THAN_SIX_MONTHS.ordinal()] = new SectionDateRange(0L, calendar.getTimeInMillis(), resources.getString(R.string.history_older_section));
    }

    public static class SectionDateRange {
        public final long start;
        public final long end;
        public final String displayName;

        private SectionDateRange(long l, long l2, String string2) {
            this.start = l;
            this.end = l2;
            this.displayName = string2;
        }
    }
}

