/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.database.Cursor;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ListAdapter;
import org.mozilla.gecko.util.StringUtils;

public class HomeContextMenuInfo
extends AdapterView.AdapterContextMenuInfo {
    public String url;
    public String title;
    public boolean isFolder;
    public int historyId = -1;
    public int bookmarkId = -1;
    public int readingListItemId = -1;
    public boolean isUnread;
    public RemoveItemType itemType = null;

    public HomeContextMenuInfo(View view, int n, long l) {
        super(view, n, l);
    }

    public boolean hasBookmarkId() {
        return this.bookmarkId > -1;
    }

    public boolean hasHistoryId() {
        return this.historyId > -1;
    }

    public boolean isInReadingList() {
        return this.readingListItemId > -1;
    }

    public boolean canRemove() {
        return this.hasBookmarkId() || this.hasHistoryId() || this.isInReadingList();
    }

    public String getDisplayTitle() {
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            return this.title;
        }
        return StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)this.url, (int)1));
    }

    public static interface ExpandableFactory {
        public HomeContextMenuInfo makeInfoForAdapter(View var1, int var2, long var3, ExpandableListAdapter var5);
    }

    public static interface ListFactory
    extends Factory {
        public HomeContextMenuInfo makeInfoForAdapter(View var1, int var2, long var3, ListAdapter var5);
    }

    public static interface Factory {
        public HomeContextMenuInfo makeInfoForCursor(View var1, int var2, long var3, Cursor var5);
    }

    public static enum RemoveItemType {
        BOOKMARKS,
        HISTORY,
        READING_LIST;

    }
}

