/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.EnumSet;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.ReadingListAccessor;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.ReadingListRow;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.reader.ReaderModeUtils;
import org.mozilla.gecko.util.NetworkUtils;

public class ReadingListPanel
extends HomeFragment {
    private static final int LOADER_ID_READING_LIST = 0;
    private final String MATCH_STRING = "%I";
    private ReadingListAdapter mAdapter;
    private HomeListView mList;
    private View mEmptyView;
    private View mTopView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_list_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mTopView = view;
        this.mList = (HomeListView)view.findViewById(R.id.list);
        this.mList.setTag("reading_list");
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                FragmentActivity fragmentActivity = ReadingListPanel.this.getActivity();
                if (fragmentActivity == null) {
                    return;
                }
                Cursor cursor = ReadingListPanel.this.mAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n)) {
                    return;
                }
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                string2 = ReaderModeUtils.getAboutReaderForUrl(string2);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "reading_list");
                Telemetry.addToHistogram("FENNEC_LOAD_SAVED_PAGE", NetworkUtils.isConnected((Context)fragmentActivity) ? 0 : 1);
                ReadingListPanel.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
                ReadingListPanel.this.markAsRead((Context)fragmentActivity, l);
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.Factory(){

            @Override
            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                homeContextMenuInfo.readingListItemId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                homeContextMenuInfo.isUnread = cursor.getInt(cursor.getColumnIndexOrThrow("is_unread")) == 1;
                homeContextMenuInfo.itemType = HomeContextMenuInfo.RemoveItemType.READING_LIST;
                return homeContextMenuInfo;
            }
        });
        this.registerForContextMenu((View)this.mList);
    }

    private void markAsRead(Context context, long l) {
        GeckoProfile.get(context).getDB().getReadingListAccessor().markAsRead(context.getContentResolver(), l);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList.setOnItemClickListener(null);
        this.mList = null;
        this.mTopView = null;
        this.mEmptyView = null;
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new ReadingListAdapter((Context)this.getActivity(), null);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    private void updateUiFromCursor(Cursor cursor) {
        if ((cursor == null || cursor.getCount() == 0) && this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.mTopView.findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView.setText(R.string.home_reading_list_empty);
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_reading_list_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new ReadingListLoader((Context)ReadingListPanel.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            ReadingListPanel.this.mAdapter.swapCursor(cursor);
            ReadingListPanel.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            ReadingListPanel.this.mAdapter.swapCursor(null);
        }
    }

    private class ReadingListAdapter
    extends CursorAdapter {
        public ReadingListAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            ReadingListRow readingListRow = (ReadingListRow)view;
            readingListRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.reading_list_item_row, viewGroup, false);
        }
    }

    private static class ReadingListLoader
    extends SimpleCursorLoader {
        private final ReadingListAccessor accessor;

        public ReadingListLoader(Context context) {
            super(context);
            this.accessor = GeckoProfile.get(context).getDB().getReadingListAccessor();
        }

        @Override
        public Cursor loadCursor() {
            return this.accessor.getReadingList(this.getContext().getContentResolver());
        }
    }
}

