/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.StringUtils;

public class ReadingListRow
extends LinearLayout {
    private TextView title;
    private TextView excerpt;
    private ImageView indicator;

    public ReadingListRow(Context context) {
        this(context, null);
    }

    public ReadingListRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.title = (TextView)this.findViewById(R.id.title);
        this.excerpt = (TextView)this.findViewById(R.id.excerpt);
        this.indicator = (ImageView)this.findViewById(R.id.indicator);
    }

    public void updateFromCursor(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        boolean bl = cursor.getInt(cursor.getColumnIndexOrThrow("is_unread")) == 1;
        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
        String string3 = cursor.getString(cursor.getColumnIndexOrThrow("title"));
        this.title.setText((CharSequence)(TextUtils.isEmpty((CharSequence)string3) ? StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)string2)) : string3));
        this.title.setTextAppearance(this.getContext(), bl ? R.style.Widget_ReadingListRow_Title_Unread : R.style.Widget_ReadingListRow_Title_Read);
        String string4 = cursor.getString(cursor.getColumnIndexOrThrow("excerpt"));
        this.excerpt.setText((CharSequence)(TextUtils.isEmpty((CharSequence)string4) ? string2 : string4));
        this.excerpt.setTextAppearance(this.getContext(), bl ? R.style.Widget_ReadingListRow_Title_Unread : R.style.Widget_ReadingListRow_Title_Read);
        this.indicator.setImageResource(bl ? R.drawable.reading_list_indicator_unread : R.drawable.reading_list_indicator_read);
    }
}

