/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.reader.ReaderModeUtils;
import org.mozilla.gecko.widget.FaviconView;

public class TwoLinePageRow
extends LinearLayout
implements Tabs.OnTabsChangedListener {
    protected static final int NO_ICON = 0;
    private final TextView mTitle;
    private final TextView mUrl;
    private final ImageView mStatusIcon;
    private int mSwitchToTabIconId;
    private final FaviconView mFavicon;
    private boolean mShowIcons;
    private int mLoadFaviconJobId = 0;
    private final OnFaviconLoadedListener mFaviconListener;
    private String mPageUrl;

    public TwoLinePageRow(Context context) {
        this(context, null);
    }

    public TwoLinePageRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setGravity(16);
        LayoutInflater.from((Context)context).inflate(R.layout.two_line_page_row, (ViewGroup)this);
        this.setPadding(0, 0, (int)this.getResources().getDimension(R.dimen.page_row_edge_padding), 0);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mUrl = (TextView)this.findViewById(R.id.url);
        this.mStatusIcon = (ImageView)this.findViewById(R.id.status_icon_bookmark);
        this.mSwitchToTabIconId = 0;
        this.mShowIcons = true;
        this.mFavicon = (FaviconView)this.findViewById(R.id.icon);
        this.mFaviconListener = new UpdateViewFaviconLoadedListener(this.mFavicon);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Tabs.registerOnTabsChangedListener(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Tabs.unregisterOnTabsChangedListener(this);
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        String string2 = this.mPageUrl;
        if (string2 == null) {
            return;
        }
        if (tab == null) {
            return;
        }
        String string3 = tab.getURL();
        if (!string2.equals(string3) && !string2.equals(object)) {
            return;
        }
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: 
            case LOCATION_CHANGE: {
                this.updateDisplayedUrl();
                break;
            }
        }
    }

    private void setTitle(String string2) {
        this.mTitle.setText((CharSequence)string2);
    }

    protected void setUrl(String string2) {
        this.mUrl.setText((CharSequence)string2);
    }

    protected void setUrl(int n) {
        this.mUrl.setText(n);
    }

    protected String getUrl() {
        return this.mPageUrl;
    }

    protected void setSwitchToTabIcon(int n) {
        if (this.mSwitchToTabIconId == n) {
            return;
        }
        this.mSwitchToTabIconId = n;
        this.mUrl.setCompoundDrawablesWithIntrinsicBounds(this.mSwitchToTabIconId, 0, 0, 0);
    }

    private void showBookmarkIcon(boolean bl) {
        int n = bl ? 0 : 8;
        this.mStatusIcon.setVisibility(n);
    }

    private void updateDisplayedUrl(String string2) {
        this.mPageUrl = string2;
        this.updateDisplayedUrl();
    }

    protected void updateDisplayedUrl() {
        boolean bl = Tabs.getInstance().getSelectedTab().isPrivate();
        Tab tab = Tabs.getInstance().getFirstTabForUrl(this.mPageUrl, bl);
        if (!this.mShowIcons || tab == null) {
            this.setUrl(this.mPageUrl);
            this.setSwitchToTabIcon(0);
        } else {
            this.setUrl(R.string.switch_to_tab);
            this.setSwitchToTabIcon(R.drawable.ic_url_bar_tab);
        }
    }

    public void setShowIcons(boolean bl) {
        this.mShowIcons = bl;
    }

    public void update(String string2, String string3) {
        this.update(string2, string3, 0L);
    }

    protected void update(String string2, String string3, long l) {
        if (this.mShowIcons) {
            boolean bl = l != 0L;
            this.showBookmarkIcon(bl);
        } else {
            this.showBookmarkIcon(false);
        }
        this.setTitle(TextUtils.isEmpty((CharSequence)string2) ? string3 : string2);
        if (string3.equals(this.mPageUrl)) {
            return;
        }
        this.mFavicon.clearImage();
        Favicons.cancelFaviconLoad(this.mLoadFaviconJobId);
        String string4 = AboutPages.isAboutReader(string3) ? ReaderModeUtils.getUrlFromAboutReader(string3) : string3;
        this.mLoadFaviconJobId = Favicons.getSizedFaviconForPageFromLocal(this.getContext(), string4, this.mFaviconListener);
        this.updateDisplayedUrl(string3);
    }

    public void updateFromCursor(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        int n = cursor.getColumnIndexOrThrow("title");
        String string2 = cursor.getString(n);
        int n2 = cursor.getColumnIndexOrThrow("url");
        String string3 = cursor.getString(n2);
        int n3 = cursor.getColumnIndex("bookmark_id");
        long l = n3 != -1 ? cursor.getLong(n3) : 0L;
        this.update(string2, string3, l);
    }

    private static class UpdateViewFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private final WeakReference<FaviconView> view;

        public UpdateViewFaviconLoadedListener(FaviconView faviconView) {
            this.view = new WeakReference<FaviconView>(faviconView);
        }

        @Override
        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            FaviconView faviconView = (FaviconView)((Object)this.view.get());
            if (faviconView == null) {
                return;
            }
            if (bitmap == null) {
                faviconView.showDefaultFavicon();
                return;
            }
            faviconView.updateImage(bitmap, string3);
        }
    }
}

