/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.push;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.annotation.ReflectionTarget;
import org.mozilla.gecko.gcm.GcmTokenClient;
import org.mozilla.gecko.push.PushClient;
import org.mozilla.gecko.push.PushManager;
import org.mozilla.gecko.push.PushRegistration;
import org.mozilla.gecko.push.PushState;
import org.mozilla.gecko.push.PushSubscription;
import org.mozilla.gecko.push.autopush.AutopushClientException;
import org.mozilla.gecko.util.BundleEventListener;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.ThreadUtils;

@ReflectionTarget
public class PushService
implements BundleEventListener {
    private static final String LOG_TAG = "GeckoPushService";
    public static final String SERVICE_WEBPUSH = "webpush";
    private static PushService sInstance;
    private static final String[] GECKO_EVENTS;
    protected final PushManager pushManager;

    public static synchronized PushService getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("PushService not yet created!");
        }
        return sInstance;
    }

    @ReflectionTarget
    public static synchronized void onCreate(Context context) {
        if (sInstance != null) {
            throw new IllegalStateException("PushService already created!");
        }
        sInstance = new PushService(context);
        sInstance.registerGeckoEventListener();
        sInstance.onStartup();
    }

    public PushService(Context context) {
        this.pushManager = new PushManager(new PushState(context, "GeckoPushState.json"), new GcmTokenClient(context), new PushManager.PushClientFactory(){

            @Override
            public PushClient getPushClient(String string2, boolean bl) {
                return new PushClient(string2);
            }
        });
    }

    public void onStartup() {
        Log.i((String)LOG_TAG, (String)"Starting up.");
        ThreadUtils.assertOnBackgroundThread();
        try {
            this.pushManager.startup(System.currentTimeMillis());
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Got exception during startup; ignoring.", (Throwable)exception);
            return;
        }
    }

    public void onRefresh() {
        Log.i((String)LOG_TAG, (String)"Google Play Services requested GCM token refresh; invalidating GCM token and running startup again.");
        ThreadUtils.assertOnBackgroundThread();
        this.pushManager.invalidateGcmToken();
        try {
            this.pushManager.startup(System.currentTimeMillis());
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Got exception during refresh; ignoring.", (Throwable)exception);
            return;
        }
    }

    public void onMessageReceived(@NonNull Bundle bundle) {
        Log.i((String)LOG_TAG, (String)"Google Play Services GCM message received; delivering.");
        ThreadUtils.assertOnBackgroundThread();
        String string2 = bundle.getString("chid");
        if (string2 == null) {
            Log.w((String)LOG_TAG, (String)"No chid found; ignoring message.");
            return;
        }
        PushRegistration pushRegistration = this.pushManager.registrationForSubscription(string2);
        if (pushRegistration == null) {
            Log.w((String)LOG_TAG, (String)("Cannot find registration corresponding to subscription for chid: " + string2 + "; ignoring message."));
            return;
        }
        PushSubscription pushSubscription = pushRegistration.getSubscription(string2);
        if (pushSubscription == null) {
            Log.e((String)LOG_TAG, (String)("No subscription found for chid: " + string2 + "; ignoring message."));
            return;
        }
        Log.i((String)LOG_TAG, (String)("Message directed to service: " + pushSubscription.service));
        if (SERVICE_WEBPUSH.equals(pushSubscription.service)) {
            if (pushSubscription.serviceData == null) {
                Log.e((String)LOG_TAG, (String)("No serviceData found for chid: " + string2 + "; ignoring dom/push message."));
                return;
            }
            String string3 = pushSubscription.serviceData.optString("profileName", null);
            String string4 = pushSubscription.serviceData.optString("profilePath", null);
            if (string3 == null || string4 == null) {
                Log.e((String)LOG_TAG, (String)("Corrupt serviceData found for chid: " + string2 + "; ignoring dom/push message."));
                return;
            }
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.SERVICE, "dom-push-api");
            if (!GeckoThread.isRunning()) {
                Log.w((String)LOG_TAG, (String)"dom/push message received but no Gecko thread is running; ignoring message.");
                return;
            }
            GeckoAppShell.GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
            if (geckoInterface == null) {
                Log.w((String)LOG_TAG, (String)"dom/push message received but no Gecko interface is registered; ignoring message.");
                return;
            }
            GeckoProfile geckoProfile = geckoInterface.getProfile();
            if (geckoProfile == null || !string3.equals(geckoProfile.getName()) || !string4.equals(geckoProfile.getDir().getAbsolutePath())) {
                Log.w((String)LOG_TAG, (String)"dom/push message received but Gecko is running with the wrong profile name or path; ignoring message.");
                return;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("channelID", (Object)string2);
                jSONObject.put("enc", (Object)bundle.getString("enc"));
                jSONObject.put("cryptokey", (Object)bundle.getString("cryptokey"));
                jSONObject.put("enckey", (Object)bundle.getString("enckey"));
                jSONObject.put("message", (Object)bundle.getString("body"));
            }
            catch (JSONException jSONException) {
                Log.e((String)LOG_TAG, (String)"Got exception delivering dom/push message to Gecko!", (Throwable)jSONException);
                return;
            }
            Log.i((String)LOG_TAG, (String)"Delivering dom/push message to Gecko!");
            GeckoAppShell.notifyObservers("PushServiceAndroidGCM:ReceivedPushMessage", jSONObject.toString());
        } else {
            Log.e((String)LOG_TAG, (String)("Message directed to unknown service; dropping: " + pushSubscription.service));
        }
    }

    protected void registerGeckoEventListener() {
        Log.d((String)LOG_TAG, (String)"Registered Gecko event listener.");
        EventDispatcher.getInstance().registerBackgroundThreadListener(this, GECKO_EVENTS);
    }

    protected void unregisterGeckoEventListener() {
        Log.d((String)LOG_TAG, (String)"Unregistered Gecko event listener.");
        EventDispatcher.getInstance().unregisterBackgroundThreadListener(this, GECKO_EVENTS);
    }

    public void handleMessage(String string2, Bundle bundle, EventCallback eventCallback) {
        Log.i((String)LOG_TAG, (String)("Handling event: " + string2));
        ThreadUtils.assertOnBackgroundThread();
        GeckoProfile geckoProfile = GeckoProfile.get(GeckoAppShell.getApplicationContext());
        if (eventCallback == null) {
            Log.e((String)LOG_TAG, (String)("callback must not be null in " + string2));
            return;
        }
        try {
            if ("PushServiceAndroidGCM:Configure".equals(string2)) {
                String string3 = bundle.getString("endpoint");
                if (string3 == null) {
                    eventCallback.sendError((Object)("endpoint must not be null in " + string2));
                    return;
                }
                boolean bl = bundle.getBoolean("debug", false);
                this.pushManager.configure(geckoProfile.getName(), string3, bl, System.currentTimeMillis());
                eventCallback.sendSuccess(null);
                return;
            }
            if ("PushServiceAndroidGCM:DumpRegistration".equals(string2)) {
                eventCallback.sendError((Object)"Not yet implemented!");
                return;
            }
            if ("PushServiceAndroidGCM:DumpSubscriptions".equals(string2)) {
                try {
                    Map<String, PushSubscription> map = this.pushManager.allSubscriptionsForProfile(geckoProfile.getName());
                    JSONObject jSONObject = new JSONObject();
                    for (Map.Entry<String, PushSubscription> entry : map.entrySet()) {
                        jSONObject.put(entry.getKey(), (Object)entry.getValue().toJSONObject());
                    }
                    eventCallback.sendSuccess((Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    eventCallback.sendError((Object)("Got exception handling message [" + string2 + "]: " + jSONException.toString()));
                }
                return;
            }
            if ("PushServiceAndroidGCM:RegisterUserAgent".equals(string2)) {
                try {
                    this.pushManager.registerUserAgent(geckoProfile.getName(), System.currentTimeMillis());
                    eventCallback.sendSuccess(null);
                }
                catch (IOException | PushClient.LocalException | PushManager.ProfileNeedsConfigurationException | AutopushClientException throwable) {
                    Log.e((String)LOG_TAG, (String)("Got exception in " + string2), (Throwable)throwable);
                    eventCallback.sendError((Object)("Got exception handling message [" + string2 + "]: " + throwable.toString()));
                }
                return;
            }
            if ("PushServiceAndroidGCM:UnregisterUserAgent".equals(string2)) {
                eventCallback.sendError((Object)"Not yet implemented!");
                return;
            }
            if ("PushServiceAndroidGCM:SubscribeChannel".equals(string2)) {
                PushSubscription pushSubscription;
                JSONObject jSONObject;
                try {
                    jSONObject = new JSONObject();
                    jSONObject.put("profileName", (Object)geckoProfile.getName());
                    jSONObject.put("profilePath", (Object)geckoProfile.getDir().getAbsolutePath());
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOG_TAG, (String)("Got exception in " + string2), (Throwable)jSONException);
                    eventCallback.sendError((Object)("Got exception handling message [" + string2 + "]: " + jSONException.toString()));
                    return;
                }
                try {
                    pushSubscription = this.pushManager.subscribeChannel(geckoProfile.getName(), SERVICE_WEBPUSH, jSONObject, System.currentTimeMillis());
                }
                catch (IOException | PushClient.LocalException | PushManager.ProfileNeedsConfigurationException | AutopushClientException throwable) {
                    Log.e((String)LOG_TAG, (String)("Got exception in " + string2), (Throwable)throwable);
                    eventCallback.sendError((Object)("Got exception handling message [" + string2 + "]: " + throwable.toString()));
                    return;
                }
                JSONObject jSONObject2 = new JSONObject();
                try {
                    jSONObject2.put("channelID", (Object)pushSubscription.chid);
                    jSONObject2.put("endpoint", (Object)pushSubscription.webpushEndpoint);
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOG_TAG, (String)("Got exception in " + string2), (Throwable)jSONException);
                    eventCallback.sendError((Object)("Got exception handling message [" + string2 + "]: " + jSONException.toString()));
                    return;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.SERVICE, "dom-push-api");
                eventCallback.sendSuccess((Object)jSONObject2);
                return;
            }
            if ("PushServiceAndroidGCM:UnsubscribeChannel".equals(string2)) {
                String string4 = bundle.getString("channelID");
                if (string4 == null) {
                    eventCallback.sendError((Object)("channelID must not be null in " + string2));
                    return;
                }
                PushSubscription pushSubscription = this.pushManager.unsubscribeChannel(string4);
                if (pushSubscription != null) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.SERVICE, "dom-push-api");
                    eventCallback.sendSuccess(null);
                    return;
                }
                eventCallback.sendError((Object)("Could not unsubscribe from channel: " + string4));
                return;
            }
        }
        catch (GcmTokenClient.NeedsGooglePlayServicesException needsGooglePlayServicesException) {
            eventCallback.sendError((Object)("To handle event [" + string2 + "], user interaction is needed to enable Google Play Services."));
        }
    }

    static {
        GECKO_EVENTS = new String[]{"PushServiceAndroidGCM:Configure", "PushServiceAndroidGCM:DumpRegistration", "PushServiceAndroidGCM:DumpSubscriptions", "PushServiceAndroidGCM:RegisterUserAgent", "PushServiceAndroidGCM:UnregisterUserAgent", "PushServiceAndroidGCM:SubscribeChannel", "PushServiceAndroidGCM:UnsubscribeChannel"};
    }
}

