/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabqueue;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.tabqueue.TabQueueHelper;

public class TabQueuePrompt
extends Locales.LocaleAwareActivity {
    public static final String LOGTAG = "Gecko" + TabQueuePrompt.class.getSimpleName();
    private static final int SETTINGS_REQUEST_CODE = 1;
    private boolean isAnimating;
    private View containerView;
    private View buttonContainer;
    private View enabledConfirmation;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.showTabQueueEnablePrompt();
    }

    private void showTabQueueEnablePrompt() {
        this.setContentView(R.layout.tab_queue_prompt);
        final int n = GeckoSharedPrefs.forApp((Context)this).getInt("tab_queue_times_prompt_shown", 0);
        View view = this.findViewById(R.id.ok_button);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabQueuePrompt.this.onConfirmButtonPressed();
                Telemetry.addToHistogram("FENNEC_TABQUEUE_PROMPT_ENABLE_YES", n);
            }
        });
        this.findViewById(R.id.cancel_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Telemetry.addToHistogram("FENNEC_TABQUEUE_PROMPT_ENABLE_NO", n);
                TabQueuePrompt.this.setResult(202);
                TabQueuePrompt.this.finish();
            }
        });
        View view2 = this.findViewById(R.id.settings_button);
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabQueuePrompt.this.onSettingsButtonPressed();
            }
        });
        View view3 = this.findViewById(R.id.tip_text);
        View view4 = this.findViewById(R.id.settings_permit_text);
        if (TabQueueHelper.canDrawOverlays((Context)this)) {
            view.setVisibility(0);
            view2.setVisibility(8);
            view3.setVisibility(0);
            view4.setVisibility(8);
        } else {
            view.setVisibility(8);
            view2.setVisibility(0);
            view3.setVisibility(8);
            view4.setVisibility(0);
        }
        this.containerView = this.findViewById(R.id.tab_queue_container);
        this.buttonContainer = this.findViewById(R.id.button_container);
        this.enabledConfirmation = this.findViewById(R.id.enabled_confirmation);
        this.containerView.setTranslationY(500.0f);
        this.containerView.setAlpha(0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.containerView, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        animatorSet.start();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private void onConfirmButtonPressed() {
        this.enabledConfirmation.setVisibility(0);
        this.enabledConfirmation.setAlpha(0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.buttonContainer, (String)"alpha", (float[])new float[]{0.0f});
        objectAnimator.setDuration(300L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.enabledConfirmation, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setDuration(300L);
        objectAnimator2.setStartDelay(200L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, objectAnimator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TabQueuePrompt.this.slideOut();
                        TabQueuePrompt.this.setResult(201);
                    }
                }, 1000L);
            }
        });
        animatorSet.start();
    }

    @TargetApi(value=23)
    private void onSettingsButtonPressed() {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivityForResult(intent, 1);
        Toast.makeText((Context)this, (int)R.string.tab_queue_prompt_permit_drawing_over_apps, (int)1).show();
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (n != 1) {
            return;
        }
        if (TabQueueHelper.canDrawOverlays((Context)this)) {
            int n3 = GeckoSharedPrefs.forApp((Context)this).getInt("tab_queue_times_prompt_shown", 0);
            Telemetry.addToHistogram("FENNEC_TABQUEUE_PROMPT_ENABLE_YES", n3);
            this.setResult(201);
            this.finish();
        }
    }

    private void slideOut() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getHeight()});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                TabQueuePrompt.this.finish();
            }
        });
        objectAnimator.start();
    }

    public void onBackPressed() {
        this.slideOut();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.slideOut();
        return true;
    }
}

