/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.content.ContentResolver;
import android.content.SyncStatusObserver;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.gecko.fxa.SyncStatusListener;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.util.ThreadUtils;

public class FxAccountSyncStatusHelper
implements SyncStatusObserver {
    private static final String LOG_TAG = FxAccountSyncStatusHelper.class.getSimpleName();
    protected static FxAccountSyncStatusHelper sInstance;
    protected Object handle;
    protected Map<SyncStatusListener, Boolean> delegates = new WeakHashMap<SyncStatusListener, Boolean>();

    public static synchronized FxAccountSyncStatusHelper getInstance() {
        if (sInstance == null) {
            sInstance = new FxAccountSyncStatusHelper();
        }
        return sInstance;
    }

    public synchronized void onStatusChanged(int n) {
        for (Map.Entry<SyncStatusListener, Boolean> entry : this.delegates.entrySet()) {
            final SyncStatusListener syncStatusListener = entry.getKey();
            AndroidFxAccount androidFxAccount = new AndroidFxAccount(syncStatusListener.getContext(), syncStatusListener.getAccount());
            boolean bl = androidFxAccount.isCurrentlySyncing();
            boolean bl2 = entry.getValue();
            entry.setValue(bl);
            if (bl && !bl2) {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        syncStatusListener.onSyncStarted();
                    }
                });
            }
            if (bl || !bl2) continue;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    syncStatusListener.onSyncFinished();
                }
            });
        }
    }

    protected void addListener() {
        if (this.handle != null) {
            throw new IllegalStateException("Already registered this as an observer?");
        }
        this.handle = ContentResolver.addStatusChangeListener((int)4, (SyncStatusObserver)this);
    }

    protected void removeListener() {
        Object object = this.handle;
        this.handle = null;
        if (object != null) {
            ContentResolver.removeStatusChangeListener((Object)object);
        }
    }

    public synchronized void startObserving(SyncStatusListener syncStatusListener) {
        if (syncStatusListener == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        if (this.delegates.containsKey(syncStatusListener)) {
            return;
        }
        if (this.delegates.isEmpty()) {
            this.addListener();
        }
        this.delegates.put(syncStatusListener, Boolean.FALSE);
    }

    public synchronized void stopObserving(SyncStatusListener syncStatusListener) {
        this.delegates.remove(syncStatusListener);
        if (this.delegates.isEmpty()) {
            this.removeListener();
        }
    }
}

