/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import org.mozilla.gecko.background.common.log.Logger;

public class DelayedWorkTracker {
    private static final String LOG_TAG = "DelayedWorkTracker";
    protected Runnable workItem = null;
    protected int outstandingCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementOutstanding() {
        Logger.trace(LOG_TAG, "Incrementing outstanding.");
        DelayedWorkTracker delayedWorkTracker = this;
        synchronized (delayedWorkTracker) {
            return ++this.outstandingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrementOutstanding() {
        Logger.trace(LOG_TAG, "Decrementing outstanding.");
        Runnable runnable = null;
        DelayedWorkTracker delayedWorkTracker = this;
        synchronized (delayedWorkTracker) {
            int n = --this.outstandingCount;
            if (this.outstandingCount != 0 || this.workItem == null) {
                return n;
            }
            runnable = this.workItem;
            this.workItem = null;
        }
        runnable.run();
        return this.getOutstandingOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstandingOperations() {
        DelayedWorkTracker delayedWorkTracker = this;
        synchronized (delayedWorkTracker) {
            return this.outstandingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayWorkItem(Runnable runnable) {
        Logger.trace(LOG_TAG, "delayWorkItem.");
        boolean bl = false;
        DelayedWorkTracker delayedWorkTracker = this;
        synchronized (delayedWorkTracker) {
            Logger.trace(LOG_TAG, "outstandingCount: " + this.outstandingCount);
            if (this.outstandingCount == 0) {
                bl = true;
            } else {
                if (this.workItem != null) {
                    throw new IllegalStateException("Work item already set!");
                }
                this.workItem = runnable;
            }
        }
        if (bl) {
            Logger.trace(LOG_TAG, "Running item now.");
            runnable.run();
        }
    }
}

