/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.preference.Preference;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import org.mozilla.gecko.AppConstants;

public class PicassoPreferenceIconTarget
implements Target {
    private final Preference preference;
    private final Resources resources;
    private final float cornerRadius;

    public PicassoPreferenceIconTarget(Resources resources, Preference preference) {
        this(resources, preference, 0.0f);
    }

    public PicassoPreferenceIconTarget(Resources resources, Preference preference, float f) {
        this.resources = resources;
        this.preference = preference;
        this.cornerRadius = f;
    }

    public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom loadedFrom) {
        BitmapDrawable bitmapDrawable;
        if (!AppConstants.Versions.feature11Plus) {
            return;
        }
        if (this.cornerRadius > 0.0f) {
            RoundedBitmapDrawable roundedBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)this.resources, (Bitmap)bitmap);
            roundedBitmapDrawable.setCornerRadius(this.cornerRadius);
            roundedBitmapDrawable.setAntiAlias(true);
            bitmapDrawable = roundedBitmapDrawable;
        } else {
            bitmapDrawable = new BitmapDrawable(this.resources, bitmap);
        }
        this.preference.setIcon((Drawable)bitmapDrawable);
    }

    public void onBitmapFailed(Drawable drawable2) {
        if (!AppConstants.Versions.feature11Plus) {
            return;
        }
        this.preference.setIcon(drawable2);
    }

    public void onPrepareLoad(Drawable drawable2) {
        if (!AppConstants.Versions.feature11Plus) {
            return;
        }
        this.preference.setIcon(drawable2);
    }
}

