/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;

public class NotificationHandler {
    private static String LOGTAG = "GeckoNotifHandler";
    private final ConcurrentHashMap<Integer, Notification> mNotifications = new ConcurrentHashMap();
    private final Context mContext;
    private final NotificationManagerCompat mNotificationManager;
    private Notification mForegroundNotification;
    private int mForegroundNotificationId;

    public NotificationHandler(Context context) {
        this.mContext = context;
        this.mNotificationManager = NotificationManagerCompat.from((Context)context);
    }

    public void add(int n, String string, String string2, String string3, String string4, PendingIntent pendingIntent) {
        Bitmap bitmap;
        this.remove(n);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext).setContentTitle((CharSequence)string3).setContentText((CharSequence)string4).setSmallIcon(R.drawable.ic_status_logo).setContentIntent(pendingIntent).setAutoCancel(true).setStyle((NotificationCompat.Style)new NotificationCompat.InboxStyle().addLine((CharSequence)string4).setSummaryText((CharSequence)string2));
        if (!string.isEmpty()) {
            bitmap = BitmapUtils.decodeUrl(string);
            builder.setLargeIcon(bitmap);
        }
        builder.setWhen(System.currentTimeMillis());
        bitmap = builder.build();
        this.mNotificationManager.notify(n, (Notification)bitmap);
        this.mNotifications.put(n, (Notification)bitmap);
    }

    public void add(int n, Notification notification) {
        this.mNotificationManager.notify(n, notification);
        this.mNotifications.put(n, notification);
        if (this.mForegroundNotification == null && this.isOngoing(notification)) {
            this.setForegroundNotification(n, notification);
        }
    }

    public void update(int n, long l, long l2, String string) {
        Notification notification = this.mNotifications.get(n);
        if (notification == null) {
            return;
        }
        notification = new NotificationCompat.Builder(this.mContext).setContentText((CharSequence)string).setSmallIcon(notification.icon).setWhen(notification.when).setContentIntent(notification.contentIntent).setProgress((int)l2, (int)l, false).build();
        this.add(n, notification);
    }

    public void remove(int n) {
        Notification notification = this.mNotifications.remove(n);
        if (notification != null) {
            this.updateForegroundNotification(n, notification);
        }
        this.mNotificationManager.cancel(n);
    }

    public boolean isDone() {
        return this.mNotifications.isEmpty();
    }

    public boolean isOngoing(int n) {
        Notification notification = this.mNotifications.get(n);
        return this.isOngoing(notification);
    }

    public boolean isOngoing(Notification notification) {
        return notification != null && (notification.flags & 2) > 0;
    }

    protected void setForegroundNotification(int n, Notification notification) {
        this.mForegroundNotificationId = n;
        this.mForegroundNotification = notification;
    }

    private void updateForegroundNotification(int n, Notification notification) {
        if (this.mForegroundNotificationId == n) {
            Notification notification2 = null;
            int n2 = 0;
            for (Integer n3 : this.mNotifications.keySet()) {
                Notification notification3 = this.mNotifications.get(n3);
                if (!this.isOngoing(notification3)) continue;
                notification2 = notification3;
                n2 = n3;
                break;
            }
            this.setForegroundNotification(n2, notification2);
        }
    }
}

