/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import org.json.JSONException;
import org.json.JSONObject;

public final class ZoomConstraints {
    private final boolean mAllowZoom;
    private final boolean mAllowDoubleTapZoom;
    private final float mMinZoom;
    private final float mMaxZoom;

    public ZoomConstraints(boolean bl) {
        this.mAllowZoom = bl;
        this.mAllowDoubleTapZoom = bl;
        this.mMinZoom = 0.0f;
        this.mMaxZoom = 0.0f;
    }

    ZoomConstraints(JSONObject jSONObject) throws JSONException {
        this.mAllowZoom = jSONObject.getBoolean("allowZoom");
        this.mAllowDoubleTapZoom = jSONObject.getBoolean("allowDoubleTapZoom");
        this.mMinZoom = (float)jSONObject.getDouble("minZoom");
        this.mMaxZoom = (float)jSONObject.getDouble("maxZoom");
    }

    public final boolean getAllowZoom() {
        return this.mAllowZoom;
    }

    public final boolean getAllowDoubleTapZoom() {
        return this.mAllowDoubleTapZoom;
    }

    public final float getMinZoom() {
        return this.mMinZoom;
    }

    public final float getMaxZoom() {
        return this.mMaxZoom;
    }
}

