/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.animation;

import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

class AnimatorProxy {
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private final AnimatorProxyImpl mImpl;

    private AnimatorProxy(AnimatorProxyImpl animatorProxyImpl) {
        this.mImpl = animatorProxyImpl;
    }

    public static AnimatorProxy create(View view) {
        AnimatorProxy animatorProxy = PROXIES.get(view);
        if (animatorProxy == null) {
            AnimatorProxyPostHC animatorProxyPostHC = new AnimatorProxyPostHC(view);
            animatorProxy = new AnimatorProxy(animatorProxyPostHC);
            PROXIES.put(view, animatorProxy);
        }
        return animatorProxy;
    }

    public int getWidth() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getWidth();
        }
        return 0;
    }

    public void setWidth(int n) {
        View view = this.mImpl.getView();
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            layoutParams.width = n;
            view.setLayoutParams(layoutParams);
        }
    }

    public int getHeight() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getHeight();
        }
        return 0;
    }

    public void setHeight(int n) {
        View view = this.mImpl.getView();
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            layoutParams.height = n;
            view.setLayoutParams(layoutParams);
        }
    }

    public int getScrollX() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getScrollX();
        }
        return 0;
    }

    public int getScrollY() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getScrollY();
        }
        return 0;
    }

    public void scrollTo(int n, int n2) {
        View view = this.mImpl.getView();
        if (view != null) {
            view.scrollTo(n, n2);
        }
    }

    public float getAlpha() {
        return this.mImpl.getAlpha();
    }

    public void setAlpha(float f) {
        this.mImpl.setAlpha(f);
    }

    public float getTranslationX() {
        return this.mImpl.getTranslationX();
    }

    public void setTranslationX(float f) {
        this.mImpl.setTranslationX(f);
    }

    public float getTranslationY() {
        return this.mImpl.getTranslationY();
    }

    public void setTranslationY(float f) {
        this.mImpl.setTranslationY(f);
    }

    private static class AnimatorProxyPostHC
    implements AnimatorProxyImpl {
        private final WeakReference<View> mViewRef;

        public AnimatorProxyPostHC(View view) {
            this.mViewRef = new WeakReference<View>(view);
        }

        @Override
        public float getAlpha() {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                return view.getAlpha();
            }
            return 1.0f;
        }

        @Override
        public void setAlpha(float f) {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                view.setAlpha(f);
            }
        }

        @Override
        public float getTranslationX() {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                return view.getTranslationX();
            }
            return 0.0f;
        }

        @Override
        public void setTranslationX(float f) {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                view.setTranslationX(f);
            }
        }

        @Override
        public float getTranslationY() {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                return view.getTranslationY();
            }
            return 0.0f;
        }

        @Override
        public void setTranslationY(float f) {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                view.setTranslationY(f);
            }
        }

        @Override
        public View getView() {
            return (View)this.mViewRef.get();
        }
    }

    private static interface AnimatorProxyImpl {
        public float getAlpha();

        public void setAlpha(float var1);

        public float getTranslationX();

        public void setTranslationX(float var1);

        public float getTranslationY();

        public void setTranslationY(float var1);

        public View getView();
    }
}

