/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.MatrixCursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.SharedBrowserDatabaseProvider;
import org.mozilla.gecko.db.SuggestedSites;
import org.mozilla.gecko.db.Table;
import org.mozilla.gecko.db.URLMetadataTable;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.sync.Utils;

public class BrowserProvider
extends SharedBrowserDatabaseProvider {
    private static final String LOGTAG = "GeckoBrowserProvider";
    static final int MAX_POSITION_UPDATES_PER_QUERY = 100;
    static final int DEFAULT_EXPIRY_RETAIN_COUNT = 2000;
    static final int AGGRESSIVE_EXPIRY_RETAIN_COUNT = 500;
    static final long DEFAULT_EXPIRY_PRESERVE_WINDOW = 2419200000L;
    static final int DEFAULT_EXPIRY_THUMBNAIL_COUNT = 15;
    static final String TABLE_BOOKMARKS = "bookmarks";
    static final String TABLE_HISTORY = "history";
    static final String TABLE_FAVICONS = "favicons";
    static final String TABLE_THUMBNAILS = "thumbnails";
    static final String TABLE_TABS = "tabs";
    static final String TABLE_URL_ANNOTATIONS = "urlannotations";
    static final String VIEW_COMBINED = "combined";
    static final String VIEW_BOOKMARKS_WITH_FAVICONS = "bookmarks_with_favicons";
    static final String VIEW_BOOKMARKS_WITH_ANNOTATIONS = "bookmarks_with_annotations";
    static final String VIEW_HISTORY_WITH_FAVICONS = "history_with_favicons";
    static final String VIEW_COMBINED_WITH_FAVICONS = "combined_with_favicons";
    static final int BOOKMARKS = 100;
    static final int BOOKMARKS_ID = 101;
    static final int BOOKMARKS_FOLDER_ID = 102;
    static final int BOOKMARKS_PARENT = 103;
    static final int BOOKMARKS_POSITIONS = 104;
    static final int HISTORY = 200;
    static final int HISTORY_ID = 201;
    static final int HISTORY_OLD = 202;
    static final int FAVICONS = 300;
    static final int FAVICON_ID = 301;
    static final int SCHEMA = 400;
    static final int COMBINED = 500;
    static final int CONTROL = 600;
    static final int SEARCH_SUGGEST = 700;
    static final int THUMBNAILS = 800;
    static final int THUMBNAIL_ID = 801;
    static final int URL_ANNOTATIONS = 900;
    static final int TOPSITES = 1000;
    static final String DEFAULT_BOOKMARKS_SORT_ORDER = "type ASC, position ASC, _id ASC";
    static final String DEFAULT_HISTORY_SORT_ORDER = "date DESC";
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    static final Map<String, String> BOOKMARKS_PROJECTION_MAP;
    static final Map<String, String> HISTORY_PROJECTION_MAP;
    static final Map<String, String> COMBINED_PROJECTION_MAP;
    static final Map<String, String> SCHEMA_PROJECTION_MAP;
    static final Map<String, String> FAVICONS_PROJECTION_MAP;
    static final Map<String, String> THUMBNAILS_PROJECTION_MAP;
    static final Map<String, String> URL_ANNOTATIONS_PROJECTION_MAP;
    static final Table[] sTables;
    private static final boolean logDebug;
    private static final boolean logVerbose;

    private URLMetadataTable getURLMetadataTable() {
        return (URLMetadataTable)sTables[0];
    }

    private static boolean hasFaviconsInProjection(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("favicon") && !stringArray[i].equals("favicon_url")) continue;
            return true;
        }
        return false;
    }

    protected static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    private void expireHistory(SQLiteDatabase sQLiteDatabase, int n, long l) {
        Log.d((String)LOGTAG, (String)"Expiring history.");
        long l2 = DatabaseUtils.queryNumEntries((SQLiteDatabase)sQLiteDatabase, (String)TABLE_HISTORY);
        if ((long)n >= l2) {
            BrowserProvider.debug("Not expiring history: only have " + l2 + " rows.");
            return;
        }
        String string2 = BrowserContract.getFrecencySortOrder((boolean)false, (boolean)true);
        long l3 = l2 - (long)n;
        BrowserProvider.debug("Expiring at most " + l3 + " rows earlier than " + l + ".");
        String string3 = l > 0L ? "DELETE FROM history WHERE MAX(date, modified) < " + l + " " + " AND " + "_id" + " IN ( SELECT " + "_id" + " FROM " + TABLE_HISTORY + " " + "ORDER BY " + string2 + " LIMIT " + l3 + ")" : "DELETE FROM history WHERE _id IN ( SELECT _id FROM history ORDER BY " + string2 + " LIMIT " + l3 + ")";
        BrowserProvider.trace("Deleting using query: " + string3);
        this.beginWrite(sQLiteDatabase);
        sQLiteDatabase.execSQL(string3);
    }

    private void expireThumbnails(SQLiteDatabase sQLiteDatabase) {
        Log.d((String)LOGTAG, (String)"Expiring thumbnails.");
        String string2 = BrowserContract.getFrecencySortOrder((boolean)true, (boolean)false);
        String string3 = "DELETE FROM thumbnails WHERE url NOT IN (  SELECT url FROM combined ORDER BY " + string2 + " LIMIT " + 15 + ") AND " + "url" + " NOT IN ( " + " SELECT " + "url" + " FROM " + TABLE_BOOKMARKS + " WHERE " + "parent" + " = " + -3 + ") AND " + "url" + " NOT IN ( " + " SELECT " + "url" + " FROM " + TABLE_TABS + ")";
        BrowserProvider.trace("Clear thumbs using query: " + string3);
        sQLiteDatabase.execSQL(string3);
    }

    private boolean shouldIncrementVisits(Uri uri) {
        String string2 = uri.getQueryParameter("increment_visits");
        return Boolean.parseBoolean(string2);
    }

    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        BrowserProvider.trace("Getting URI type: " + uri);
        switch (n) {
            case 100: {
                BrowserProvider.trace("URI is BOOKMARKS: " + uri);
                return "vnd.android.cursor.dir/bookmark";
            }
            case 101: {
                BrowserProvider.trace("URI is BOOKMARKS_ID: " + uri);
                return "vnd.android.cursor.item/bookmark";
            }
            case 200: {
                BrowserProvider.trace("URI is HISTORY: " + uri);
                return "vnd.android.cursor.dir/browser-history";
            }
            case 201: {
                BrowserProvider.trace("URI is HISTORY_ID: " + uri);
                return "vnd.android.cursor.item/browser-history";
            }
        }
        String string2 = BrowserProvider.getContentItemType(n);
        if (string2 != null) {
            BrowserProvider.trace("URI is " + string2);
            return string2;
        }
        BrowserProvider.debug("URI has unrecognized type: " + uri);
        return null;
    }

    @Override
    public int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.trace("Calling delete in transaction on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        switch (n) {
            case 101: {
                BrowserProvider.trace("Delete on BOOKMARKS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "bookmarks._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 100: {
                BrowserProvider.trace("Deleting bookmarks: " + uri);
                n2 = this.deleteBookmarks(uri, string2, stringArray);
                this.deleteUnusedImages(uri);
                break;
            }
            case 201: {
                BrowserProvider.trace("Delete on HISTORY_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "history._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 200: {
                BrowserProvider.trace("Deleting history: " + uri);
                this.beginWrite(sQLiteDatabase);
                n2 = this.deleteHistory(uri, string2, stringArray);
                this.deleteUnusedImages(uri);
                break;
            }
            case 202: {
                String string3 = uri.getQueryParameter("priority");
                long l = System.currentTimeMillis() - 2419200000L;
                int n3 = 2000;
                if (BrowserContract.ExpirePriority.AGGRESSIVE.toString().equals(string3)) {
                    l = 0L;
                    n3 = 500;
                }
                this.expireHistory(sQLiteDatabase, n3, l);
                this.expireThumbnails(sQLiteDatabase);
                this.deleteUnusedImages(uri);
                break;
            }
            case 301: {
                BrowserProvider.debug("Delete on FAVICON_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "favicons._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 300: {
                BrowserProvider.trace("Deleting favicons: " + uri);
                this.beginWrite(sQLiteDatabase);
                n2 = this.deleteFavicons(uri, string2, stringArray);
                break;
            }
            case 801: {
                BrowserProvider.debug("Delete on THUMBNAIL_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "thumbnails._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 800: {
                BrowserProvider.trace("Deleting thumbnails: " + uri);
                this.beginWrite(sQLiteDatabase);
                n2 = this.deleteThumbnails(uri, string2, stringArray);
                break;
            }
            case 900: {
                BrowserProvider.trace("Delete on URL_ANNOTATIONS: " + uri);
                this.deleteUrlAnnotation(uri, string2, stringArray);
                break;
            }
            default: {
                Table table = BrowserProvider.findTableFor(n);
                if (table == null) {
                    throw new UnsupportedOperationException("Unknown delete URI " + uri);
                }
                BrowserProvider.trace("Deleting TABLE: " + uri);
                this.beginWrite(sQLiteDatabase);
                n2 = table.delete(sQLiteDatabase, uri, n, string2, stringArray);
            }
        }
        BrowserProvider.debug("Deleted " + n2 + " rows for URI: " + uri);
        return n2;
    }

    @Override
    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        BrowserProvider.trace("Calling insert in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        long l = -1L;
        switch (n) {
            case 100: {
                BrowserProvider.trace("Insert on BOOKMARKS: " + uri);
                l = this.insertBookmark(uri, contentValues);
                break;
            }
            case 200: {
                BrowserProvider.trace("Insert on HISTORY: " + uri);
                l = this.insertHistory(uri, contentValues);
                break;
            }
            case 300: {
                BrowserProvider.trace("Insert on FAVICONS: " + uri);
                l = this.insertFavicon(uri, contentValues);
                break;
            }
            case 800: {
                BrowserProvider.trace("Insert on THUMBNAILS: " + uri);
                l = this.insertThumbnail(uri, contentValues);
                break;
            }
            case 900: {
                BrowserProvider.trace("Insert on URL_ANNOTATIONS: " + uri);
                l = this.insertUrlAnnotation(uri, contentValues);
                break;
            }
            default: {
                Table table = BrowserProvider.findTableFor(n);
                if (table == null) {
                    throw new UnsupportedOperationException("Unknown insert URI " + uri);
                }
                BrowserProvider.trace("Insert on TABLE: " + uri);
                SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
                this.beginWrite(sQLiteDatabase);
                l = table.insert(sQLiteDatabase, uri, n, contentValues);
            }
        }
        BrowserProvider.debug("Inserted ID in database: " + l);
        if (l >= 0L) {
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        return null;
    }

    @Override
    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Calling update in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        switch (n) {
            case 104: {
                BrowserProvider.debug("Update on BOOKMARKS_POSITIONS: " + uri);
                n2 = this.updateBookmarkPositions(uri, stringArray);
                break;
            }
            case 103: {
                BrowserProvider.debug("Update on BOOKMARKS_PARENT: " + uri);
                this.beginWrite(sQLiteDatabase);
                n2 = this.updateBookmarkParents(sQLiteDatabase, contentValues, string2, stringArray);
                break;
            }
            case 101: {
                BrowserProvider.debug("Update on BOOKMARKS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "bookmarks._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 100: {
                BrowserProvider.debug("Updating bookmark: " + uri);
                if (BrowserProvider.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertBookmark(uri, contentValues, string2, stringArray);
                    break;
                }
                n2 = this.updateBookmarks(uri, contentValues, string2, stringArray);
                break;
            }
            case 201: {
                BrowserProvider.debug("Update on HISTORY_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "history._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 200: {
                BrowserProvider.debug("Updating history: " + uri);
                if (BrowserProvider.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertHistory(uri, contentValues, string2, stringArray);
                    break;
                }
                n2 = this.updateHistory(uri, contentValues, string2, stringArray);
                break;
            }
            case 300: {
                BrowserProvider.debug("Update on FAVICONS: " + uri);
                String string3 = contentValues.getAsString("url");
                String string4 = null;
                String[] stringArray2 = null;
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    string4 = "url = ?";
                    stringArray2 = new String[]{string3};
                }
                if (BrowserProvider.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertFavicon(uri, contentValues, string4, stringArray2);
                    break;
                }
                n2 = this.updateExistingFavicon(uri, contentValues, string4, stringArray2);
                break;
            }
            case 800: {
                BrowserProvider.debug("Update on THUMBNAILS: " + uri);
                String string5 = contentValues.getAsString("url");
                if (TextUtils.isEmpty((CharSequence)contentValues.getAsString("url"))) {
                    n2 = this.updateExistingThumbnail(uri, contentValues, null, null);
                    break;
                }
                if (BrowserProvider.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertThumbnail(uri, contentValues, "url = ?", new String[]{string5});
                    break;
                }
                n2 = this.updateExistingThumbnail(uri, contentValues, "url = ?", new String[]{string5});
                break;
            }
            case 900: {
                this.updateUrlAnnotation(uri, contentValues, string2, stringArray);
                break;
            }
            default: {
                Table table = BrowserProvider.findTableFor(n);
                if (table == null) {
                    throw new UnsupportedOperationException("Unknown update URI " + uri);
                }
                BrowserProvider.trace("Update TABLE: " + uri);
                this.beginWrite(sQLiteDatabase);
                n2 = table.update(sQLiteDatabase, uri, n, contentValues, string2, stringArray);
                if (!BrowserProvider.shouldUpdateOrInsert(uri) || n2 != 0) break;
                BrowserProvider.trace("No update, inserting for URL: " + uri);
                table.insert(sQLiteDatabase, uri, n, contentValues);
                n2 = 1;
            }
        }
        BrowserProvider.debug("Updated " + n2 + " rows for URI: " + uri);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor getTopSites(Uri uri) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        String string2 = uri.getQueryParameter("limit");
        String string3 = uri.getQueryParameter("suggestedsites_limit");
        int n = string2 == null ? 50 : Integer.parseInt(string2, 10);
        int n2 = string3 == null ? this.getContext().getResources().getInteger(R.integer.number_of_top_sites) : Integer.parseInt(string3, 10);
        String string4 = " SELECT count(free_ids.position) + 1 AS rowid, numbers.position AS position FROM (SELECT position FROM numbers WHERE position NOT IN (SELECT position FROM bookmarks WHERE parent == -3 AND deleted IS NOT 1)) AS numbers LEFT OUTER JOIN  (SELECT position FROM numbers WHERE position NOT IN (SELECT position FROM bookmarks WHERE parent == -3 AND deleted IS NOT 1)) AS free_ids ON numbers.position > free_ids.position GROUP BY numbers.position ORDER BY numbers.position ASC LIMIT " + n2;
        String string5 = "(history_id IS NOT -1) AND url NOT IN (SELECT url FROM bookmarks WHERE " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "parent") + " < " + 0 + " AND " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " == 0)" + " AND " + "(" + "url" + " NOT LIKE ?)";
        Object[] objectArray = new String[]{"about:%"};
        SuggestedSites suggestedSites = GeckoProfile.get(this.getContext(), uri.getQueryParameter("profile")).getDB().getSuggestedSites();
        StringBuilder stringBuilder = new StringBuilder();
        Cursor cursor = suggestedSites.get(n2);
        Object[] objectArray2 = new String[]{};
        boolean bl = false;
        int n3 = cursor.getColumnIndexOrThrow("_id");
        int n4 = cursor.getColumnIndexOrThrow("url");
        int n5 = cursor.getColumnIndexOrThrow("title");
        while (cursor.moveToNext()) {
            if (bl) {
                stringBuilder.append(" UNION ALL");
            } else {
                bl = true;
            }
            stringBuilder.append(" SELECT ? AS _id, ? AS url, ? AS title");
            objectArray2 = DBUtils.appendSelectionArgs((String[])objectArray2, new String[]{cursor.getString(n3), cursor.getString(n4), cursor.getString(n5)});
        }
        cursor.close();
        boolean bl2 = false;
        int n6 = n2 - cursor.getCount();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < n6; ++i) {
            if (bl2) {
                stringBuilder2.append(" UNION ALL");
            } else {
                bl2 = true;
            }
            stringBuilder2.append(" SELECT -1 AS _id, '' AS url, '' AS title");
        }
        String string6 = " LIMIT MAX(0, (" + n2 + " - (SELECT COUNT(*) FROM " + "topsites" + ") - (SELECT COUNT(*) " + "FROM bookmarks WHERE parent == -3 AND deleted IS NOT 1" + "))) ";
        sQLiteDatabase.beginTransaction();
        try {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS topsites");
            sQLiteDatabase.execSQL("CREATE TEMP TABLE topsites AS SELECT _id, bookmark_id, history_id, url, title, history_id, 1 AS type FROM combined WHERE " + string5 + " ORDER BY " + BrowserContract.getFrecencySortOrder((boolean)true, (boolean)false) + " LIMIT " + n, objectArray);
            if (bl) {
                sQLiteDatabase.execSQL("INSERT INTO topsites SELECT * FROM (SELECT _id, _id AS bookmark_id,  -1 AS history_id, url, title, NULL AS history_id, 3 as type FROM ( " + stringBuilder.toString() + " )" + " WHERE " + "url" + " NOT IN (SELECT url FROM " + "topsites" + ")" + " AND " + "url" + " NOT IN (SELECT url " + "FROM bookmarks WHERE parent == -3 AND deleted IS NOT 1" + ")" + string6 + " )", objectArray2);
            }
            if (bl2) {
                sQLiteDatabase.execSQL("INSERT INTO topsites SELECT * FROM (SELECT _id, _id AS bookmark_id,  -1 AS history_id, url, title, NULL AS history_id, 0 as type FROM ( " + stringBuilder2.toString() + " )" + " LIMIT MAX(0, COALESCE((SELECT position FROM bookmarks WHERE parent == -3 AND deleted IS NOT 1), -1) + 1 - (SELECT COUNT(*) FROM bookmarks WHERE parent == -3 AND deleted IS NOT 1) - (SELECT COUNT(*) FROM topsites))" + " )");
            }
            SQLiteCursor sQLiteCursor = (SQLiteCursor)sQLiteDatabase.rawQuery("SELECT _id, bookmark_id, history_id, url, title, COALESCE(position, " + DBUtils.qualifyColumn("topsites", "rowid") + " + " + n2 + ")" + " AS " + "position" + ", " + "history_id" + ", " + "type" + " FROM " + "topsites" + " LEFT OUTER JOIN " + "(" + string4 + ") AS id_results" + " ON " + DBUtils.qualifyColumn("topsites", "rowid") + " = " + DBUtils.qualifyColumn("id_results", "rowid") + " UNION ALL " + "SELECT " + "_id" + ", " + "_id" + " AS " + "bookmark_id" + ", " + " -1 AS " + "history_id" + ", " + "url" + ", " + "title" + ", " + "position" + ", " + "NULL AS " + "history_id" + ", " + 2 + " as " + "type" + " " + "FROM bookmarks WHERE parent == -3 AND deleted IS NOT 1" + " ORDER BY " + "position", null);
            sQLiteCursor.setNotificationUri(this.getContext().getContentResolver(), BrowserContract.AUTHORITY_URI);
            sQLiteCursor.moveToFirst();
            sQLiteDatabase.setTransactionSuccessful();
            SQLiteCursor sQLiteCursor2 = sQLiteCursor;
            return sQLiteCursor2;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        int n = URI_MATCHER.match(uri);
        if (n == 1000) {
            return this.getTopSites(uri);
        }
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        String string4 = uri.getQueryParameter("limit");
        String string5 = null;
        switch (n) {
            case 100: 
            case 101: 
            case 102: {
                BrowserProvider.debug("Query is on bookmarks: " + uri);
                if (n == 101) {
                    string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                    stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
                } else if (n == 102) {
                    string2 = DBUtils.concatenateWhere(string2, "parent = ?");
                    stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
                }
                if (!BrowserProvider.shouldShowDeleted(uri)) {
                    string2 = DBUtils.concatenateWhere("deleted = 0", string2);
                }
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_BOOKMARKS_SORT_ORDER;
                } else {
                    BrowserProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(BOOKMARKS_PROJECTION_MAP);
                if (BrowserProvider.hasFaviconsInProjection(stringArray)) {
                    sQLiteQueryBuilder.setTables(VIEW_BOOKMARKS_WITH_FAVICONS);
                    break;
                }
                if (string2.contains("annotation_key")) {
                    sQLiteQueryBuilder.setTables(VIEW_BOOKMARKS_WITH_ANNOTATIONS);
                    string5 = uri.getQueryParameter("group_by");
                    break;
                }
                sQLiteQueryBuilder.setTables(TABLE_BOOKMARKS);
                break;
            }
            case 201: {
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 200: {
                BrowserProvider.debug("Query is on history: " + uri);
                if (!BrowserProvider.shouldShowDeleted(uri)) {
                    string2 = DBUtils.concatenateWhere("deleted = 0", string2);
                }
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_HISTORY_SORT_ORDER;
                }
                sQLiteQueryBuilder.setProjectionMap(HISTORY_PROJECTION_MAP);
                if (BrowserProvider.hasFaviconsInProjection(stringArray)) {
                    sQLiteQueryBuilder.setTables(VIEW_HISTORY_WITH_FAVICONS);
                    break;
                }
                sQLiteQueryBuilder.setTables(TABLE_HISTORY);
                break;
            }
            case 301: {
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 300: {
                BrowserProvider.debug("Query is on favicons: " + uri);
                sQLiteQueryBuilder.setProjectionMap(FAVICONS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(TABLE_FAVICONS);
                break;
            }
            case 801: {
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 800: {
                BrowserProvider.debug("Query is on thumbnails: " + uri);
                sQLiteQueryBuilder.setProjectionMap(THUMBNAILS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(TABLE_THUMBNAILS);
                break;
            }
            case 900: {
                BrowserProvider.debug("Query is on url annotations: " + uri);
                sQLiteQueryBuilder.setProjectionMap(URL_ANNOTATIONS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(TABLE_URL_ANNOTATIONS);
                break;
            }
            case 400: {
                BrowserProvider.debug("Query is on schema.");
                MatrixCursor matrixCursor = new MatrixCursor(new String[]{"version"});
                matrixCursor.newRow().add((Object)31);
                return matrixCursor;
            }
            case 500: {
                BrowserProvider.debug("Query is on combined: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_HISTORY_SORT_ORDER;
                }
                string5 = "url";
                sQLiteQueryBuilder.setProjectionMap(COMBINED_PROJECTION_MAP);
                if (BrowserProvider.hasFaviconsInProjection(stringArray)) {
                    sQLiteQueryBuilder.setTables(VIEW_COMBINED_WITH_FAVICONS);
                    break;
                }
                sQLiteQueryBuilder.setTables(VIEW_COMBINED);
                break;
            }
            default: {
                Table table = BrowserProvider.findTableFor(n);
                if (table == null) {
                    throw new UnsupportedOperationException("Unknown query URI " + uri);
                }
                BrowserProvider.trace("Update TABLE: " + uri);
                return table.query(sQLiteDatabase, uri, n, stringArray, string2, stringArray2, string3, string5, string4);
            }
        }
        BrowserProvider.trace("Running built query.");
        Cursor cursor = sQLiteQueryBuilder.query(sQLiteDatabase, stringArray, string2, stringArray2, string5, null, string3, string4);
        cursor.setNotificationUri(this.getContext().getContentResolver(), BrowserContract.AUTHORITY_URI);
        return cursor;
    }

    private int updateBookmarkPositions(Uri uri, String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        int n = stringArray.length;
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        sQLiteDatabase.beginTransaction();
        for (int i = 0; i < n; i += 100) {
            try {
                n2 += BrowserProvider.updateBookmarkPositionsInTransaction(sQLiteDatabase, stringArray, i, 100);
                continue;
            }
            catch (SQLException sQLException) {
                Log.e((String)LOGTAG, (String)("Got SQLite exception updating bookmark positions at offset " + i), (Throwable)sQLException);
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                sQLiteDatabase.beginTransaction();
            }
        }
        sQLiteDatabase.setTransactionSuccessful();
        sQLiteDatabase.endTransaction();
        return n2;
    }

    private static int updateBookmarkPositionsInTransaction(SQLiteDatabase sQLiteDatabase, String[] stringArray, int n, int n2) {
        int n3 = stringArray.length;
        int n4 = Math.min(n2, n3 - n);
        Object[] objectArray = new String[n4 * 2];
        System.arraycopy(stringArray, n, objectArray, 0, n4);
        System.arraycopy(stringArray, n, objectArray, n4, n4);
        StringBuilder stringBuilder = new StringBuilder("UPDATE bookmarks SET position = CASE guid");
        int n5 = n + n4;
        for (int i = n; i < n5; ++i) {
            if (stringArray[i] == null) {
                BrowserProvider.debug("updateBookmarkPositions called with null GUID at index " + i);
                return 0;
            }
            stringBuilder.append(" WHEN ? THEN " + i);
        }
        stringBuilder.append(" END WHERE " + DBUtils.computeSQLInClause(n4, "guid"));
        sQLiteDatabase.execSQL(stringBuilder.toString(), objectArray);
        return n4;
    }

    private int updateBookmarkParents(SQLiteDatabase sQLiteDatabase, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Updating bookmark parents of " + string2 + " (" + stringArray[0] + ")");
        String string3 = "_id IN ( SELECT DISTINCT parent FROM bookmarks WHERE " + string2 + " )";
        return sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, string3, stringArray);
    }

    private long insertBookmark(Uri uri, ContentValues contentValues) {
        long l = System.currentTimeMillis();
        if (!contentValues.containsKey("created")) {
            contentValues.put("created", Long.valueOf(l));
        }
        if (!contentValues.containsKey("modified")) {
            contentValues.put("modified", Long.valueOf(l));
        }
        if (!contentValues.containsKey("guid")) {
            contentValues.put("guid", Utils.generateGuid());
        }
        if (!contentValues.containsKey("position")) {
            BrowserProvider.debug("Inserting bookmark with no position for URI");
            contentValues.put("position", Long.toString(Long.MIN_VALUE));
        }
        if (!contentValues.containsKey("title")) {
            contentValues.put("title", "");
        }
        String string2 = contentValues.getAsString("url");
        BrowserProvider.debug("Inserting bookmark in database with URL: " + string2);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        return sQLiteDatabase.insertOrThrow(TABLE_BOOKMARKS, "title", contentValues);
    }

    private int updateOrInsertBookmark(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n = this.updateBookmarks(uri, contentValues, string2, stringArray);
        if (n > 0) {
            return n;
        }
        if (0L <= this.insertBookmark(uri, contentValues)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateBookmarks(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        String string3;
        BrowserProvider.trace("Updating bookmarks on URI: " + uri);
        String[] stringArray2 = new String[]{"_id"};
        if (!contentValues.containsKey("modified")) {
            contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        }
        BrowserProvider.trace("Querying bookmarks to update on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        try (Cursor cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, stringArray2, string2, stringArray, null, null, null);){
            string3 = DBUtils.computeSQLInClauseFromLongs(cursor, "_id");
        }
        this.beginWrite(sQLiteDatabase);
        return sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, string3, null);
    }

    private long insertHistory(Uri uri, ContentValues contentValues) {
        long l = System.currentTimeMillis();
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        if (!contentValues.containsKey("guid")) {
            contentValues.put("guid", Utils.generateGuid());
        }
        String string2 = contentValues.getAsString("url");
        BrowserProvider.debug("Inserting history in database with URL: " + string2);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        return sQLiteDatabase.insertOrThrow(TABLE_HISTORY, "visits", contentValues);
    }

    private int updateOrInsertHistory(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n = this.updateHistory(uri, contentValues, string2, stringArray);
        if (n > 0) {
            return n;
        }
        if (!contentValues.containsKey("visits")) {
            contentValues.put("visits", Integer.valueOf(1));
        }
        if (!contentValues.containsKey("title")) {
            contentValues.put("title", contentValues.getAsString("url"));
        }
        if (0L <= this.insertHistory(uri, contentValues)) {
            return 1;
        }
        return 0;
    }

    private int updateHistory(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        Long l;
        BrowserProvider.trace("Updating history on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (!contentValues.containsKey("modified")) {
            contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        }
        if (!this.shouldIncrementVisits(uri)) {
            BrowserProvider.trace("Updating history meta data only");
            return sQLiteDatabase.update(TABLE_HISTORY, contentValues, string2, stringArray);
        }
        BrowserProvider.trace("Updating history meta data and incrementing visits");
        ContentValues contentValues2 = new ContentValues(contentValues);
        long l2 = 1L;
        if (contentValues2.containsKey("visits")) {
            l = contentValues2.getAsLong("visits");
            if (l != null) {
                l2 = l;
            }
            contentValues2.remove("visits");
        }
        l = new ContentValues();
        l.put("visits", "visits + " + l2);
        ContentValues[] contentValuesArray = new ContentValues[]{contentValues2, l};
        DBUtils.UpdateOperation[] updateOperationArray = new DBUtils.UpdateOperation[]{DBUtils.UpdateOperation.ASSIGN, DBUtils.UpdateOperation.EXPRESSION};
        return DBUtils.updateArrays(sQLiteDatabase, TABLE_HISTORY, contentValuesArray, updateOperationArray, string2, stringArray);
    }

    private void updateFaviconIdsForUrl(SQLiteDatabase sQLiteDatabase, String string2, Long l) {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put("favicon_id", l);
        sQLiteDatabase.update(TABLE_HISTORY, contentValues, "url = ?", new String[]{string2});
        sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, "url = ?", new String[]{string2});
    }

    private long insertFavicon(Uri uri, ContentValues contentValues) {
        return this.insertFavicon(this.getWritableDatabase(uri), contentValues);
    }

    private long insertFavicon(SQLiteDatabase sQLiteDatabase, ContentValues contentValues) {
        String string2 = contentValues.getAsString("url");
        String string3 = null;
        BrowserProvider.trace("Inserting favicon for URL: " + string2);
        DBUtils.stripEmptyByteArray(contentValues, "data");
        if (contentValues.containsKey("page_url")) {
            string3 = contentValues.getAsString("page_url");
            contentValues.remove("page_url");
        }
        if (TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            contentValues.put("url", Favicons.guessDefaultFaviconURL(string3));
        }
        long l = System.currentTimeMillis();
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        this.beginWrite(sQLiteDatabase);
        long l2 = sQLiteDatabase.insertOrThrow(TABLE_FAVICONS, null, contentValues);
        if (string3 != null) {
            this.updateFaviconIdsForUrl(sQLiteDatabase, string3, l2);
        }
        return l2;
    }

    private int updateOrInsertFavicon(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateFavicon(uri, contentValues, string2, stringArray, true);
    }

    private int updateExistingFavicon(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateFavicon(uri, contentValues, string2, stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateFavicon(Uri uri, ContentValues contentValues, String string2, String[] stringArray, boolean bl) {
        String string3 = contentValues.getAsString("url");
        String string4 = null;
        int n = 0;
        Long l = null;
        long l2 = System.currentTimeMillis();
        BrowserProvider.trace("Updating favicon for URL: " + string3);
        DBUtils.stripEmptyByteArray(contentValues, "data");
        if (contentValues.containsKey("page_url")) {
            string4 = contentValues.getAsString("page_url");
            contentValues.remove("page_url");
        }
        contentValues.put("modified", Long.valueOf(l2));
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (!bl || string3 != null) {
            n = sQLiteDatabase.update(TABLE_FAVICONS, contentValues, string2, stringArray);
        }
        if (n > 0) {
            if (string3 != null && string4 != null) {
                try (Cursor cursor = sQLiteDatabase.query(TABLE_FAVICONS, new String[]{"_id"}, "url = ?", new String[]{string3}, null, null, null);){
                    if (cursor.moveToFirst()) {
                        l = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                    }
                }
            }
            if (string4 != null) {
                this.beginWrite(sQLiteDatabase);
            }
        } else if (bl) {
            contentValues.put("created", Long.valueOf(l2));
            BrowserProvider.trace("No update, inserting favicon for URL: " + string3);
            this.beginWrite(sQLiteDatabase);
            l = sQLiteDatabase.insert(TABLE_FAVICONS, null, contentValues);
            n = 1;
        }
        if (string4 != null) {
            this.updateFaviconIdsForUrl(sQLiteDatabase, string4, l);
        }
        return n;
    }

    private long insertThumbnail(Uri uri, ContentValues contentValues) {
        String string2 = contentValues.getAsString("url");
        BrowserProvider.trace("Inserting thumbnail for URL: " + string2);
        DBUtils.stripEmptyByteArray(contentValues, "data");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        return sQLiteDatabase.insertOrThrow(TABLE_THUMBNAILS, null, contentValues);
    }

    private long insertUrlAnnotation(Uri uri, ContentValues contentValues) {
        String string2 = contentValues.getAsString("url");
        BrowserProvider.trace("Inserting url annotations for URL: " + string2);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        return sQLiteDatabase.insertOrThrow(TABLE_URL_ANNOTATIONS, null, contentValues);
    }

    private void deleteUrlAnnotation(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.trace("Deleting url annotation for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        sQLiteDatabase.delete(TABLE_URL_ANNOTATIONS, string2, stringArray);
    }

    private void updateUrlAnnotation(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Updating url annotation for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        sQLiteDatabase.update(TABLE_URL_ANNOTATIONS, contentValues, string2, stringArray);
    }

    private int updateOrInsertThumbnail(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateThumbnail(uri, contentValues, string2, stringArray, true);
    }

    private int updateExistingThumbnail(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateThumbnail(uri, contentValues, string2, stringArray, false);
    }

    private int updateThumbnail(Uri uri, ContentValues contentValues, String string2, String[] stringArray, boolean bl) {
        String string3 = contentValues.getAsString("url");
        DBUtils.stripEmptyByteArray(contentValues, "data");
        BrowserProvider.trace("Updating thumbnail for URL: " + string3);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        int n = sQLiteDatabase.update(TABLE_THUMBNAILS, contentValues, string2, stringArray);
        if (n == 0 && bl) {
            BrowserProvider.trace("No update, inserting thumbnail for URL: " + string3);
            sQLiteDatabase.insert(TABLE_THUMBNAILS, null, contentValues);
            n = 1;
        }
        return n;
    }

    private int deleteHistory(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting history entry for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (BrowserProvider.isCallerSync(uri)) {
            return sQLiteDatabase.delete(TABLE_HISTORY, string2, stringArray);
        }
        BrowserProvider.debug("Marking history entry as deleted for URI: " + uri);
        ContentValues contentValues = new ContentValues();
        contentValues.put("deleted", Integer.valueOf(1));
        contentValues.putNull("title");
        contentValues.put("url", "");
        contentValues.put("created", Integer.valueOf(0));
        contentValues.put("date", Integer.valueOf(0));
        contentValues.put("visits", Integer.valueOf(0));
        contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        int n = sQLiteDatabase.update(TABLE_HISTORY, contentValues, string2, stringArray);
        try {
            this.cleanUpSomeDeletedRecords(uri, TABLE_HISTORY);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Unable to clean up deleted history records: ", (Throwable)exception);
        }
        return n;
    }

    private int deleteBookmarks(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting bookmarks for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (BrowserProvider.isCallerSync(uri)) {
            this.beginWrite(sQLiteDatabase);
            return sQLiteDatabase.delete(TABLE_BOOKMARKS, string2, stringArray);
        }
        BrowserProvider.debug("Marking bookmarks as deleted for URI: " + uri);
        ContentValues contentValues = new ContentValues();
        contentValues.put("deleted", Integer.valueOf(1));
        contentValues.put("position", Integer.valueOf(0));
        contentValues.putNull("parent");
        contentValues.putNull("url");
        contentValues.putNull("title");
        contentValues.putNull("description");
        contentValues.putNull("keyword");
        contentValues.putNull("tags");
        contentValues.putNull("favicon_id");
        int n = this.updateBookmarks(uri, contentValues, string2, stringArray);
        try {
            this.cleanUpSomeDeletedRecords(uri, TABLE_BOOKMARKS);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Unable to clean up deleted bookmark records: ", (Throwable)exception);
        }
        return n;
    }

    private int deleteFavicons(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting favicons for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        return sQLiteDatabase.delete(TABLE_FAVICONS, string2, stringArray);
    }

    private int deleteThumbnails(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting thumbnails for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        return sQLiteDatabase.delete(TABLE_THUMBNAILS, string2, stringArray);
    }

    private int deleteUnusedImages(Uri uri) {
        BrowserProvider.debug("Deleting all unused favicons and thumbnails for URI: " + uri);
        String string2 = "_id NOT IN (SELECT favicon_id FROM history WHERE deleted = 0 AND favicon_id IS NOT NULL UNION ALL SELECT favicon_id FROM bookmarks WHERE deleted = 0 AND favicon_id IS NOT NULL)";
        String string3 = "url NOT IN (SELECT url FROM history WHERE deleted = 0 AND url IS NOT NULL UNION ALL SELECT url FROM bookmarks WHERE deleted = 0 AND url IS NOT NULL)";
        return this.deleteFavicons(uri, string2, null) + this.deleteThumbnails(uri, string3, null) + this.getURLMetadataTable().deleteUnused(this.getWritableDatabase(uri));
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
        int n = arrayList.size();
        ContentProviderResult[] contentProviderResultArray = new ContentProviderResult[n];
        if (n < 1) {
            BrowserProvider.debug("applyBatch: no operations; returning immediately.");
            return contentProviderResultArray;
        }
        boolean bl = false;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(arrayList.get(0).getUri());
        this.beginBatch(sQLiteDatabase);
        for (int i = 0; i < n; ++i) {
            try {
                ContentProviderOperation contentProviderOperation = arrayList.get(i);
                contentProviderResultArray[i] = contentProviderOperation.apply((ContentProvider)this, contentProviderResultArray, i);
                continue;
            }
            catch (SQLException sQLException) {
                Log.w((String)LOGTAG, (String)"SQLite Exception during applyBatch.", (Throwable)sQLException);
                contentProviderResultArray[i] = new ContentProviderResult(0);
                bl = true;
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                sQLiteDatabase.beginTransaction();
                continue;
            }
            catch (OperationApplicationException operationApplicationException) {
                contentProviderResultArray[i] = new ContentProviderResult(0);
                bl = true;
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                sQLiteDatabase.beginTransaction();
            }
        }
        BrowserProvider.trace("Flushing DB applyBatch...");
        this.markBatchSuccessful(sQLiteDatabase);
        this.endBatch(sQLiteDatabase);
        if (bl) {
            throw new OperationApplicationException();
        }
        return contentProviderResultArray;
    }

    private static Table findTableFor(int n) {
        for (Table table : sTables) {
            for (Table.ContentProviderInfo contentProviderInfo : table.getContentProviderInfo()) {
                if (contentProviderInfo.id != n) continue;
                return table;
            }
        }
        return null;
    }

    private static void addTablesToMatcher(Table[] tableArray, UriMatcher uriMatcher) {
    }

    private static String getContentItemType(int n) {
        for (Table table : sTables) {
            for (Table.ContentProviderInfo contentProviderInfo : table.getContentProviderInfo()) {
                if (contentProviderInfo.id != n) continue;
                return "vnd.android.cursor.item/" + contentProviderInfo.name;
            }
        }
        return null;
    }

    static {
        sTables = new Table[]{new URLMetadataTable()};
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_BOOKMARKS, 100);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/#", 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/parents", 103);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/positions", 104);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/folder/#", 102);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_id", "_id");
        hashMap.put("title", "title");
        hashMap.put("url", "url");
        hashMap.put("favicon", "favicon");
        hashMap.put("favicon_id", "favicon_id");
        hashMap.put("favicon_url", "favicon_url");
        hashMap.put("type", "type");
        hashMap.put("parent", "parent");
        hashMap.put("position", "position");
        hashMap.put("tags", "tags");
        hashMap.put("description", "description");
        hashMap.put("keyword", "keyword");
        hashMap.put("created", "created");
        hashMap.put("modified", "modified");
        hashMap.put("guid", "guid");
        hashMap.put("deleted", "deleted");
        BOOKMARKS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_HISTORY, 200);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "history/#", 201);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "history/old", 202);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("title", "title");
        hashMap.put("url", "url");
        hashMap.put("favicon", "favicon");
        hashMap.put("favicon_id", "favicon_id");
        hashMap.put("favicon_url", "favicon_url");
        hashMap.put("visits", "visits");
        hashMap.put("date", "date");
        hashMap.put("created", "created");
        hashMap.put("modified", "modified");
        hashMap.put("guid", "guid");
        hashMap.put("deleted", "deleted");
        HISTORY_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_FAVICONS, 300);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "favicons/#", 301);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("url", "url");
        hashMap.put("data", "data");
        hashMap.put("created", "created");
        hashMap.put("modified", "modified");
        FAVICONS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_THUMBNAILS, 800);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "thumbnails/#", 801);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("url", "url");
        hashMap.put("data", "data");
        THUMBNAILS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_URL_ANNOTATIONS, 900);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("url", "url");
        hashMap.put("key", "key");
        hashMap.put("value", "value");
        hashMap.put("created", "created");
        hashMap.put("modified", "modified");
        hashMap.put("sync_status", "sync_status");
        URL_ANNOTATIONS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", VIEW_COMBINED, 500);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("bookmark_id", "bookmark_id");
        hashMap.put("history_id", "history_id");
        hashMap.put("url", "url");
        hashMap.put("title", "title");
        hashMap.put("visits", "visits");
        hashMap.put("date", "date");
        hashMap.put("favicon", "favicon");
        hashMap.put("favicon_id", "favicon_id");
        hashMap.put("favicon_url", "favicon_url");
        COMBINED_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "schema", 400);
        hashMap = new HashMap();
        hashMap.put("version", "version");
        SCHEMA_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "control", 600);
        for (Table table : sTables) {
            for (Table.ContentProviderInfo contentProviderInfo : table.getContentProviderInfo()) {
                URI_MATCHER.addURI("org.mozilla.fennec.db.browser", contentProviderInfo.name, contentProviderInfo.id);
            }
        }
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "topsites", 1000);
        logDebug = Log.isLoggable((String)LOGTAG, (int)3);
        logVerbose = Log.isLoggable((String)LOGTAG, (int)2);
    }
}

