/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import org.json.JSONException;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.feeds.subscriptions.FeedSubscription;

public class LocalUrlAnnotations
implements UrlAnnotations {
    private static final String LOGTAG = "LocalUrlAnnotations";
    private Uri urlAnnotationsTableWithProfile;

    public LocalUrlAnnotations(String string2) {
        this.urlAnnotationsTableWithProfile = DBUtils.appendProfile(string2, BrowserContract.UrlAnnotations.CONTENT_URI);
    }

    @Override
    public Cursor getFeedSubscriptions(ContentResolver contentResolver) {
        return this.queryByKey(contentResolver, BrowserContract.UrlAnnotations.Key.FEED_SUBSCRIPTION, new String[]{"url", "value"}, null);
    }

    @Override
    public void insertFeedUrl(ContentResolver contentResolver, String string2, String string3) {
        this.insertAnnotation(contentResolver, string2, BrowserContract.UrlAnnotations.Key.FEED, string3);
    }

    @Override
    public boolean hasFeedUrlForWebsite(ContentResolver contentResolver, String string2) {
        return this.hasResultsForSelection(contentResolver, "url = ? AND key = ?", new String[]{string2, BrowserContract.UrlAnnotations.Key.FEED.getDbValue()});
    }

    @Override
    public boolean hasWebsiteForFeedUrl(ContentResolver contentResolver, String string2) {
        return this.hasResultsForSelection(contentResolver, "value = ? AND key = ?", new String[]{string2, BrowserContract.UrlAnnotations.Key.FEED.getDbValue()});
    }

    @Override
    public void deleteFeedUrl(ContentResolver contentResolver, String string2) {
        this.deleteAnnotation(contentResolver, string2, BrowserContract.UrlAnnotations.Key.FEED);
    }

    @Override
    public Cursor getWebsitesWithFeedUrl(ContentResolver contentResolver) {
        return contentResolver.query(this.urlAnnotationsTableWithProfile, new String[]{"url"}, "key = ?", new String[]{BrowserContract.UrlAnnotations.Key.FEED.getDbValue()}, null);
    }

    @Override
    public boolean hasFeedSubscription(ContentResolver contentResolver, String string2) {
        return this.hasResultsForSelection(contentResolver, "url = ? AND key = ?", new String[]{string2, BrowserContract.UrlAnnotations.Key.FEED_SUBSCRIPTION.getDbValue()});
    }

    @Override
    public void insertFeedSubscription(ContentResolver contentResolver, FeedSubscription feedSubscription) {
        try {
            this.insertAnnotation(contentResolver, feedSubscription.getFeedUrl(), BrowserContract.UrlAnnotations.Key.FEED_SUBSCRIPTION, feedSubscription.toJSON().toString());
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Could not serialize subscription");
        }
    }

    @Override
    public void updateFeedSubscription(ContentResolver contentResolver, FeedSubscription feedSubscription) {
        try {
            this.updateAnnotation(contentResolver, feedSubscription.getFeedUrl(), BrowserContract.UrlAnnotations.Key.FEED_SUBSCRIPTION, feedSubscription.toJSON().toString());
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Could not serialize subscription");
        }
    }

    @Override
    public void deleteFeedSubscription(ContentResolver contentResolver, FeedSubscription feedSubscription) {
        this.deleteAnnotation(contentResolver, feedSubscription.getFeedUrl(), BrowserContract.UrlAnnotations.Key.FEED_SUBSCRIPTION);
    }

    private int deleteAnnotation(ContentResolver contentResolver, String string2, BrowserContract.UrlAnnotations.Key key) {
        return contentResolver.delete(this.urlAnnotationsTableWithProfile, "key = ? AND url = ?", new String[]{key.getDbValue(), string2});
    }

    private int updateAnnotation(ContentResolver contentResolver, String string2, BrowserContract.UrlAnnotations.Key key, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("value", string3);
        contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        return contentResolver.update(this.urlAnnotationsTableWithProfile, contentValues, "key = ? AND url = ?", new String[]{key.getDbValue(), string2});
    }

    private void insertAnnotation(ContentResolver contentResolver, String string2, BrowserContract.UrlAnnotations.Key key, String string3) {
        this.insertAnnotation(contentResolver, string2, key.getDbValue(), string3);
    }

    @Override
    @RobocopTarget
    public void insertAnnotation(ContentResolver contentResolver, String string2, String string3, String string4) {
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues(5);
        contentValues.put("url", string2);
        contentValues.put("key", string3);
        contentValues.put("value", string4);
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        contentResolver.insert(this.urlAnnotationsTableWithProfile, contentValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResultsForSelection(ContentResolver contentResolver, String string2, String[] stringArray) {
        Cursor cursor = contentResolver.query(this.urlAnnotationsTableWithProfile, new String[]{"_id"}, string2, stringArray, null);
        if (cursor == null) {
            return false;
        }
        try {
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    private Cursor queryByKey(ContentResolver contentResolver, @NonNull BrowserContract.UrlAnnotations.Key key, @Nullable String[] stringArray, @Nullable String string2) {
        return contentResolver.query(this.urlAnnotationsTableWithProfile, stringArray, "key = ?", new String[]{key.getDbValue()}, string2);
    }

    @Override
    public Cursor getScreenshots(ContentResolver contentResolver) {
        return this.queryByKey(contentResolver, BrowserContract.UrlAnnotations.Key.SCREENSHOT, new String[]{"_id", "url", "key", "value", "created"}, "created DESC");
    }

    @Override
    public void insertScreenshot(ContentResolver contentResolver, String string2, String string3) {
        this.insertAnnotation(contentResolver, string2, BrowserContract.UrlAnnotations.Key.SCREENSHOT.getDbValue(), string3);
    }

    @Override
    public void insertReaderViewUrl(ContentResolver contentResolver, String string2) {
        this.insertAnnotation(contentResolver, string2, BrowserContract.UrlAnnotations.Key.READER_VIEW.getDbValue(), "true");
    }

    @Override
    public void deleteReaderViewUrl(ContentResolver contentResolver, String string2) {
        this.deleteAnnotation(contentResolver, string2, BrowserContract.UrlAnnotations.Key.READER_VIEW);
    }
}

