/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.dlc.BaseAction;
import org.mozilla.gecko.dlc.DownloadContentService;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentCatalog;

public class StudyAction
extends BaseAction {
    private static final String LOGTAG = "DLCStudyAction";

    @Override
    public void perform(Context context, DownloadContentCatalog downloadContentCatalog) {
        Log.d((String)LOGTAG, (String)"Studying catalog..");
        for (DownloadContent downloadContent : downloadContentCatalog.getContentToStudy()) {
            if (!this.isMatching(context, downloadContent) || !downloadContent.isAssetArchive() || !downloadContent.isFont()) continue;
            downloadContentCatalog.scheduleDownload(downloadContent);
            Log.d((String)LOGTAG, (String)("Scheduled download: " + downloadContent));
        }
        if (downloadContentCatalog.hasScheduledDownloads()) {
            this.startDownloads(context);
        }
        Log.v((String)LOGTAG, (String)"Done");
    }

    protected boolean isMatching(Context context, DownloadContent downloadContent) {
        String string2;
        String string3;
        String string4 = downloadContent.getAndroidApiPattern();
        if (!TextUtils.isEmpty((CharSequence)string4) && (string3 = String.valueOf(Build.VERSION.SDK_INT)).matches(string4)) {
            Log.d((String)LOGTAG, (String)String.format("Android API (%s) does not match pattern: %s", string3, string4));
            return false;
        }
        string3 = downloadContent.getAppIdPattern();
        if (!TextUtils.isEmpty((CharSequence)string3) && !(string2 = context.getPackageName()).matches(string3)) {
            Log.d((String)LOGTAG, (String)String.format("App ID (%s) does not match pattern: %s", string2, string3));
            return false;
        }
        string2 = downloadContent.getAppVersionPattern();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                String string5 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
                if (!string5.matches(string2)) {
                    Log.d((String)LOGTAG, (String)String.format("App version (%s) does not match pattern: %s", string5, string2));
                    return false;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new AssertionError((Object)"Should not happen: Can't get package info of own package");
            }
        }
        return true;
    }

    protected void startDownloads(Context context) {
        DownloadContentService.startDownloads(context);
    }
}

