/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.firstrun.FirstrunPager;
import org.mozilla.gecko.firstrun.FirstrunPanel;

public class FirstrunAnimationContainer
extends LinearLayout {
    public static final String PREF_FIRSTRUN_ENABLED = "startpane_enabled";
    private FirstrunPager pager;
    private boolean visible;
    private OnFinishListener onFinishListener;

    public FirstrunAnimationContainer(Context context) {
        this(context, null);
    }

    public FirstrunAnimationContainer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void load(Context context, FragmentManager fragmentManager) {
        this.visible = true;
        this.pager = (FirstrunPager)this.findViewById(R.id.firstrun_pager);
        this.pager.load(context, fragmentManager, new OnFinishListener(){

            @Override
            public void onFinish() {
                FirstrunAnimationContainer.this.hide();
            }
        });
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void hide() {
        this.visible = false;
        if (this.onFinishListener != null) {
            this.onFinishListener.onFinish();
        }
        this.animateHide();
        Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, "onboarding2-a");
        Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, "onboarding2-b");
        Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, "onboarding2-c");
    }

    private void animateHide() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f});
        objectAnimator.setDuration(150L);
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                FirstrunAnimationContainer.this.setVisibility(8);
            }
        });
        objectAnimator.start();
    }

    public boolean showBrowserHint() {
        int n = this.pager.getCurrentItem();
        FirstrunPanel firstrunPanel = (FirstrunPanel)((FirstrunPager.ViewPagerAdapter)this.pager.getAdapter()).getItem(n);
        this.pager.cleanup();
        return firstrunPanel.shouldShowBrowserHint();
    }

    public void registerOnFinishListener(OnFinishListener onFinishListener) {
        this.onFinishListener = onFinishListener;
    }

    public static interface OnFinishListener {
        public void onFinish();
    }
}

