/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.gfx.Axis;
import org.mozilla.gecko.gfx.FullScreenState;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PanZoomTarget;
import org.mozilla.gecko.gfx.PointUtils;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.gfx.SimpleScaleGestureDetector;
import org.mozilla.gecko.gfx.SubdocumentScrollHelper;
import org.mozilla.gecko.gfx.TouchEventHandler;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

class JavaPanZoomController
extends GestureDetector.SimpleOnGestureListener
implements PanZoomController,
SimpleScaleGestureDetector.SimpleScaleGestureListener,
GeckoEventListener {
    private static final String LOGTAG = "GeckoPanZoomController";
    private static final String MESSAGE_ZOOM_RECT = "Browser:ZoomToRect";
    private static final String MESSAGE_ZOOM_PAGE = "Browser:ZoomToPageWidth";
    private static final String MESSAGE_TOUCH_LISTENER = "Tab:HasTouchListener";
    private static final float STOPPED_THRESHOLD = 4.0f;
    private static final float FLING_STOPPED_THRESHOLD = 0.1f;
    private static final double AXIS_LOCK_ANGLE = 0.5235987755982988;
    private static final double AXIS_BREAKOUT_ANGLE = 0.39269908169872414;
    public static final float AXIS_BREAKOUT_THRESHOLD = 0.03125f * (float)GeckoAppShell.getDpi();
    private static final float MAX_ZOOM = 4.0f;
    private static final float MAX_SCROLL = 0.075f * (float)GeckoAppShell.getDpi();
    private static final float MAX_ZOOM_DELTA = 0.125f;
    private static final int BOUNCE_ANIMATION_DURATION = 250000000;
    private final PanZoomTarget mTarget;
    private final SubdocumentScrollHelper mSubscroller;
    private final Axis mX;
    private final Axis mY;
    private final TouchEventHandler mTouchEventHandler;
    private final EventDispatcher mEventDispatcher;
    private PanZoomRenderTask mAnimationRenderTask;
    private PointF mLastZoomFocus;
    private long mLastEventTime;
    private PanZoomState mState;
    private float mAutonavZoomDelta;
    private AxisLockMode mMode;
    private boolean mWaitForDoubleTap;
    private boolean mNegateWheelScroll;
    private boolean mDefaultPrevented;
    private boolean isLongpressEnabled;
    private boolean mIgnoreLongPress;
    private float mPointerScrollFactor;
    private Overscroll mOverscroll;
    private final PrefsHelper.PrefHandler mPrefsObserver;

    public JavaPanZoomController(PanZoomTarget panZoomTarget, View view, EventDispatcher eventDispatcher) {
        this.mTarget = panZoomTarget;
        this.mSubscroller = new SubdocumentScrollHelper(eventDispatcher);
        this.mX = new AxisX(this.mSubscroller);
        this.mY = new AxisY(this.mSubscroller);
        this.mTouchEventHandler = new TouchEventHandler(view.getContext(), view, this);
        this.isLongpressEnabled = true;
        this.checkMainThread();
        this.setState(PanZoomState.NOTHING);
        this.mEventDispatcher = eventDispatcher;
        this.mEventDispatcher.registerGeckoThreadListener(this, MESSAGE_ZOOM_RECT, MESSAGE_ZOOM_PAGE, MESSAGE_TOUCH_LISTENER);
        this.mMode = AxisLockMode.STANDARD;
        String[] stringArray = new String[]{"ui.scrolling.axis_lock_mode", "ui.scrolling.negate_wheel_scroll", "ui.scrolling.gamepad_dead_zone"};
        this.mPrefsObserver = new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, String string3) {
                if (string2.equals("ui.scrolling.axis_lock_mode")) {
                    if (string3.equals("standard")) {
                        JavaPanZoomController.this.mMode = AxisLockMode.STANDARD;
                    } else if (string3.equals("free")) {
                        JavaPanZoomController.this.mMode = AxisLockMode.FREE;
                    } else {
                        JavaPanZoomController.this.mMode = AxisLockMode.STICKY;
                    }
                }
            }

            @Override
            public void prefValue(String string2, int n) {
                if (string2.equals("ui.scrolling.gamepad_dead_zone")) {
                    GamepadUtils.overrideDeadZoneThreshold((float)((float)n / 1000.0f));
                }
            }

            @Override
            public void prefValue(String string2, boolean bl) {
                if (string2.equals("ui.scrolling.negate_wheel_scroll")) {
                    JavaPanZoomController.this.mNegateWheelScroll = bl;
                }
            }
        };
        PrefsHelper.addObserver(stringArray, this.mPrefsObserver);
        Axis.initPrefs();
        TypedValue typedValue = new TypedValue();
        this.mPointerScrollFactor = view.getContext().getTheme().resolveAttribute(16842829, typedValue, true) ? typedValue.getDimension(view.getContext().getResources().getDisplayMetrics()) : MAX_SCROLL;
    }

    @Override
    public void destroy() {
        PrefsHelper.removeObserver(this.mPrefsObserver);
        this.mEventDispatcher.unregisterGeckoThreadListener(this, MESSAGE_ZOOM_RECT, MESSAGE_ZOOM_PAGE, MESSAGE_TOUCH_LISTENER);
        this.mSubscroller.destroy();
        this.mTouchEventHandler.destroy();
    }

    private static final float easeOut(float f) {
        return -(f -= 1.0f) * f + 1.0f;
    }

    private void setState(PanZoomState panZoomState) {
        if (panZoomState != this.mState) {
            GeckoAppShell.notifyObservers("PanZoom:StateChange", panZoomState.toString());
            this.mState = panZoomState;
            if (panZoomState == PanZoomState.NOTHING) {
                this.mTarget.panZoomStopped();
            }
        }
    }

    private ImmutableViewportMetrics getMetrics() {
        return this.mTarget.getViewportMetrics();
    }

    private void checkMainThread() {
        if (!ThreadUtils.isOnUiThread()) {
            Log.e((String)LOGTAG, (String)"Uh-oh, we're running on the wrong thread!", (Throwable)new Exception());
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (MESSAGE_ZOOM_RECT.equals(string2)) {
                float f = (float)jSONObject.getDouble("x");
                float f2 = (float)jSONObject.getDouble("y");
                final RectF rectF = new RectF(f, f2, f + (float)jSONObject.getDouble("w"), f2 + (float)jSONObject.getDouble("h"));
                if (jSONObject.optBoolean("animate", true)) {
                    this.mTarget.post(new Runnable(){

                        @Override
                        public void run() {
                            JavaPanZoomController.this.animatedZoomTo(rectF);
                        }
                    });
                } else {
                    this.mTarget.setViewportMetrics(this.getMetricsToZoomTo(rectF));
                }
            } else if (MESSAGE_ZOOM_PAGE.equals(string2)) {
                ImmutableViewportMetrics immutableViewportMetrics = this.getMetrics();
                RectF rectF = immutableViewportMetrics.getCssPageRect();
                RectF rectF2 = immutableViewportMetrics.getCssViewport();
                float f = rectF2.top;
                float f3 = rectF2.height() * rectF.width() / rectF2.width();
                float f4 = rectF2.height() - f3;
                final RectF rectF3 = new RectF(0.0f, f + f4 / 2.0f, rectF.width(), f + f4 / 2.0f + f3);
                if (jSONObject.optBoolean("animate", true)) {
                    this.mTarget.post(new Runnable(){

                        @Override
                        public void run() {
                            JavaPanZoomController.this.animatedZoomTo(rectF3);
                        }
                    });
                } else {
                    this.mTarget.setViewportMetrics(this.getMetricsToZoomTo(rectF3));
                }
            } else if (MESSAGE_TOUCH_LISTENER.equals(string2)) {
                int n = jSONObject.getInt("tabID");
                final Tab tab = Tabs.getInstance().getTab(n);
                if (tab == null) {
                    return;
                }
                tab.setHasTouchListeners(true);
                this.mTarget.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Tabs.getInstance().isSelectedTab(tab)) {
                            JavaPanZoomController.this.mTouchEventHandler.setWaitForTouchListeners(true);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    @Override
    public boolean onKeyEvent(KeyEvent keyEvent) {
        if (AppConstants.Versions.preHCMR1) {
            return false;
        }
        if ((keyEvent.getSource() & 0x401) == 1025 && keyEvent.getAction() == 0) {
            switch (keyEvent.getKeyCode()) {
                case 168: {
                    return this.animatedScale(0.2f);
                }
                case 169: {
                    return this.animatedScale(-0.2f);
                }
            }
        }
        return false;
    }

    @Override
    public void onMotionEventVelocity(long l, float f) {
    }

    @Override
    public boolean onMotionEvent(MotionEvent motionEvent) {
        if (AppConstants.Versions.preHCMR1) {
            return false;
        }
        switch (motionEvent.getSource() & 0xFF) {
            case 2: {
                switch (motionEvent.getAction() & 0xFF) {
                    case 8: {
                        return this.handlePointerScroll(motionEvent);
                    }
                }
                break;
            }
            case 16: {
                switch (motionEvent.getAction() & 0xFF) {
                    case 2: {
                        return this.handleJoystickNav(motionEvent);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.mTouchEventHandler.handleEvent(motionEvent);
    }

    boolean handleEvent(MotionEvent motionEvent, boolean bl) {
        this.mDefaultPrevented = bl;
        switch (motionEvent.getAction() & 0xFF) {
            case 0: {
                return this.handleTouchStart(motionEvent);
            }
            case 2: {
                return this.handleTouchMove(motionEvent);
            }
            case 1: {
                return this.handleTouchEnd(motionEvent);
            }
            case 3: {
                return this.handleTouchCancel(motionEvent);
            }
        }
        return false;
    }

    @Override
    public void notifyDefaultActionPrevented(boolean bl) {
        this.mTouchEventHandler.handleEventListenerAction(!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortAnimation() {
        this.checkMainThread();
        switch (this.mState) {
            case FLING: {
                this.mX.stopFling();
                this.mY.stopFling();
            }
            case BOUNCE: 
            case ANIMATED_ZOOM: {
                this.setState(PanZoomState.NOTHING);
            }
            case NOTHING: {
                Object object = this.mTarget.getLock();
                synchronized (object) {
                    this.mTarget.setViewportMetrics(this.getValidViewportMetrics());
                    this.mTarget.forceRedraw(null);
                    break;
                }
            }
        }
    }

    public void startingNewEventBlock(MotionEvent motionEvent, boolean bl) {
        this.checkMainThread();
        this.mSubscroller.cancel();
        this.mIgnoreLongPress = false;
        if (bl) {
            if ((motionEvent.getAction() & 0xFF) == 0) {
                this.setState(PanZoomState.WAITING_LISTENERS);
            } else if ((motionEvent.getAction() & 0xFF) == 5) {
                this.mIgnoreLongPress = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pageRectUpdated() {
        if (this.mState == PanZoomState.NOTHING) {
            Object object = this.mTarget.getLock();
            synchronized (object) {
                ImmutableViewportMetrics immutableViewportMetrics = this.getValidViewportMetrics();
                if (!this.getMetrics().fuzzyEquals(immutableViewportMetrics)) {
                    this.mTarget.setViewportMetrics(immutableViewportMetrics);
                }
            }
        }
    }

    private boolean handleTouchStart(MotionEvent motionEvent) {
        this.stopAnimationTask();
        switch (this.mState) {
            case ANIMATED_ZOOM: {
                this.mTarget.forceRedraw(null);
            }
            case FLING: 
            case BOUNCE: 
            case NOTHING: 
            case AUTONAV: 
            case WAITING_LISTENERS: {
                this.startTouch(motionEvent.getX(0), motionEvent.getY(0), motionEvent.getEventTime());
                return false;
            }
            case TOUCHING: 
            case PANNING: 
            case PANNING_LOCKED_X: 
            case PANNING_LOCKED_Y: 
            case PANNING_HOLD: 
            case PANNING_HOLD_LOCKED_X: 
            case PANNING_HOLD_LOCKED_Y: 
            case PINCHING: {
                Log.e((String)LOGTAG, (String)("Received impossible touch down while in " + (Object)((Object)this.mState)));
                return false;
            }
        }
        Log.e((String)LOGTAG, (String)("Unhandled case " + (Object)((Object)this.mState) + " in handleTouchStart"));
        return false;
    }

    private boolean handleTouchMove(MotionEvent motionEvent) {
        switch (this.mState) {
            case FLING: 
            case BOUNCE: 
            case AUTONAV: 
            case WAITING_LISTENERS: {
                Log.e((String)LOGTAG, (String)("Received impossible touch move while in " + (Object)((Object)this.mState)));
            }
            case ANIMATED_ZOOM: 
            case NOTHING: {
                return false;
            }
            case TOUCHING: {
                if (this.mTarget.getFullScreenState() == FullScreenState.NON_ROOT_ELEMENT && !this.mSubscroller.scrolling()) {
                    return false;
                }
                if (this.panDistance(motionEvent) < PanZoomController.PAN_THRESHOLD) {
                    return false;
                }
                this.cancelTouch();
                this.startPanning(motionEvent.getX(0), motionEvent.getY(0), motionEvent.getEventTime());
                this.track(motionEvent);
                return true;
            }
            case PANNING_HOLD_LOCKED_X: {
                this.setState(PanZoomState.PANNING_LOCKED_X);
                this.track(motionEvent);
                return true;
            }
            case PANNING_HOLD_LOCKED_Y: {
                this.setState(PanZoomState.PANNING_LOCKED_Y);
            }
            case PANNING_LOCKED_X: 
            case PANNING_LOCKED_Y: {
                this.track(motionEvent);
                return true;
            }
            case PANNING_HOLD: {
                this.setState(PanZoomState.PANNING);
            }
            case PANNING: {
                this.track(motionEvent);
                return true;
            }
            case PINCHING: {
                return false;
            }
        }
        Log.e((String)LOGTAG, (String)("Unhandled case " + (Object)((Object)this.mState) + " in handleTouchMove"));
        return false;
    }

    private boolean handleTouchEnd(MotionEvent motionEvent) {
        switch (this.mState) {
            case FLING: 
            case BOUNCE: 
            case ANIMATED_ZOOM: 
            case NOTHING: 
            case AUTONAV: {
                return false;
            }
            case WAITING_LISTENERS: {
                if (!this.mDefaultPrevented) {
                    Log.e((String)LOGTAG, (String)("Received impossible touch end while in " + (Object)((Object)this.mState)));
                }
            }
            case TOUCHING: {
                this.bounce();
                return false;
            }
            case PANNING: 
            case PANNING_LOCKED_X: 
            case PANNING_LOCKED_Y: 
            case PANNING_HOLD: 
            case PANNING_HOLD_LOCKED_X: 
            case PANNING_HOLD_LOCKED_Y: {
                this.setState(PanZoomState.FLING);
                this.fling();
                return true;
            }
            case PINCHING: {
                this.setState(PanZoomState.NOTHING);
                return true;
            }
        }
        Log.e((String)LOGTAG, (String)("Unhandled case " + (Object)((Object)this.mState) + " in handleTouchEnd"));
        return false;
    }

    private boolean handleTouchCancel(MotionEvent motionEvent) {
        this.cancelTouch();
        this.bounce();
        return false;
    }

    private boolean handlePointerScroll(MotionEvent motionEvent) {
        if (this.mState == PanZoomState.NOTHING || this.mState == PanZoomState.FLING) {
            float f = motionEvent.getAxisValue(10);
            float f2 = motionEvent.getAxisValue(9);
            if (this.mNegateWheelScroll) {
                f = (float)((double)f * -1.0);
                f2 = (float)((double)f2 * -1.0);
            }
            this.scrollBy(f * this.mPointerScrollFactor, f2 * this.mPointerScrollFactor);
            this.bounce();
            return true;
        }
        return false;
    }

    private float filterDeadZone(MotionEvent motionEvent, int n) {
        return GamepadUtils.isValueInDeadZone((MotionEvent)motionEvent, (int)n) ? 0.0f : motionEvent.getAxisValue(n);
    }

    private float normalizeJoystickScroll(MotionEvent motionEvent, int n) {
        return this.filterDeadZone(motionEvent, n) * MAX_SCROLL;
    }

    private float normalizeJoystickZoom(MotionEvent motionEvent, int n) {
        return this.filterDeadZone(motionEvent, n) * -0.125f;
    }

    private boolean handleJoystickNav(MotionEvent motionEvent) {
        float f = this.normalizeJoystickScroll(motionEvent, 0);
        float f2 = this.normalizeJoystickScroll(motionEvent, 1);
        float f3 = this.normalizeJoystickZoom(motionEvent, 14);
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
            if (this.mState == PanZoomState.AUTONAV) {
                this.bounce();
                return true;
            }
            return false;
        }
        if (this.mState == PanZoomState.NOTHING) {
            this.setState(PanZoomState.AUTONAV);
            this.startAnimationRenderTask(new AutonavRenderTask());
        }
        if (this.mState == PanZoomState.AUTONAV) {
            this.mX.setAutoscrollVelocity(f);
            this.mY.setAutoscrollVelocity(f2);
            this.mAutonavZoomDelta = f3;
            return true;
        }
        return false;
    }

    private void startTouch(float f, float f2, long l) {
        this.mX.startTouch(f);
        this.mY.startTouch(f2);
        this.setState(PanZoomState.TOUCHING);
        this.mLastEventTime = l;
    }

    private void startPanning(float f, float f2, long l) {
        float f3 = this.mX.panDistance(f);
        float f4 = this.mY.panDistance(f2);
        double d = Math.atan2(f4, f3);
        d = Math.abs(d);
        this.mX.startTouch(f);
        this.mY.startTouch(f2);
        this.mLastEventTime = l;
        if (this.mMode == AxisLockMode.STANDARD || this.mMode == AxisLockMode.STICKY) {
            if (!this.mX.scrollable() || !this.mY.scrollable()) {
                this.setState(PanZoomState.PANNING);
            } else if (d < 0.5235987755982988 || d > 2.6179938779914944) {
                this.mY.setScrollingDisabled(true);
                this.setState(PanZoomState.PANNING_LOCKED_X);
            } else if (Math.abs(d - 1.5707963267948966) < 0.5235987755982988) {
                this.mX.setScrollingDisabled(true);
                this.setState(PanZoomState.PANNING_LOCKED_Y);
            } else {
                this.setState(PanZoomState.PANNING);
            }
        } else if (this.mMode == AxisLockMode.FREE) {
            this.setState(PanZoomState.PANNING);
        }
    }

    private float panDistance(MotionEvent motionEvent) {
        float f = this.mX.panDistance(motionEvent.getX(0));
        float f2 = this.mY.panDistance(motionEvent.getY(0));
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    private void track(float f, float f2, long l) {
        float f3 = l - this.mLastEventTime;
        if (FloatUtils.fuzzyEquals((float)f3, (float)0.0f)) {
            return;
        }
        this.mLastEventTime = l;
        if (this.mMode == AxisLockMode.STICKY) {
            float f4 = this.mX.panDistance(f);
            float f5 = this.mY.panDistance(f2);
            double d = Math.atan2(f5, f4);
            d = Math.abs(d);
            if (Math.abs(f4) > AXIS_BREAKOUT_THRESHOLD || Math.abs(f5) > AXIS_BREAKOUT_THRESHOLD) {
                if (this.mState == PanZoomState.PANNING_LOCKED_X) {
                    if (d > 0.39269908169872414 && d < 2.748893571891069) {
                        this.mY.setScrollingDisabled(false);
                        this.setState(PanZoomState.PANNING);
                    }
                } else if (this.mState == PanZoomState.PANNING_LOCKED_Y && Math.abs(d - 1.5707963267948966) > 0.39269908169872414) {
                    this.mX.setScrollingDisabled(false);
                    this.setState(PanZoomState.PANNING);
                }
            }
        }
        this.mX.updateWithTouchAt(f, f3);
        this.mY.updateWithTouchAt(f2, f3);
    }

    private void track(MotionEvent motionEvent) {
        this.mX.saveTouchPos();
        this.mY.saveTouchPos();
        for (int i = 0; i < motionEvent.getHistorySize(); ++i) {
            this.track(motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i), motionEvent.getHistoricalEventTime(i));
        }
        this.track(motionEvent.getX(0), motionEvent.getY(0), motionEvent.getEventTime());
        if (this.stopped()) {
            if (this.mState == PanZoomState.PANNING) {
                this.setState(PanZoomState.PANNING_HOLD);
            } else if (this.mState == PanZoomState.PANNING_LOCKED_X) {
                this.setState(PanZoomState.PANNING_HOLD_LOCKED_X);
            } else if (this.mState == PanZoomState.PANNING_LOCKED_Y) {
                this.setState(PanZoomState.PANNING_HOLD_LOCKED_Y);
            } else {
                Log.e((String)LOGTAG, (String)("Impossible case " + (Object)((Object)this.mState) + " when stopped in track"));
                this.setState(PanZoomState.PANNING_HOLD);
            }
        }
        this.mX.startPan();
        this.mY.startPan();
        this.updatePosition();
    }

    private void scrollBy(float f, float f2) {
        this.mTarget.scrollBy(f, f2);
    }

    private void fling() {
        this.updatePosition();
        this.stopAnimationTask();
        boolean bl = this.stopped();
        this.mX.startFling(bl);
        this.mY.startFling(bl);
        this.startAnimationRenderTask(new FlingRenderTask());
    }

    private void bounce(ImmutableViewportMetrics immutableViewportMetrics, PanZoomState panZoomState) {
        this.stopAnimationTask();
        ImmutableViewportMetrics immutableViewportMetrics2 = this.getMetrics();
        if (immutableViewportMetrics2.fuzzyEquals(immutableViewportMetrics)) {
            this.setState(PanZoomState.NOTHING);
            return;
        }
        this.setState(panZoomState);
        this.mTarget.setAnimationTarget(immutableViewportMetrics);
        this.startAnimationRenderTask(new BounceRenderTask(immutableViewportMetrics2, immutableViewportMetrics));
    }

    private void bounce() {
        this.bounce(this.getValidViewportMetrics(), PanZoomState.BOUNCE);
    }

    private void startAnimationRenderTask(PanZoomRenderTask panZoomRenderTask) {
        if (this.mAnimationRenderTask != null) {
            Log.e((String)LOGTAG, (String)"Attempted to start a new task without canceling the old one!");
            this.stopAnimationTask();
        }
        this.mAnimationRenderTask = panZoomRenderTask;
        this.mTarget.postRenderTask(this.mAnimationRenderTask);
    }

    private void stopAnimationTask() {
        if (this.mAnimationRenderTask != null) {
            this.mAnimationRenderTask.terminate();
            this.mTarget.removeRenderTask(this.mAnimationRenderTask);
            this.mAnimationRenderTask = null;
        }
    }

    private float getVelocity() {
        float f = this.mX.getRealVelocity();
        float f2 = this.mY.getRealVelocity();
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    @Override
    public PointF getVelocityVector() {
        return new PointF(this.mX.getRealVelocity(), this.mY.getRealVelocity());
    }

    private boolean stopped() {
        return this.getVelocity() < 4.0f;
    }

    PointF resetDisplacement() {
        return new PointF(this.mX.resetDisplacement(), this.mY.resetDisplacement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePosition() {
        this.mX.displace();
        this.mY.displace();
        PointF pointF = this.resetDisplacement();
        if (FloatUtils.fuzzyEquals((float)pointF.x, (float)0.0f) && FloatUtils.fuzzyEquals((float)pointF.y, (float)0.0f)) {
            return;
        }
        if (!this.mDefaultPrevented && !this.mSubscroller.scrollBy(pointF)) {
            Object object = this.mTarget.getLock();
            synchronized (object) {
                this.scrollBy(pointF.x, pointF.y);
            }
        }
    }

    private void finishAnimation() {
        this.checkMainThread();
        this.stopAnimationTask();
        this.mTarget.forceRedraw(null);
    }

    private ImmutableViewportMetrics getValidViewportMetrics() {
        return this.getValidViewportMetrics(this.getMetrics());
    }

    private ImmutableViewportMetrics getValidViewportMetrics(ImmutableViewportMetrics immutableViewportMetrics) {
        float f;
        float f2;
        float f3 = immutableViewportMetrics.zoomFactor;
        RectF rectF = immutableViewportMetrics.getPageRect();
        RectF rectF2 = immutableViewportMetrics.getViewport();
        float f4 = rectF2.width() / 2.0f;
        float f5 = rectF2.height() / 2.0f;
        float f6 = 0.0f;
        float f7 = 4.0f;
        ZoomConstraints zoomConstraints = this.mTarget.getZoomConstraints();
        if (zoomConstraints.getMinZoom() > 0.0f || !zoomConstraints.getAllowZoom()) {
            f6 = zoomConstraints.getMinZoom();
        }
        if (zoomConstraints.getMaxZoom() > 0.0f || !zoomConstraints.getAllowZoom()) {
            f7 = zoomConstraints.getMaxZoom();
        }
        if (rectF.width() > 0.0f) {
            f2 = rectF.width();
            f = rectF2.width() / f2;
            f6 = Math.max(f6, f3 * f);
            if (rectF2.width() > f2) {
                f4 = 0.0f;
            }
        }
        if (rectF.height() > 0.0f) {
            f2 = rectF.height();
            f = rectF2.height() / f2;
            f6 = Math.max(f6, f3 * f);
            if (rectF2.height() > f2) {
                f5 = 0.0f;
            }
        }
        f7 = Math.max(f7, f6);
        if (f3 < f6) {
            PointF pointF = new PointF(f4, f5);
            immutableViewportMetrics = immutableViewportMetrics.scaleTo(f6, pointF);
        } else if (f3 > f7) {
            PointF pointF = new PointF(rectF2.width() / 2.0f, rectF2.height() / 2.0f);
            immutableViewportMetrics = immutableViewportMetrics.scaleTo(f7, pointF);
        }
        immutableViewportMetrics = immutableViewportMetrics.clamp();
        return immutableViewportMetrics;
    }

    @Override
    public boolean onScaleBegin(SimpleScaleGestureDetector simpleScaleGestureDetector) {
        if (this.mState == PanZoomState.ANIMATED_ZOOM) {
            return false;
        }
        if (!this.mTarget.getZoomConstraints().getAllowZoom()) {
            return false;
        }
        this.setState(PanZoomState.PINCHING);
        this.mLastZoomFocus = new PointF(simpleScaleGestureDetector.getFocusX(), simpleScaleGestureDetector.getFocusY());
        this.cancelTouch();
        GeckoEvent geckoEvent = GeckoEvent.createNativeGestureEvent(11, this.mLastZoomFocus, this.getMetrics().zoomFactor);
        if (geckoEvent != null) {
            GeckoAppShell.sendEventToGecko(geckoEvent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onScale(SimpleScaleGestureDetector simpleScaleGestureDetector) {
        if (this.mTarget.getFullScreenState() != FullScreenState.NONE) {
            return false;
        }
        if (this.mState != PanZoomState.PINCHING) {
            return false;
        }
        float f = simpleScaleGestureDetector.getPreviousSpan();
        if (FloatUtils.fuzzyEquals((float)f, (float)0.0f)) {
            return true;
        }
        Object object = this.mTarget.getLock();
        synchronized (object) {
            float f2 = this.getAdjustedZoomFactor(simpleScaleGestureDetector.getCurrentSpan() / f);
            this.scrollBy(this.mLastZoomFocus.x - simpleScaleGestureDetector.getFocusX(), this.mLastZoomFocus.y - simpleScaleGestureDetector.getFocusY());
            this.mLastZoomFocus.set(simpleScaleGestureDetector.getFocusX(), simpleScaleGestureDetector.getFocusY());
            ImmutableViewportMetrics immutableViewportMetrics = this.getMetrics().scaleTo(f2, this.mLastZoomFocus);
            if (this.mX.getOverScrollMode() == 2 || this.mY.getOverScrollMode() == 2) {
                immutableViewportMetrics = this.getValidViewportMetrics(immutableViewportMetrics);
            }
            this.mTarget.setViewportMetrics(immutableViewportMetrics);
        }
        object = GeckoEvent.createNativeGestureEvent(12, this.mLastZoomFocus, this.getMetrics().zoomFactor);
        if (object != null) {
            GeckoAppShell.sendEventToGecko((GeckoEvent)object);
        }
        return true;
    }

    private ImmutableViewportMetrics applyZoomDelta(ImmutableViewportMetrics immutableViewportMetrics, float f) {
        float f2 = immutableViewportMetrics.zoomFactor;
        float f3 = f2 + f;
        float f4 = this.getAdjustedZoomFactor(f3 / f2);
        PointF pointF = new PointF(immutableViewportMetrics.getWidth() / 2.0f, immutableViewportMetrics.getHeight() / 2.0f);
        immutableViewportMetrics = immutableViewportMetrics.scaleTo(f4, pointF);
        return immutableViewportMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean animatedScale(float f) {
        if (this.mState != PanZoomState.NOTHING && this.mState != PanZoomState.BOUNCE) {
            return false;
        }
        Object object = this.mTarget.getLock();
        synchronized (object) {
            ImmutableViewportMetrics immutableViewportMetrics = this.applyZoomDelta(this.getMetrics(), f);
            this.bounce(this.getValidViewportMetrics(immutableViewportMetrics), PanZoomState.BOUNCE);
        }
        return true;
    }

    private float getAdjustedZoomFactor(float f) {
        float f2 = Math.min(this.mX.getEdgeResistance(true), this.mY.getEdgeResistance(true));
        f = f > 1.0f ? 1.0f + (f - 1.0f) * f2 : 1.0f - (1.0f - f) * f2;
        float f3 = this.getMetrics().zoomFactor * f;
        float f4 = 0.0f;
        float f5 = 4.0f;
        ZoomConstraints zoomConstraints = this.mTarget.getZoomConstraints();
        if (zoomConstraints.getMinZoom() > 0.0f) {
            f4 = zoomConstraints.getMinZoom();
        }
        if (zoomConstraints.getMaxZoom() > 0.0f) {
            f5 = zoomConstraints.getMaxZoom();
        }
        if (f3 < f4) {
            float f6 = f4 - f3;
            f6 = 1.0f - (float)Math.exp(-f6 * 0.5f);
            f3 = f4 * (1.0f - f6 / 2.0f);
        }
        if (f3 > f5) {
            float f7 = f3 - f5;
            f7 = 1.0f - (float)Math.exp(-f7);
            f3 = f5 + f7;
        }
        return f3;
    }

    @Override
    public void onScaleEnd(SimpleScaleGestureDetector simpleScaleGestureDetector) {
        if (this.mState == PanZoomState.ANIMATED_ZOOM) {
            return;
        }
        this.startTouch(simpleScaleGestureDetector.getFocusX(), simpleScaleGestureDetector.getFocusY(), simpleScaleGestureDetector.getEventTime());
        this.mTarget.forceRedraw(null);
        PointF pointF = new PointF(simpleScaleGestureDetector.getFocusX(), simpleScaleGestureDetector.getFocusY());
        GeckoEvent geckoEvent = GeckoEvent.createNativeGestureEvent(13, pointF, this.getMetrics().zoomFactor);
        if (geckoEvent == null) {
            return;
        }
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    @Override
    public boolean getRedrawHint() {
        switch (this.mState) {
            case BOUNCE: 
            case ANIMATED_ZOOM: 
            case PINCHING: {
                return false;
            }
        }
        return true;
    }

    private void sendPointToGecko(String string2, MotionEvent motionEvent) {
        String string3;
        try {
            PointF pointF = new PointF(motionEvent.getX(), motionEvent.getY());
            pointF = this.mTarget.convertViewPointToLayerPoint(pointF);
            if (pointF == null) {
                return;
            }
            string3 = PointUtils.toJSON(pointF).toString();
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Unable to convert point to JSON for " + string2), (Throwable)exception);
            return;
        }
        GeckoAppShell.notifyObservers(string2, string3);
    }

    public boolean onDown(MotionEvent motionEvent) {
        this.mWaitForDoubleTap = this.mTarget.getZoomConstraints().getAllowDoubleTapZoom();
        return false;
    }

    public void onShowPress(MotionEvent motionEvent) {
        this.mWaitForDoubleTap = false;
    }

    @Override
    public void setIsLongpressEnabled(boolean bl) {
        this.isLongpressEnabled = bl;
    }

    public void onLongPress(MotionEvent motionEvent) {
        if (!this.isLongpressEnabled || this.mIgnoreLongPress) {
            return;
        }
        GeckoEvent geckoEvent = GeckoEvent.createLongPressEvent(motionEvent);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        if (!this.mWaitForDoubleTap) {
            this.sendPointToGecko("Gesture:SingleTap", motionEvent);
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
        if (this.mWaitForDoubleTap) {
            this.sendPointToGecko("Gesture:SingleTap", motionEvent);
        }
        return true;
    }

    public boolean onDoubleTap(MotionEvent motionEvent) {
        this.sendPointToGecko("Gesture:DoubleTap", motionEvent);
        return true;
    }

    private void cancelTouch() {
        GeckoAppShell.notifyObservers("Gesture:CancelTouch", "");
    }

    private ImmutableViewportMetrics getMetricsToZoomTo(RectF rectF) {
        float f;
        float f2;
        float f3 = this.getMetrics().zoomFactor;
        RectF rectF2 = this.getMetrics().getViewport();
        float f4 = rectF2.width() / rectF2.height();
        if (!FloatUtils.fuzzyEquals((float)f4, (float)(f2 = rectF.width() / rectF.height()))) {
            if (f4 < f2) {
                f = rectF.width() / f4;
                rectF.top -= (f - rectF.height()) / 2.0f;
                rectF.bottom = rectF.top + f;
            } else {
                f = f4 * rectF.height();
                rectF.left -= (f - rectF.width()) / 2.0f;
                rectF.right = rectF.left + f;
            }
        }
        f = rectF2.width() / rectF.width();
        ImmutableViewportMetrics immutableViewportMetrics = this.getMetrics();
        immutableViewportMetrics = immutableViewportMetrics.setViewportOrigin(rectF.left * immutableViewportMetrics.zoomFactor, rectF.top * immutableViewportMetrics.zoomFactor);
        immutableViewportMetrics = immutableViewportMetrics.scaleTo(f, new PointF(0.0f, 0.0f));
        immutableViewportMetrics = this.getValidViewportMetrics(immutableViewportMetrics);
        return immutableViewportMetrics;
    }

    private boolean animatedZoomTo(RectF rectF) {
        this.bounce(this.getMetricsToZoomTo(rectF), PanZoomState.ANIMATED_ZOOM);
        return true;
    }

    @Override
    public void abortPanning() {
        this.checkMainThread();
        this.bounce();
    }

    @Override
    public void setOverScrollMode(int n) {
        this.mX.setOverScrollMode(n);
        this.mY.setOverScrollMode(n);
    }

    @Override
    public int getOverScrollMode() {
        return this.mX.getOverScrollMode();
    }

    @Override
    public void setOverscrollHandler(Overscroll overscroll) {
        this.mOverscroll = overscroll;
    }

    @Override
    public ImmutableViewportMetrics adjustScrollForSurfaceShift(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
        return immutableViewportMetrics.offsetViewportByAndClamp(pointF.x, pointF.y);
    }

    private class AxisY
    extends Axis {
        AxisY(SubdocumentScrollHelper subdocumentScrollHelper) {
            super(subdocumentScrollHelper);
        }

        @Override
        public float getOrigin() {
            return ((JavaPanZoomController)JavaPanZoomController.this).getMetrics().viewportRectTop;
        }

        @Override
        protected float getViewportLength() {
            return JavaPanZoomController.this.getMetrics().getHeight();
        }

        @Override
        protected float getPageStart() {
            return ((JavaPanZoomController)JavaPanZoomController.this).getMetrics().pageRectTop;
        }

        @Override
        protected float getPageLength() {
            return JavaPanZoomController.this.getMetrics().getPageHeight();
        }

        @Override
        protected float getVisibleEndOfLayerView() {
            return ((JavaPanZoomController)JavaPanZoomController.this).mTarget.getVisibleEndOfLayerView().y;
        }

        @Override
        protected void overscrollFling(float f) {
            if (JavaPanZoomController.this.mOverscroll != null) {
                JavaPanZoomController.this.mOverscroll.setVelocity(f, Overscroll.Axis.Y);
            }
        }

        @Override
        protected void overscrollPan(float f) {
            if (JavaPanZoomController.this.mOverscroll != null) {
                JavaPanZoomController.this.mOverscroll.setDistance(f, Overscroll.Axis.Y);
            }
        }
    }

    private class AxisX
    extends Axis {
        AxisX(SubdocumentScrollHelper subdocumentScrollHelper) {
            super(subdocumentScrollHelper);
        }

        @Override
        public float getOrigin() {
            return ((JavaPanZoomController)JavaPanZoomController.this).getMetrics().viewportRectLeft;
        }

        @Override
        protected float getViewportLength() {
            return JavaPanZoomController.this.getMetrics().getWidth();
        }

        @Override
        protected float getPageStart() {
            return ((JavaPanZoomController)JavaPanZoomController.this).getMetrics().pageRectLeft;
        }

        @Override
        protected float getPageLength() {
            return JavaPanZoomController.this.getMetrics().getPageWidth();
        }

        @Override
        protected float getVisibleEndOfLayerView() {
            return ((JavaPanZoomController)JavaPanZoomController.this).mTarget.getVisibleEndOfLayerView().x;
        }

        @Override
        protected void overscrollFling(float f) {
            if (JavaPanZoomController.this.mOverscroll != null) {
                JavaPanZoomController.this.mOverscroll.setVelocity(f, Overscroll.Axis.X);
            }
        }

        @Override
        protected void overscrollPan(float f) {
            if (JavaPanZoomController.this.mOverscroll != null) {
                JavaPanZoomController.this.mOverscroll.setDistance(f, Overscroll.Axis.X);
            }
        }
    }

    private class FlingRenderTask
    extends PanZoomRenderTask {
        @Override
        protected void animateFrame() {
            boolean bl;
            if (JavaPanZoomController.this.mState != PanZoomState.FLING) {
                JavaPanZoomController.this.finishAnimation();
                return;
            }
            boolean bl2 = JavaPanZoomController.this.mX.advanceFling(this.mLastFrameTimeDelta);
            boolean bl3 = JavaPanZoomController.this.mY.advanceFling(this.mLastFrameTimeDelta);
            boolean bl4 = bl = JavaPanZoomController.this.mX.overscrolled() || JavaPanZoomController.this.mY.overscrolled();
            if (bl2 || bl3) {
                float f;
                JavaPanZoomController.this.updatePosition();
                float f2 = f = bl && !JavaPanZoomController.this.mSubscroller.scrolling() ? 4.0f : 0.1f;
                if (JavaPanZoomController.this.getVelocity() >= f) {
                    return;
                }
                JavaPanZoomController.this.mX.stopFling();
                JavaPanZoomController.this.mY.stopFling();
            }
            if (bl) {
                JavaPanZoomController.this.bounce();
            } else {
                JavaPanZoomController.this.finishAnimation();
                JavaPanZoomController.this.setState(PanZoomState.NOTHING);
            }
        }
    }

    private class BounceRenderTask
    extends PanZoomRenderTask {
        private final ImmutableViewportMetrics mBounceStartMetrics;
        private final ImmutableViewportMetrics mBounceEndMetrics;
        private long mBounceDuration;

        BounceRenderTask(ImmutableViewportMetrics immutableViewportMetrics, ImmutableViewportMetrics immutableViewportMetrics2) {
            this.mBounceStartMetrics = immutableViewportMetrics;
            this.mBounceEndMetrics = immutableViewportMetrics2;
        }

        @Override
        protected void animateFrame() {
            if (JavaPanZoomController.this.mState != PanZoomState.BOUNCE && JavaPanZoomController.this.mState != PanZoomState.ANIMATED_ZOOM) {
                JavaPanZoomController.this.finishAnimation();
                return;
            }
            this.mBounceDuration = this.mCurrentFrameStartTime - this.getStartTime();
            if (this.mBounceDuration < 250000000L) {
                this.advanceBounce();
                return;
            }
            this.finishBounce();
            JavaPanZoomController.this.finishAnimation();
            JavaPanZoomController.this.setState(PanZoomState.NOTHING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void advanceBounce() {
            Object object = JavaPanZoomController.this.mTarget.getLock();
            synchronized (object) {
                float f = JavaPanZoomController.easeOut((float)this.mBounceDuration / 2.5E8f);
                ImmutableViewportMetrics immutableViewportMetrics = this.mBounceStartMetrics.interpolate(this.mBounceEndMetrics, f);
                JavaPanZoomController.this.mTarget.setViewportMetrics(immutableViewportMetrics.setPageRectFrom(JavaPanZoomController.this.getMetrics()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishBounce() {
            Object object = JavaPanZoomController.this.mTarget.getLock();
            synchronized (object) {
                JavaPanZoomController.this.mTarget.setViewportMetrics(this.mBounceEndMetrics.setPageRectFrom(JavaPanZoomController.this.getMetrics()));
            }
        }
    }

    private class AutonavRenderTask
    extends PanZoomRenderTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void animateFrame() {
            if (JavaPanZoomController.this.mState != PanZoomState.AUTONAV) {
                JavaPanZoomController.this.finishAnimation();
                return;
            }
            JavaPanZoomController.this.updatePosition();
            Object object = JavaPanZoomController.this.mTarget.getLock();
            synchronized (object) {
                JavaPanZoomController.this.mTarget.setViewportMetrics(JavaPanZoomController.this.applyZoomDelta(JavaPanZoomController.this.getMetrics(), JavaPanZoomController.this.mAutonavZoomDelta));
            }
        }
    }

    private abstract class PanZoomRenderTask
    extends RenderTask {
        protected long mCurrentFrameStartTime;
        protected long mLastFrameTimeDelta;
        private final Runnable mRunnable;
        private boolean mContinueAnimation;

        public PanZoomRenderTask() {
            super(false);
            this.mRunnable = new Runnable(){

                @Override
                public final void run() {
                    if (PanZoomRenderTask.this.mContinueAnimation) {
                        PanZoomRenderTask.this.animateFrame();
                    }
                }
            };
            this.mContinueAnimation = true;
        }

        @Override
        protected final boolean internalRun(long l, long l2) {
            this.mCurrentFrameStartTime = l2;
            this.mLastFrameTimeDelta = l;
            JavaPanZoomController.this.mTarget.post(this.mRunnable);
            return this.mContinueAnimation;
        }

        protected abstract void animateFrame();

        public void terminate() {
            this.mContinueAnimation = false;
        }
    }

    private static enum AxisLockMode {
        STANDARD,
        FREE,
        STICKY;

    }

    private static enum PanZoomState {
        NOTHING,
        FLING,
        TOUCHING,
        PANNING_LOCKED_X,
        PANNING_LOCKED_Y,
        PANNING,
        PANNING_HOLD,
        PANNING_HOLD_LOCKED_X,
        PANNING_HOLD_LOCKED_Y,
        PINCHING,
        ANIMATED_ZOOM,
        BOUNCE,
        WAITING_LISTENERS,
        AUTONAV;

    }
}

