/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Rect;
import android.graphics.RectF;
import java.nio.FloatBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.util.FloatUtils;

public abstract class Layer {
    private final ReentrantLock mTransactionLock = new ReentrantLock();
    private boolean mInTransaction;
    private Rect mNewPosition;
    private float mNewResolution;
    protected Rect mPosition;
    protected float mResolution;

    public Layer() {
        this(null);
    }

    public Layer(IntSize intSize) {
        this.mPosition = intSize == null ? new Rect() : new Rect(0, 0, intSize.width, intSize.height);
        this.mResolution = 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean update(RenderContext renderContext) {
        if (this.mTransactionLock.isHeldByCurrentThread()) {
            throw new RuntimeException("draw() called while transaction lock held by this thread?!");
        }
        if (this.mTransactionLock.tryLock()) {
            try {
                this.performUpdates(renderContext);
                boolean bl = true;
                return bl;
            }
            finally {
                this.mTransactionLock.unlock();
            }
        }
        return false;
    }

    public abstract void draw(RenderContext var1);

    protected RectF getBounds(RenderContext renderContext) {
        return RectUtils.scale(new RectF(this.mPosition), renderContext.zoomFactor / this.mResolution);
    }

    public void beginTransaction() {
        if (this.mTransactionLock.isHeldByCurrentThread()) {
            throw new RuntimeException("Nested transactions are not supported");
        }
        this.mTransactionLock.lock();
        this.mInTransaction = true;
        this.mNewResolution = this.mResolution;
    }

    public void endTransaction() {
        if (!this.mInTransaction) {
            throw new RuntimeException("endTransaction() called outside a transaction");
        }
        this.mInTransaction = false;
        this.mTransactionLock.unlock();
    }

    protected boolean inTransaction() {
        return this.mInTransaction;
    }

    public Rect getPosition() {
        return this.mPosition;
    }

    public void setPosition(Rect rect) {
        if (!this.mInTransaction) {
            throw new RuntimeException("setPosition() is only valid inside a transaction");
        }
        this.mNewPosition = rect;
    }

    public float getResolution() {
        return this.mResolution;
    }

    public void setResolution(float f) {
        if (!this.mInTransaction) {
            throw new RuntimeException("setResolution() is only valid inside a transaction");
        }
        this.mNewResolution = f;
    }

    protected void performUpdates(RenderContext renderContext) {
        if (this.mNewPosition != null) {
            this.mPosition = this.mNewPosition;
            this.mNewPosition = null;
        }
        if (this.mNewResolution != 0.0f) {
            this.mResolution = this.mNewResolution;
            this.mNewResolution = 0.0f;
        }
    }

    protected final void fillRectCoordBuffer(float[] fArray, RectF rectF, float f, float f2, Rect rect, float f3, float f4) {
        fArray[0] = rectF.left / f;
        fArray[1] = rectF.bottom / f2;
        fArray[2] = 0.0f;
        fArray[3] = (float)rect.left / f3;
        fArray[4] = (float)rect.top / f4;
        fArray[5] = rectF.left / f;
        fArray[6] = rectF.top / f2;
        fArray[7] = 0.0f;
        fArray[8] = (float)rect.left / f3;
        fArray[9] = (float)rect.bottom / f4;
        fArray[10] = rectF.right / f;
        fArray[11] = rectF.bottom / f2;
        fArray[12] = 0.0f;
        fArray[13] = (float)rect.right / f3;
        fArray[14] = (float)rect.top / f4;
        fArray[15] = rectF.right / f;
        fArray[16] = rectF.top / f2;
        fArray[17] = 0.0f;
        fArray[18] = (float)rect.right / f3;
        fArray[19] = (float)rect.bottom / f4;
    }

    public static class RenderContext {
        public final RectF viewport;
        public final RectF pageRect;
        public final float zoomFactor;
        public final int positionHandle;
        public final int textureHandle;
        public final FloatBuffer coordBuffer;

        public RenderContext(RectF rectF, RectF rectF2, float f, int n, int n2, FloatBuffer floatBuffer) {
            this.viewport = rectF;
            this.pageRect = rectF2;
            this.zoomFactor = f;
            this.positionHandle = n;
            this.textureHandle = n2;
            this.coordBuffer = floatBuffer;
        }

        public boolean fuzzyEquals(RenderContext renderContext) {
            if (renderContext == null) {
                return false;
            }
            return RectUtils.fuzzyEquals(this.viewport, renderContext.viewport) && RectUtils.fuzzyEquals(this.pageRect, renderContext.pageRect) && FloatUtils.fuzzyEquals((float)this.zoomFactor, (float)renderContext.zoomFactor);
        }
    }
}

