/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.ImageLoader;

class PanelAuthLayout
extends LinearLayout {
    public PanelAuthLayout(Context context, HomeConfig.PanelConfig panelConfig) {
        super(context);
        HomeConfig.AuthConfig authConfig = panelConfig.getAuthConfig();
        if (authConfig == null) {
            throw new IllegalStateException("Can't create PanelAuthLayout without a valid AuthConfig");
        }
        this.setOrientation(1);
        LayoutInflater.from((Context)context).inflate(R.layout.panel_auth_layout, (ViewGroup)this);
        TextView textView = (TextView)this.findViewById(R.id.message);
        textView.setText((CharSequence)authConfig.getMessageText());
        Button button = (Button)this.findViewById(R.id.button);
        button.setText((CharSequence)authConfig.getButtonText());
        final String string2 = panelConfig.getId();
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GeckoAppShell.notifyObservers("HomePanels:Authenticate", string2);
            }
        });
        ImageView imageView = (ImageView)this.findViewById(R.id.image);
        String string3 = authConfig.getImageUrl();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            imageView.setImageResource(R.drawable.icon_home_empty_firefox);
        } else {
            ImageLoader.with(this.getContext()).load(string3).into(imageView);
        }
    }
}

