/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteClientsDialogFragment;
import org.mozilla.gecko.RemoteTabsExpandableListAdapter;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeExpandableListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.RemoteTabsBaseFragment;

public class RemoteTabsExpandableListFragment
extends RemoteTabsBaseFragment {
    private static final String LOGTAG = "GeckoRemoteTabsExpList";
    private HomeExpandableListView mList;

    public static RemoteTabsExpandableListFragment newInstance() {
        return new RemoteTabsExpandableListFragment();
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_remote_tabs_list_panel, viewGroup, false);
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mList = (HomeExpandableListView)view.findViewById(R.id.list);
        this.mList.setTag("remote_tabs");
        this.mList.setOnChildClickListener(new ExpandableListView.OnChildClickListener(){

            public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
                ExpandableListAdapter expandableListAdapter = expandableListView.getExpandableListAdapter();
                RemoteTab remoteTab = (RemoteTab)expandableListAdapter.getChild(n, n2);
                if (remoteTab == null) {
                    return false;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "remote_tabs");
                RemoteTabsExpandableListFragment.this.mUrlOpenListener.onUrlOpen(remoteTab.url, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
                return true;
            }
        });
        this.mList.setOnGroupClickListener(new ExpandableListView.OnGroupClickListener(){

            public boolean onGroupClick(ExpandableListView expandableListView, View view, int n, long l) {
                ExpandableListAdapter expandableListAdapter = expandableListView.getExpandableListAdapter();
                RemoteClient remoteClient = (RemoteClient)expandableListAdapter.getGroup(n);
                if (remoteClient != null) {
                    RemoteTabsBaseFragment.sState.setClientCollapsed(remoteClient.guid, RemoteTabsExpandableListFragment.this.mList.isGroupExpanded(n));
                }
                return false;
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.ExpandableFactory(){

            @Override
            public HomeContextMenuInfo makeInfoForAdapter(View view, int n, long l, ExpandableListAdapter expandableListAdapter) {
                long l2 = RemoteTabsExpandableListFragment.this.mList.getExpandableListPosition(n);
                int n2 = ExpandableListView.getPackedPositionGroup((long)l2);
                int n3 = ExpandableListView.getPackedPositionType((long)l2);
                if (n3 == 1) {
                    int n4 = ExpandableListView.getPackedPositionChild((long)l2);
                    RemoteTab remoteTab = (RemoteTab)expandableListAdapter.getChild(n2, n4);
                    HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                    homeContextMenuInfo.url = remoteTab.url;
                    homeContextMenuInfo.title = remoteTab.title;
                    return homeContextMenuInfo;
                }
                if (n3 == 0) {
                    RemoteClient remoteClient = (RemoteClient)expandableListAdapter.getGroup(n2);
                    RemoteTabsBaseFragment.RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = new RemoteTabsBaseFragment.RemoteTabsClientContextMenuInfo(view, n, l, remoteClient);
                    return remoteTabsClientContextMenuInfo;
                }
                return null;
            }
        });
        this.registerForContextMenu((View)this.mList);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.mList.setOnChildClickListener(null);
        this.mList.setOnGroupClickListener(null);
        this.mList = null;
        this.mEmptyView = null;
    }

    @Override
    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mFooterView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.home_remote_tabs_hidden_devices_footer, (ViewGroup)this.mList, false);
        View view = this.mFooterView.findViewById(R.id.hidden_devices);
        view.setClickable(true);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RemoteClientsDialogFragment remoteClientsDialogFragment = RemoteClientsDialogFragment.newInstance(RemoteTabsExpandableListFragment.this.getResources().getString(R.string.home_remote_tabs_hidden_devices_title), RemoteTabsExpandableListFragment.this.getResources().getString(R.string.home_remote_tabs_unhide_selected_devices), RemoteClientsDialogFragment.ChoiceMode.MULTIPLE, new ArrayList<RemoteClient>(RemoteTabsExpandableListFragment.this.mHiddenClients));
                remoteClientsDialogFragment.setTargetFragment(RemoteTabsExpandableListFragment.this, 0);
                remoteClientsDialogFragment.show(RemoteTabsExpandableListFragment.this.getActivity().getSupportFragmentManager(), "dialog_tag_remote_tabs");
            }
        });
        this.mList.addFooterView(this.mFooterView, null, true);
        this.mAdapter = new RemoteTabsExpandableListAdapter(R.layout.home_remote_tabs_group, R.layout.home_remote_tabs_child, null, true);
        this.mList.setAdapter((ExpandableListAdapter)this.mAdapter);
        this.mList.removeFooterView(this.mFooterView);
        this.mCursorLoaderCallbacks = new RemoteTabsBaseFragment.CursorLoaderCallbacks(this);
        this.loadIfVisible();
    }

    @Override
    protected void updateUiFromClients(List<RemoteClient> list, List<RemoteClient> list2) {
        RemoteClient remoteClient;
        TextView textView;
        if (this.getView() == null) {
            return;
        }
        boolean bl = false;
        if (list2 == null || list2.isEmpty()) {
            this.mList.removeFooterView(this.mFooterView);
        } else {
            bl = true;
            textView = (TextView)this.mFooterView.findViewById(R.id.hidden_devices);
            if (list2.size() == 1) {
                textView.setText((CharSequence)this.getResources().getString(R.string.home_remote_tabs_one_hidden_device));
            } else {
                textView.setText((CharSequence)this.getResources().getString(R.string.home_remote_tabs_many_hidden_devices, new Object[]{list2.size()}));
            }
            if (this.mList.getFooterViewsCount() < 1) {
                this.mList.addFooterView(this.mFooterView);
            }
        }
        if (list != null && !list.isEmpty()) {
            bl = true;
            int n = Math.min(this.mList.getExpandableListAdapter().getGroupCount(), list.size());
            for (int i = 0; i < n; ++i) {
                remoteClient = list.get(i);
                if (sState.isClientCollapsed(remoteClient.guid)) {
                    this.mList.collapseGroup(i);
                    continue;
                }
                this.mList.expandGroup(i);
            }
        }
        if (bl) {
            return;
        }
        if (this.mEmptyView == null) {
            textView = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = textView.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_remote_tabs_empty);
            remoteClient = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            remoteClient.setText(R.string.home_remote_tabs_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }
}

