/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.push;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.AtomicFile;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.push.PushRegistration;

public class PushState {
    private static final String LOG_TAG = "GeckoPushState";
    private static final long VERSION = 1L;
    @NonNull
    protected final AtomicFile file;
    @NonNull
    protected final Map<String, PushRegistration> registrations = new HashMap<String, PushRegistration>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PushState(Context context, @NonNull String string2) {
        AtomicFile atomicFile = this.file = new AtomicFile(new File(context.getApplicationInfo().dataDir, string2));
        synchronized (atomicFile) {
            try {
                String string3 = new String(this.file.readFully(), "UTF-8");
                JSONObject jSONObject = new JSONObject(string3);
                if (jSONObject.optLong("version", 0L) != 1L) {
                    throw new JSONException("Unknown version!");
                }
                JSONObject jSONObject2 = jSONObject.getJSONObject("registrations");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    PushRegistration pushRegistration = PushRegistration.fromJSONObject(jSONObject2.getJSONObject(string4));
                    this.registrations.put(string4, pushRegistration);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.i((String)LOG_TAG, (String)"No storage found; starting fresh.");
                this.registrations.clear();
            }
            catch (IOException | JSONException throwable) {
                Log.w((String)LOG_TAG, (String)"Got exception reading storage; dropping storage and starting fresh.", (Throwable)throwable);
                this.registrations.clear();
            }
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, PushRegistration> entry : this.registrations.entrySet()) {
            jSONObject.put(entry.getKey(), (Object)entry.getValue().toJSONObject());
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("version", 1L);
        jSONObject2.put("registrations", (Object)jSONObject);
        return jSONObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean checkpoint() {
        AtomicFile atomicFile = this.file;
        synchronized (atomicFile) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = this.file.startWrite();
                fileOutputStream.write(this.toJSONObject().toString().getBytes("UTF-8"));
                this.file.finishWrite(fileOutputStream);
                return true;
            }
            catch (IOException | JSONException throwable) {
                Log.e((String)LOG_TAG, (String)"Got exception writing JSON storage; ignoring.", (Throwable)throwable);
                if (fileOutputStream != null) {
                    this.file.failWrite(fileOutputStream);
                }
                return false;
            }
        }
    }

    public PushRegistration putRegistration(@NonNull String string2, @NonNull PushRegistration pushRegistration) {
        return this.registrations.put(string2, pushRegistration);
    }

    public PushRegistration getRegistration(@NonNull String string2) {
        return this.registrations.get(string2);
    }

    @NonNull
    public Map<String, PushRegistration> getRegistrations() {
        return this.registrations;
    }

    public PushRegistration removeRegistration(@NonNull String string2) {
        return this.registrations.remove(string2);
    }
}

