/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.reader;

import android.content.Context;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.reader.SavedReaderViewHelper;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public final class ReadingListHelper
implements NativeEventListener {
    private static final String LOGTAG = "GeckoReadingListHelper";
    protected final Context context;
    private final BrowserDB db;

    public ReadingListHelper(Context context, GeckoProfile geckoProfile) {
        this.context = context;
        this.db = geckoProfile.getDB();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Reader:FaviconRequest", "Reader:AddedToCache");
    }

    public void uninit() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Reader:FaviconRequest", "Reader:AddedToCache");
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        switch (string2) {
            case "Reader:FaviconRequest": {
                this.handleReaderModeFaviconRequest(eventCallback, nativeJSObject.getString("url"));
                break;
            }
            case "Reader:AddedToCache": {
                this.handleAddedToCache(nativeJSObject.getString("url"), nativeJSObject.getString("path"), nativeJSObject.getInt("size"));
            }
        }
    }

    private void handleReaderModeFaviconRequest(final EventCallback eventCallback, final String string2) {
        new UIAsyncTask.WithoutParams<String>(ThreadUtils.getBackgroundHandler()){

            public String doInBackground() {
                return Favicons.getFaviconURLForPageURL(ReadingListHelper.this.db, ReadingListHelper.this.context.getContentResolver(), string2);
            }

            public void onPostExecute(String string22) {
                JSONObject jSONObject = new JSONObject();
                if (string22 != null) {
                    try {
                        jSONObject.put("url", (Object)string2);
                        jSONObject.put("faviconUrl", (Object)string22);
                    }
                    catch (JSONException jSONException) {
                        Log.w((String)ReadingListHelper.LOGTAG, (String)"Error building JSON favicon arguments.", (Throwable)jSONException);
                    }
                }
                eventCallback.sendSuccess((Object)jSONObject.toString());
            }
        }.execute();
    }

    private void handleAddedToCache(String string2, String string3, int n) {
        SavedReaderViewHelper savedReaderViewHelper = SavedReaderViewHelper.getSavedReaderViewHelper(this.context);
        savedReaderViewHelper.put(string2, string3, n);
    }

    public static void cacheReaderItem(String string2, Context context) {
        if (AboutPages.isAboutReader(string2)) {
            throw new IllegalArgumentException("Page url must be original (not about:reader) url");
        }
        SavedReaderViewHelper savedReaderViewHelper = SavedReaderViewHelper.getSavedReaderViewHelper(context);
        if (!savedReaderViewHelper.isURLCached(string2)) {
            GeckoAppShell.notifyObservers("Reader:AddToCache", string2);
        }
    }

    public static void removeCachedReaderItem(String string2, Context context) {
        if (AboutPages.isAboutReader(string2)) {
            throw new IllegalArgumentException("Page url must be original (not about:reader) url");
        }
        SavedReaderViewHelper savedReaderViewHelper = SavedReaderViewHelper.getSavedReaderViewHelper(context);
        if (savedReaderViewHelper.isURLCached(string2)) {
            GeckoAppShell.notifyObservers("Reader:RemoveFromCache", string2);
        }
        savedReaderViewHelper.remove(string2);
    }
}

