/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoThread
extends Thread {
    private static final String LOGTAG = "GeckoThread";
    public static final State MIN_STATE = State.INITIAL;
    public static final State MAX_STATE = State.EXITED;
    private static volatile State sState = State.INITIAL;
    private static final int QUEUED_CALLS_COUNT = 16;
    private static final ArrayList<QueuedCall> QUEUED_CALLS = new ArrayList(16);
    private static GeckoThread sGeckoThread;
    @WrapForJNI
    private static final ClassLoader clsLoader;
    @WrapForJNI
    private static MessageQueue msgQueue;
    private GeckoProfile mProfile;
    private final String mArgs;
    private final String mAction;
    private final boolean mDebugging;

    GeckoThread(GeckoProfile geckoProfile, String string2, String string3, boolean bl) {
        this.mProfile = geckoProfile;
        this.mArgs = string2;
        this.mAction = string3;
        this.mDebugging = bl;
        this.setName("Gecko");
    }

    public static boolean init(GeckoProfile geckoProfile, String string2, String string3, boolean bl) {
        ThreadUtils.assertOnUiThread();
        if (GeckoThread.isState(State.INITIAL) && sGeckoThread == null) {
            sGeckoThread = new GeckoThread(geckoProfile, string2, string3, bl);
            return true;
        }
        return false;
    }

    public static boolean initWithProfile(String string2, File file) {
        if (string2 == null) {
            throw new IllegalArgumentException("Null profile name");
        }
        GeckoProfile geckoProfile = GeckoThread.getActiveProfile();
        if (geckoProfile == null) {
            Context context = GeckoAppShell.getApplicationContext();
            return GeckoThread.init(GeckoProfile.get(context, string2, file), null, null, false);
        }
        try {
            return file == null ? string2.equals(geckoProfile.getName()) : geckoProfile.getDir().getCanonicalPath().equals(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)("Cannot compare profile " + string2));
            return false;
        }
    }

    public static boolean launch() {
        ThreadUtils.assertOnUiThread();
        if (GeckoThread.checkAndSetState(State.INITIAL, State.LAUNCHED)) {
            sGeckoThread.start();
            return true;
        }
        return false;
    }

    public static boolean isLaunched() {
        return !GeckoThread.isState(State.INITIAL);
    }

    @RobocopTarget
    public static boolean isRunning() {
        return GeckoThread.isState(State.RUNNING);
    }

    private static void invokeMethod(Method method, Object object, Object[] objectArray) {
        try {
            method.setAccessible(true);
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unexpected exception", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Cannot make call", invocationTargetException.getCause());
        }
    }

    private static void queueNativeCallLocked(Class<?> clazz, String string2, Object object, Object[] objectArray, State state) {
        Method method;
        ArrayList arrayList = new ArrayList(objectArray.length);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Class) {
                arrayList.add((Class)objectArray[i]);
                arrayList2.add(objectArray[++i]);
                continue;
            }
            Class<Object> clazz2 = objectArray[i].getClass();
            if (clazz2 == Boolean.class) {
                clazz2 = Boolean.TYPE;
            } else if (clazz2 == Byte.class) {
                clazz2 = Byte.TYPE;
            } else if (clazz2 == Character.class) {
                clazz2 = Character.TYPE;
            } else if (clazz2 == Double.class) {
                clazz2 = Double.TYPE;
            } else if (clazz2 == Float.class) {
                clazz2 = Float.TYPE;
            } else if (clazz2 == Integer.class) {
                clazz2 = Integer.TYPE;
            } else if (clazz2 == Long.class) {
                clazz2 = Long.TYPE;
            } else if (clazz2 == Short.class) {
                clazz2 = Short.TYPE;
            }
            arrayList.add(clazz2);
            arrayList2.add(objectArray[i]);
        }
        try {
            method = clazz.getDeclaredMethod(string2, arrayList.toArray(new Class[arrayList.size()]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Cannot find method", noSuchMethodException);
        }
        if (!Modifier.isNative(method.getModifiers())) {
            throw new UnsupportedOperationException("Not allowed to queue non-native methods");
        }
        if (GeckoThread.isStateAtLeast(state)) {
            GeckoThread.invokeMethod(method, object, arrayList2.toArray());
            return;
        }
        QUEUED_CALLS.add(new QueuedCall(method, object, arrayList2.toArray(), state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueNativeCallUntil(State state, Class<?> clazz, String string2, Object ... objectArray) {
        ArrayList<QueuedCall> arrayList = QUEUED_CALLS;
        synchronized (arrayList) {
            GeckoThread.queueNativeCallLocked(clazz, string2, null, objectArray, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueNativeCall(Class<?> clazz, String string2, Object ... objectArray) {
        ArrayList<QueuedCall> arrayList = QUEUED_CALLS;
        synchronized (arrayList) {
            GeckoThread.queueNativeCallLocked(clazz, string2, null, objectArray, State.RUNNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueNativeCallUntil(State state, Object object, String string2, Object ... objectArray) {
        ArrayList<QueuedCall> arrayList = QUEUED_CALLS;
        synchronized (arrayList) {
            GeckoThread.queueNativeCallLocked(object.getClass(), string2, object, objectArray, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueNativeCall(Object object, String string2, Object ... objectArray) {
        ArrayList<QueuedCall> arrayList = QUEUED_CALLS;
        synchronized (arrayList) {
            GeckoThread.queueNativeCallLocked(object.getClass(), string2, object, objectArray, State.RUNNING);
        }
    }

    private static void flushQueuedNativeCallsLocked(State state) {
        int n = -1;
        for (int i = 0; i < QUEUED_CALLS.size(); ++i) {
            QueuedCall queuedCall = QUEUED_CALLS.get(i);
            if (queuedCall == null) continue;
            if (!state.isAtLeast(queuedCall.state)) {
                n = i;
                continue;
            }
            QUEUED_CALLS.set(i, null);
            if (queuedCall.method == null) {
                GeckoEvent geckoEvent = (GeckoEvent)queuedCall.target;
                GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
                geckoEvent.recycle();
                continue;
            }
            GeckoThread.invokeMethod(queuedCall.method, queuedCall.target, queuedCall.args);
        }
        if (n < 0) {
            QUEUED_CALLS.clear();
            QUEUED_CALLS.trimToSize();
        } else if (n < QUEUED_CALLS.size() - 1) {
            QUEUED_CALLS.subList(n + 1, QUEUED_CALLS.size()).clear();
        }
    }

    private static String initGeckoEnvironment() {
        Object object;
        String[] stringArray;
        Context context = GeckoAppShell.getApplicationContext();
        GeckoLoader.loadMozGlue((Context)context);
        GeckoThread.setState(State.MOZGLUE_READY);
        Locale locale = Locale.getDefault();
        Resources resources = context.getResources();
        if (locale.toString().equalsIgnoreCase("zh_hk")) {
            stringArray = Locale.TRADITIONAL_CHINESE;
            Locale.setDefault((Locale)stringArray);
            object = resources.getConfiguration();
            object.locale = stringArray;
            resources.updateConfiguration(object, null);
        }
        stringArray = null;
        try {
            stringArray = GeckoAppShell.getPluginDirectories();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Caught exception getting plugin dirs.", (Throwable)exception);
        }
        object = context.getPackageResourcePath();
        GeckoLoader.setupGeckoEnvironment((Context)context, (String[])stringArray, (String)context.getFilesDir().getPath());
        GeckoLoader.loadSQLiteLibs((Context)context, (String)object);
        GeckoLoader.loadNSSLibs((Context)context, (String)object);
        GeckoLoader.loadGeckoLibs((Context)context, (String)object);
        GeckoThread.setState(State.LIBS_READY);
        return object;
    }

    private static String getTypeFromAction(String string2) {
        if ("org.mozilla.gecko.BOOKMARK".equals(string2)) {
            return "-bookmark";
        }
        return null;
    }

    private String addCustomProfileArg(String string2) {
        String string3 = "";
        if (this.mProfile != null && this.mProfile.inGuestMode()) {
            string3 = " -profile " + this.mProfile.getDir().getAbsolutePath();
            if (string2 == null || !string2.contains("--guest")) {
                string3 = string3 + " --guest";
            }
        } else {
            GeckoProfile geckoProfile = this.getProfile();
            geckoProfile.forceCreate();
            if (string2 == null || !string2.matches(".*\\B-(P|profile)\\s+\\S+.*")) {
                string3 = geckoProfile.isCustomProfile() ? " -profile " + geckoProfile.getDir().getAbsolutePath() : " -P " + geckoProfile.getName();
            }
        }
        return (string2 != null ? string2 : "") + string3;
    }

    private String getGeckoArgs(String string2) {
        String string3;
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(" -greomni ").append(string2);
        String string4 = this.addCustomProfileArg(this.mArgs);
        if (string4 != null) {
            stringBuilder.append(' ').append(string4);
        }
        if ((string3 = GeckoThread.getTypeFromAction(this.mAction)) != null) {
            stringBuilder.append(" ").append(string3);
        }
        return stringBuilder.toString();
    }

    public static GeckoProfile getActiveProfile() {
        if (sGeckoThread == null) {
            return null;
        }
        GeckoProfile geckoProfile = GeckoThread.sGeckoThread.mProfile;
        if (geckoProfile != null) {
            return geckoProfile;
        }
        return sGeckoThread.getProfile();
    }

    public synchronized GeckoProfile getProfile() {
        if (this.mProfile == null) {
            Context context = GeckoAppShell.getApplicationContext();
            this.mProfile = GeckoProfile.getFromArgs(context, this.mArgs);
            if (this.mProfile == null) {
                this.mProfile = GeckoProfile.getDefaultProfile(context);
            }
        }
        return this.mProfile;
    }

    @Override
    public void run() {
        Looper.prepare();
        msgQueue = Looper.myQueue();
        ThreadUtils.sGeckoThread = this;
        ThreadUtils.sGeckoHandler = new Handler();
        MessageQueue.IdleHandler idleHandler = new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                Handler handler = ThreadUtils.sGeckoHandler;
                Message message = Message.obtain((Handler)handler);
                message.obj = handler;
                handler.sendMessageAtFrontOfQueue(message);
                return true;
            }
        };
        Looper.myQueue().addIdleHandler(idleHandler);
        if (this.mDebugging) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String string2 = this.getGeckoArgs(GeckoThread.initGeckoEnvironment());
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoAppShell.registerJavaUiThread();
            }
        });
        Log.w((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - runGecko"));
        GeckoLoader.nativeRun((String)string2);
        GeckoThread.setState(State.EXITED);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("type", (Object)"Gecko:Exited");
            EventDispatcher.getInstance().dispatchEvent(jSONObject, null);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"unable to dispatch event", (Throwable)jSONException);
        }
        Looper.myQueue().removeIdleHandler(idleHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPendingEvent(GeckoEvent geckoEvent) {
        ArrayList<QueuedCall> arrayList = QUEUED_CALLS;
        synchronized (arrayList) {
            if (GeckoThread.isRunning()) {
                GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
                geckoEvent.recycle();
            } else {
                QUEUED_CALLS.add(new QueuedCall(null, geckoEvent, null, State.RUNNING));
            }
        }
    }

    @WrapForJNI
    private static boolean pumpMessageLoop(Message message) {
        Handler handler = ThreadUtils.sGeckoHandler;
        if (message.obj == handler && message.getTarget() == handler) {
            return false;
        }
        if (message.getTarget() == null) {
            Looper.myLooper().quit();
        } else {
            message.getTarget().dispatchMessage(message);
        }
        return true;
    }

    public static boolean isState(State state) {
        return sState.is(state);
    }

    public static boolean isStateAtLeast(State state) {
        return sState.isAtLeast(state);
    }

    public static boolean isStateAtMost(State state) {
        return sState.isAtMost(state);
    }

    public static boolean isStateBetween(State state, State state2) {
        return sState.isBetween(state, state2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapForJNI
    private static void setState(State state) {
        ThreadUtils.assertOnGeckoThread();
        ArrayList<QueuedCall> arrayList = QUEUED_CALLS;
        synchronized (arrayList) {
            GeckoThread.flushQueuedNativeCallsLocked(state);
            sState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapForJNI
    private static boolean checkAndSetState(State state, State state2) {
        ArrayList<QueuedCall> arrayList = QUEUED_CALLS;
        synchronized (arrayList) {
            if (sState == state) {
                GeckoThread.flushQueuedNativeCallsLocked(state2);
                sState = state2;
                return true;
            }
        }
        return false;
    }

    @WrapForJNI(stubName="SpeculativeConnect")
    private static native void speculativeConnectNative(String var0);

    public static void speculativeConnect(String string2) {
        GeckoThread.queueNativeCallUntil(State.PROFILE_READY, GeckoThread.class, "speculativeConnectNative", string2);
    }

    @WrapForJNI
    @RobocopTarget
    public static native void waitOnGecko();

    @WrapForJNI(stubName="OnPause")
    private static native void nativeOnPause();

    public static void onPause() {
        if (GeckoThread.isStateAtLeast(State.PROFILE_READY)) {
            GeckoThread.nativeOnPause();
        } else {
            GeckoThread.queueNativeCallUntil(State.PROFILE_READY, GeckoThread.class, "nativeOnPause", new Object[0]);
        }
    }

    @WrapForJNI(stubName="OnResume")
    private static native void nativeOnResume();

    public static void onResume() {
        if (GeckoThread.isStateAtLeast(State.PROFILE_READY)) {
            GeckoThread.nativeOnResume();
        } else {
            GeckoThread.queueNativeCallUntil(State.PROFILE_READY, GeckoThread.class, "nativeOnResume", new Object[0]);
        }
    }

    static {
        clsLoader = GeckoThread.class.getClassLoader();
    }

    private static class QueuedCall {
        public Method method;
        public Object target;
        public Object[] args;
        public State state;

        public QueuedCall(Method method, Object object, Object[] objectArray, State state) {
            this.method = method;
            this.target = object;
            this.args = objectArray;
            this.state = state;
        }
    }

    @WrapForJNI
    public static enum State {
        INITIAL,
        LAUNCHED,
        MOZGLUE_READY,
        LIBS_READY,
        JNI_READY,
        PROFILE_READY,
        RUNNING,
        EXITING,
        EXITED;


        public boolean is(State state) {
            return this == state;
        }

        public boolean isAtLeast(State state) {
            return this.ordinal() >= state.ordinal();
        }

        public boolean isAtMost(State state) {
            return this.ordinal() <= state.ordinal();
        }

        public boolean isBetween(State state, State state2) {
            int n = this.ordinal();
            return n >= state.ordinal() && n <= state2.ordinal();
        }
    }
}

