/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.util.HardwareUtils;

public class HomeConfigPrefsBackend
implements HomeConfig.HomeConfigBackend {
    private static final String LOGTAG = "GeckoHomeConfigBackend";
    private static final int VERSION = 4;
    public static final String PREFS_CONFIG_KEY_OLD = "home_panels";
    public static final String PREFS_CONFIG_KEY = "home_panels_with_version";
    private static final String JSON_KEY_PANELS = "panels";
    private static final String JSON_KEY_VERSION = "version";
    private static final String PREFS_LOCALE_KEY = "home_locale";
    private static final String RELOAD_BROADCAST = "HomeConfigPrefsBackend:Reload";
    private final Context mContext;
    private ReloadBroadcastReceiver mReloadBroadcastReceiver;
    private HomeConfig.OnReloadListener mReloadListener;
    private static boolean sMigrationDone;

    public HomeConfigPrefsBackend(Context context) {
        this.mContext = context;
    }

    private SharedPreferences getSharedPreferences() {
        return GeckoSharedPrefs.forProfile(this.mContext);
    }

    private HomeConfig.State loadDefaultConfig() {
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.TOP_SITES, EnumSet.of(HomeConfig.PanelConfig.Flags.DEFAULT_PANEL)));
        arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.BOOKMARKS));
        arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.COMBINED_HISTORY));
        arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.RECENT_TABS));
        arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.READING_LIST));
        return new HomeConfig.State(arrayList, true);
    }

    private static boolean allPanelsAreDisabled(JSONArray jSONArray) throws JSONException {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (jSONObject.optBoolean("disabled", false)) continue;
            return false;
        }
        return true;
    }

    protected static void addBuiltinPanelConfig(Context context, JSONArray jSONArray, HomeConfig.PanelType panelType, Position position, Position position2) throws JSONException {
        boolean bl;
        JSONObject jSONObject = HomeConfig.createBuiltinPanelConfig(context, panelType).toJSON();
        jSONObject.put("disabled", HomeConfigPrefsBackend.allPanelsAreDisabled(jSONArray));
        boolean bl2 = HardwareUtils.isTablet();
        boolean bl3 = bl = !bl2;
        if (bl && position == Position.FRONT || bl2 && position2 == Position.FRONT) {
            for (int i = jSONArray.length(); i >= 1; --i) {
                jSONArray.put(i, jSONArray.get(i - 1));
            }
            jSONArray.put(0, (Object)jSONObject);
        }
        if (bl && position == Position.BACK || bl2 && position2 == Position.BACK) {
            jSONArray.put((Object)jSONObject);
        }
    }

    private static JSONArray combineHistoryAndSyncPanels(Context context, JSONArray jSONArray) throws JSONException {
        HomeConfig.PanelConfig panelConfig;
        int n;
        int n2;
        HomeConfig.PanelType panelType;
        EnumSet<HomeConfig.PanelConfig.Flags> enumSet = null;
        EnumSet<HomeConfig.PanelConfig.Flags> enumSet2 = null;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            HomeConfig.PanelConfig panelConfig2 = new HomeConfig.PanelConfig(jSONObject);
            panelType = panelConfig2.getType();
            if (panelType == HomeConfig.PanelType.HISTORY) {
                n3 = i;
                enumSet = panelConfig2.getFlags();
                continue;
            }
            if (panelType != HomeConfig.PanelType.REMOTE_TABS) continue;
            n4 = i;
            enumSet2 = panelConfig2.getFlags();
        }
        if (n3 == -1 || n4 == -1) {
            throw new IllegalArgumentException("Missing default panels");
        }
        if (enumSet.contains((Object)HomeConfig.PanelConfig.Flags.DISABLED_PANEL) && !enumSet2.contains((Object)HomeConfig.PanelConfig.Flags.DISABLED_PANEL)) {
            n2 = n4;
            n = n3;
            panelConfig = HomeConfig.createBuiltinPanelConfig(context, HomeConfig.PanelType.COMBINED_HISTORY, enumSet2);
        } else {
            n2 = n3;
            n = n4;
            panelConfig = HomeConfig.createBuiltinPanelConfig(context, HomeConfig.PanelType.COMBINED_HISTORY, enumSet);
        }
        panelType = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            if (i == n2) {
                panelType.put(panelConfig.toJSON());
                continue;
            }
            if (i == n) continue;
            panelType.put(jSONArray.get(i));
        }
        return panelType;
    }

    private static boolean readingListPanelExists(JSONArray jSONArray) {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                HomeConfig.PanelConfig panelConfig = new HomeConfig.PanelConfig(jSONObject);
                if (panelConfig.getType() != HomeConfig.PanelType.READING_LIST) continue;
                return true;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception loading PanelConfig from JSON", (Throwable)exception);
            }
        }
        return false;
    }

    private static synchronized JSONArray maybePerformMigration(Context context, String string2) throws JSONException {
        JSONObject jSONObject;
        int n;
        JSONArray jSONArray;
        if (sMigrationDone) {
            JSONObject jSONObject2 = new JSONObject(string2);
            return jSONObject2.getJSONArray(JSON_KEY_PANELS);
        }
        sMigrationDone = true;
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(context);
        if (sharedPreferences.contains(PREFS_CONFIG_KEY_OLD)) {
            jSONArray = new JSONArray(string2);
            n = 0;
        } else {
            jSONObject = new JSONObject(string2);
            jSONArray = jSONObject.getJSONArray(JSON_KEY_PANELS);
            n = jSONObject.getInt(JSON_KEY_VERSION);
        }
        if (n == 4) {
            return jSONArray;
        }
        Log.d((String)LOGTAG, (String)"Performing migration");
        jSONObject = sharedPreferences.edit();
        block6: for (int i = n + 1; i <= 4; ++i) {
            Log.d((String)LOGTAG, (String)("Migrating to version = " + i));
            switch (i) {
                case 1: {
                    HomeConfigPrefsBackend.addBuiltinPanelConfig(context, jSONArray, HomeConfig.PanelType.RECENT_TABS, Position.FRONT, Position.BACK);
                    jSONObject.remove(PREFS_CONFIG_KEY_OLD);
                    continue block6;
                }
                case 2: {
                    HomeConfigPrefsBackend.addBuiltinPanelConfig(context, jSONArray, HomeConfig.PanelType.REMOTE_TABS, Position.FRONT, Position.BACK);
                    continue block6;
                }
                case 3: {
                    if (HomeConfigPrefsBackend.readingListPanelExists(jSONArray)) continue block6;
                    HomeConfigPrefsBackend.addBuiltinPanelConfig(context, jSONArray, HomeConfig.PanelType.READING_LIST, Position.BACK, Position.BACK);
                    continue block6;
                }
                case 4: {
                    jSONArray = HomeConfigPrefsBackend.combineHistoryAndSyncPanels(context, jSONArray);
                }
            }
        }
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put(JSON_KEY_PANELS, (Object)jSONArray);
        jSONObject3.put(JSON_KEY_VERSION, 4);
        jSONObject.putString(PREFS_CONFIG_KEY, jSONObject3.toString());
        jSONObject.apply();
        return jSONArray;
    }

    private HomeConfig.State loadConfigFromString(String string2) {
        JSONArray jSONArray;
        try {
            jSONArray = HomeConfigPrefsBackend.maybePerformMigration(this.mContext, string2);
            this.updatePrefsFromConfig(jSONArray);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error loading the list of home panels from JSON prefs", (Throwable)jSONException);
            return this.loadDefaultConfig();
        }
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                HomeConfig.PanelConfig panelConfig = new HomeConfig.PanelConfig(jSONObject);
                arrayList.add(panelConfig);
                continue;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception loading PanelConfig from JSON", (Throwable)exception);
            }
        }
        return new HomeConfig.State(arrayList, false);
    }

    @Override
    public HomeConfig.State load() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String string2 = sharedPreferences.contains(PREFS_CONFIG_KEY_OLD) ? PREFS_CONFIG_KEY_OLD : PREFS_CONFIG_KEY;
        String string3 = sharedPreferences.getString(string2, null);
        HomeConfig.State state = TextUtils.isEmpty((CharSequence)string3) ? this.loadDefaultConfig() : this.loadConfigFromString(string3);
        return state;
    }

    @Override
    public void save(HomeConfig.State state) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (!state.isDefault()) {
            JSONArray jSONArray = new JSONArray();
            for (HomeConfig.PanelConfig panelConfig : state) {
                try {
                    JSONObject jSONObject = panelConfig.toJSON();
                    jSONArray.put((Object)jSONObject);
                }
                catch (Exception exception) {
                    Log.e((String)LOGTAG, (String)"Exception converting PanelConfig to JSON", (Throwable)exception);
                }
            }
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(JSON_KEY_PANELS, (Object)jSONArray);
                jSONObject.put(JSON_KEY_VERSION, 4);
                editor.putString(PREFS_CONFIG_KEY, jSONObject.toString());
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Exception saving PanelConfig state", (Throwable)jSONException);
            }
        }
        editor.putString(PREFS_LOCALE_KEY, Locale.getDefault().toString());
        editor.apply();
        this.sendReloadBroadcast();
    }

    @Override
    public String getLocale() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String string2 = sharedPreferences.getString(PREFS_LOCALE_KEY, null);
        if (string2 == null) {
            String string3 = Locale.getDefault().toString();
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREFS_LOCALE_KEY, string3);
            editor.apply();
            if (!sharedPreferences.contains(PREFS_CONFIG_KEY)) {
                string2 = string3;
            }
        }
        return string2;
    }

    @Override
    public void setOnReloadListener(HomeConfig.OnReloadListener onReloadListener) {
        if (this.mReloadListener != null) {
            this.unregisterReloadReceiver();
            this.mReloadBroadcastReceiver = null;
        }
        this.mReloadListener = onReloadListener;
        if (this.mReloadListener != null) {
            this.mReloadBroadcastReceiver = new ReloadBroadcastReceiver();
            this.registerReloadReceiver();
        }
    }

    private void updatePrefsFromConfig(JSONArray jSONArray) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(this.mContext);
        if (!sharedPreferences.contains("bookmarksPanelEnabled") || !sharedPreferences.contains("historyPanelEnabled")) {
            String string2 = HomeConfig.PanelType.BOOKMARKS.toString();
            String string3 = HomeConfig.PanelType.HISTORY.toString();
            try {
                JSONObject jSONObject;
                String string4;
                for (int i = 0; i < jSONArray.length() && (string4 = (jSONObject = jSONArray.getJSONObject(i)).optString("type", null)) != null; ++i) {
                    boolean bl = jSONObject.optBoolean("disabled", false);
                    if (string2.equals(string4)) {
                        sharedPreferences.edit().putBoolean("bookmarksPanelEnabled", !bl).apply();
                        continue;
                    }
                    if (!string3.equals(string4)) continue;
                    sharedPreferences.edit().putBoolean("historyPanelEnabled", !bl).apply();
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error fetching panel from config to update prefs");
            }
        }
    }

    private void sendReloadBroadcast() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.mContext);
        Intent intent = new Intent(RELOAD_BROADCAST);
        localBroadcastManager.sendBroadcast(intent);
    }

    private void registerReloadReceiver() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.mContext);
        localBroadcastManager.registerReceiver((BroadcastReceiver)this.mReloadBroadcastReceiver, new IntentFilter(RELOAD_BROADCAST));
    }

    private void unregisterReloadReceiver() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.mContext);
        localBroadcastManager.unregisterReceiver((BroadcastReceiver)this.mReloadBroadcastReceiver);
    }

    private class ReloadBroadcastReceiver
    extends BroadcastReceiver {
        private ReloadBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            HomeConfigPrefsBackend.this.mReloadListener.onReload();
        }
    }

    protected static enum Position {
        NONE,
        FRONT,
        BACK;

    }
}

