/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.promotion;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import ch.boye.httpclientandroidlib.util.TextUtils;
import com.keepsafe.switchboard.SwitchBoard;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.promotion.HomeScreenPrompt;
import org.mozilla.gecko.util.ThreadUtils;

public class AddToHomeScreenPromotion
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoPromoteShortcut";
    private static final String EXPERIMENT_MINIMUM_TOTAL_VISITS = "minimumTotalVisits";
    private static final String EXPERIMENT_LAST_VISIT_MINIMUM_AGE = "lastVisitMinimumAgeMs";
    private static final String EXPERIMENT_LAST_VISIT_MAXIMUM_AGE = "lastVisitMaximumAgeMs";
    private Activity activity;
    private boolean isEnabled;
    private int minimumVisits;
    private int lastVisitMinimumAgeMs;
    private int lastVisitMaximumAgeMs;

    public AddToHomeScreenPromotion(Activity activity) {
        this.activity = activity;
        this.initializeExperiment();
    }

    public void resume() {
        Tabs.registerOnTabsChangedListener(this);
    }

    public void pause() {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    private void initializeExperiment() {
        if (!SwitchBoard.isInExperiment((Context)this.activity, (String)"promote-add-to-homescreen")) {
            Log.v((String)LOGTAG, (String)"Experiment not enabled");
            return;
        }
        JSONObject jSONObject = SwitchBoard.getExperimentValuesFromJson((Context)this.activity, (String)"promote-add-to-homescreen");
        if (jSONObject == null) {
            return;
        }
        try {
            this.initializeWithValues(jSONObject.getInt(EXPERIMENT_MINIMUM_TOTAL_VISITS), jSONObject.getInt(EXPERIMENT_LAST_VISIT_MINIMUM_AGE), jSONObject.getInt(EXPERIMENT_LAST_VISIT_MAXIMUM_AGE));
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Could not read experiment values", (Throwable)jSONException);
        }
    }

    private void initializeWithValues(int n, int n2, int n3) {
        this.isEnabled = true;
        this.minimumVisits = n;
        this.lastVisitMinimumAgeMs = n2;
        this.lastVisitMaximumAgeMs = n3;
    }

    @Override
    public void onTabChanged(final Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tab == null) {
            return;
        }
        if (!Tabs.getInstance().isSelectedTab(tab)) {
            return;
        }
        if (Tabs.TabEvents.LOADED == tabEvents) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    AddToHomeScreenPromotion.this.maybeShowPromotionForUrl(tab.getURL(), tab.getTitle());
                }
            });
        }
    }

    private void maybeShowPromotionForUrl(String string2, String string3) {
        if (!this.isEnabled) {
            return;
        }
        if (!this.shouldShowPromotion(string2, string3)) {
            return;
        }
        HomeScreenPrompt.show((Context)this.activity, string2, string3);
    }

    private boolean shouldShowPromotion(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            return false;
        }
        if (AboutPages.isAboutPage(string2)) {
            return false;
        }
        if (!string2.startsWith("https://")) {
            return false;
        }
        URLHistory uRLHistory = this.getHistoryForURL(string2);
        if (uRLHistory == null) {
            return false;
        }
        if (uRLHistory.visits < (long)this.minimumVisits) {
            return false;
        }
        if (uRLHistory.lastVisit > System.currentTimeMillis() - (long)this.lastVisitMinimumAgeMs) {
            return false;
        }
        if (uRLHistory.lastVisit < System.currentTimeMillis() - (long)this.lastVisitMaximumAgeMs) {
            return false;
        }
        return !this.hasAcceptedOrDeclinedHomeScreenShortcut(string2);
    }

    protected boolean hasAcceptedOrDeclinedHomeScreenShortcut(String string2) {
        UrlAnnotations urlAnnotations = GeckoProfile.get((Context)this.activity).getDB().getUrlAnnotations();
        return urlAnnotations.hasAcceptedOrDeclinedHomeScreenShortcut(this.activity.getContentResolver(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URLHistory getHistoryForURL(String string2) {
        GeckoProfile geckoProfile = GeckoProfile.get((Context)this.activity);
        BrowserDB browserDB = geckoProfile.getDB();
        try (Cursor cursor = null;){
            cursor = browserDB.getHistoryForURL(this.activity.getContentResolver(), string2);
            if (cursor.moveToFirst()) {
                URLHistory uRLHistory = new URLHistory(cursor.getInt(cursor.getColumnIndex("visits")), cursor.getLong(cursor.getColumnIndex("date")));
                return uRLHistory;
            }
        }
        return null;
    }

    private static class URLHistory {
        public final long visits;
        public final long lastVisit;

        private URLHistory(long l, long l2) {
            this.visits = l;
            this.lastVisit = l2;
        }
    }
}

