/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.promotion;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.util.ThreadUtils;

public class HomeScreenPrompt
extends Locales.LocaleAwareActivity
implements OnFaviconLoadedListener {
    private static final String EXTRA_TITLE = "title";
    private static final String EXTRA_URL = "url";
    private static final String TELEMETRY_EXTRA = "home_screen_promotion";
    private View containerView;
    private ImageView iconView;
    private String title;
    private String url;
    private boolean isAnimating;
    private boolean hasAccepted;

    public static void show(Context context, String string2, String string3) {
        Intent intent = new Intent(context, HomeScreenPrompt.class);
        intent.putExtra(EXTRA_TITLE, string3);
        intent.putExtra(EXTRA_URL, string2);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.fetchDataFromIntent();
        this.setupViews();
        this.loadShortcutIcon();
        this.slideIn();
        Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "promote-add-to-homescreen");
        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.SERVICE, TELEMETRY_EXTRA);
    }

    protected void onDestroy() {
        super.onDestroy();
        Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, "promote-add-to-homescreen");
    }

    private void fetchDataFromIntent() {
        Bundle bundle = this.getIntent().getExtras();
        this.title = bundle.getString(EXTRA_TITLE);
        this.url = bundle.getString(EXTRA_URL);
    }

    private void setupViews() {
        this.setContentView(R.layout.homescreen_prompt);
        ((TextView)this.findViewById(R.id.title)).setText((CharSequence)this.title);
        Uri uri = Uri.parse((String)this.url);
        ((TextView)this.findViewById(R.id.host)).setText((CharSequence)uri.getHost());
        this.containerView = this.findViewById(R.id.container);
        this.iconView = (ImageView)this.findViewById(R.id.icon);
        this.findViewById(R.id.add).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeScreenPrompt.this.hasAccepted = true;
                HomeScreenPrompt.this.addToHomeScreen();
            }
        });
        this.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeScreenPrompt.this.rememberRejection();
                HomeScreenPrompt.this.slideOut();
                Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BUTTON, HomeScreenPrompt.TELEMETRY_EXTRA);
            }
        });
    }

    private void addToHomeScreen() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoAppShell.createShortcut(HomeScreenPrompt.this.title, HomeScreenPrompt.this.url);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, HomeScreenPrompt.TELEMETRY_EXTRA);
                HomeScreenPrompt.this.goToHomeScreen();
            }
        });
    }

    private void goToHomeScreen() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.setFlags(0x10000000);
        this.startActivity(intent);
        this.finish();
    }

    private void loadShortcutIcon() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Favicons.getPreferredIconForHomeScreenShortcut((Context)HomeScreenPrompt.this, HomeScreenPrompt.this.url, HomeScreenPrompt.this);
            }
        });
    }

    private void slideIn() {
        this.containerView.setTranslationY(500.0f);
        this.containerView.setAlpha(0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.containerView, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        animatorSet.start();
    }

    private void rememberRejection() {
        if (this.hasAccepted) {
            return;
        }
        UrlAnnotations urlAnnotations = GeckoProfile.get((Context)this).getDB().getUrlAnnotations();
        urlAnnotations.insertHomeScreenShortcut(this.getContentResolver(), this.url, false);
    }

    private void slideOut() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getHeight()});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                HomeScreenPrompt.this.finish();
            }
        });
        objectAnimator.start();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    public void onBackPressed() {
        this.rememberRejection();
        this.slideOut();
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK, TELEMETRY_EXTRA);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.rememberRejection();
        this.slideOut();
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK, TELEMETRY_EXTRA);
        return true;
    }

    @Override
    public void onFaviconLoaded(String string2, String string3, final Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HomeScreenPrompt.this.iconView.setImageBitmap(bitmap);
            }
        });
    }
}

