/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.reader;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.reader.ReaderModeUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class SavedReaderViewHelper {
    private static final String LOG_TAG = "SavedReaderViewHelper";
    private static final String PATH = "path";
    private static final String SIZE = "size";
    private static final String DIRECTORY = "readercache";
    private static final String FILE_NAME = "items.json";
    private static final String FILE_PATH = "readercache/items.json";
    private JSONObject mItems = null;
    private final Context mContext;
    private static SavedReaderViewHelper instance = null;

    private SavedReaderViewHelper(Context context) {
        this.mContext = context;
    }

    public static synchronized SavedReaderViewHelper getSavedReaderViewHelper(Context context) {
        if (instance == null) {
            instance = new SavedReaderViewHelper(context);
        }
        return instance;
    }

    public synchronized void loadItems() {
        ThreadUtils.assertNotOnUiThread();
        if (this.mItems != null) {
            return;
        }
        try {
            this.mItems = GeckoProfile.get(this.mContext).readJSONObjectFromFile(FILE_PATH);
        }
        catch (IOException iOException) {
            this.mItems = new JSONObject();
        }
    }

    private synchronized void assertItemsLoaded() {
        if (this.mItems == null) {
            throw new IllegalStateException("SavedReaderView items must be explicitly loaded using loadItems() before access.");
        }
    }

    private JSONObject makeItem(@NonNull String string2, long l) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(PATH, (Object)string2);
        jSONObject.put(SIZE, l);
        return jSONObject;
    }

    public synchronized boolean isURLCached(@NonNull String string2) {
        this.assertItemsLoaded();
        return this.mItems.has(string2);
    }

    public synchronized void put(final @NonNull String string2, @NonNull String string3, long l) {
        this.assertItemsLoaded();
        try {
            this.mItems.put(string2, (Object)this.makeItem(string3, l));
        }
        catch (JSONException jSONException) {
            Log.w((String)LOG_TAG, (String)"Item insertion failed:", (Throwable)jSONException);
            throw new IllegalStateException("Failure inserting into SavedReaderViewHelper json");
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UrlAnnotations urlAnnotations = GeckoProfile.get(SavedReaderViewHelper.this.mContext).getDB().getUrlAnnotations();
                urlAnnotations.insertReaderViewUrl(SavedReaderViewHelper.this.mContext.getContentResolver(), string2);
                SavedReaderViewHelper.this.commit();
            }
        });
    }

    protected synchronized void remove(final @NonNull String string2) {
        this.assertItemsLoaded();
        this.mItems.remove(string2);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UrlAnnotations urlAnnotations = GeckoProfile.get(SavedReaderViewHelper.this.mContext).getDB().getUrlAnnotations();
                urlAnnotations.deleteReaderViewUrl(SavedReaderViewHelper.this.mContext.getContentResolver(), string2);
                SavedReaderViewHelper.this.commit();
            }
        });
    }

    @RobocopTarget
    public synchronized int size() {
        this.assertItemsLoaded();
        return this.mItems.length();
    }

    private synchronized void commit() {
        ThreadUtils.assertOnBackgroundThread();
        GeckoProfile geckoProfile = GeckoProfile.get(this.mContext);
        File file = new File(geckoProfile.getDir(), DIRECTORY);
        if (!file.exists()) {
            Log.i((String)LOG_TAG, (String)"No preexisting cache directory, creating now");
            boolean bl = file.mkdir();
            if (!bl) {
                throw new IllegalStateException("Couldn't create cache directory, unable to track reader view cache");
            }
        }
        geckoProfile.writeFile(FILE_PATH, this.mItems.toString());
    }

    public static String getReaderURLIfCached(Context context, @NonNull String string2) {
        SavedReaderViewHelper savedReaderViewHelper = SavedReaderViewHelper.getSavedReaderViewHelper(context);
        if (savedReaderViewHelper.isURLCached(string2)) {
            return ReaderModeUtils.getAboutReaderForUrl(string2);
        }
        return string2;
    }
}

